/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.rms;

import com.sun.squawk.Address;
import com.sun.squawk.flash.IMemoryHeapBlock;
import com.sun.squawk.rms.IRecordEntry;
import com.sun.squawk.rms.IRecordStoreEntry;
import com.sun.squawk.rms.IRecordStoreManager;
import com.sun.squawk.rms.IRmsEntry;
import com.sun.squawk.rms.IRmsEntryVisitor;
import com.sun.squawk.rms.RecordEntry;
import com.sun.squawk.rms.RmsEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;

public class RecordStoreEntry
extends RmsEntry
implements IRecordStoreEntry {
    public static final int TYPE = 3;
    protected static final int INSERT_PADDING = 10;
    protected IRecordStoreManager manager;
    protected int id;
    protected int[] recordIds;
    protected Address[] recordAddresses;
    protected String name;
    protected int numRecords;
    protected int lastRecordId;
    protected long lastModifiedTimestamp;
    protected int version;

    public RecordStoreEntry(IRecordStoreManager manager) {
        this.manager = manager;
        this.lastRecordId = 0;
        this.recordIds = new int[10];
        this.recordAddresses = new Address[this.recordIds.length];
        this.name = "";
        this.address = Address.zero();
    }

    public void absorbTempEntry(IRecordStoreEntry tempEntry) {
        RecordStoreEntry castTempEntry = (RecordStoreEntry)tempEntry;
        this.recordAddresses = castTempEntry.recordAddresses;
        this.recordIds = castTempEntry.recordIds;
        this.lastRecordId = castTempEntry.lastRecordId;
        this.lastModifiedTimestamp = castTempEntry.lastModifiedTimestamp;
        this.numRecords = castTempEntry.numRecords;
    }

    public int addRecord(byte[] bytes, int offset, int length) throws RecordStoreException, RecordStoreFullException {
        RecordEntry record = new RecordEntry();
        record.setBytes(bytes, offset, length);
        record.setStoreId(this.id);
        record.setId(this.lastRecordId + 1);
        Address address = this.manager.logEntry(record);
        int index = this.numRecords;
        this.insertAtIndex(index);
        this.recordIds[index] = ++this.lastRecordId;
        this.recordAddresses[index] = address;
        this.changed();
        return this.lastRecordId;
    }

    protected void changed() {
        this.lastModifiedTimestamp = System.currentTimeMillis();
        ++this.version;
    }

    public void deleteRecord(int recordId) throws InvalidRecordIDException, RecordStoreException {
        int index = this.findRecordIndex(recordId);
        this.findRecord(recordId);
        this.manager.invalidateEntryAt(this.recordAddresses[index]);
        System.arraycopy(this.recordIds, index + 1, this.recordIds, index, this.recordIds.length - index - 1);
        this.recordIds[this.numRecords - 1] = 0;
        System.arraycopy(this.recordAddresses, index + 1, this.recordAddresses, index, this.recordAddresses.length - index - 1);
        this.recordAddresses[this.numRecords - 1] = Address.zero();
        --this.numRecords;
        this.changed();
    }

    public void deleteRecords() throws RecordStoreException {
        int max = this.numRecords;
        for (int i = 0; i < max; ++i) {
            if (!this.recordAddresses[i].ne(Address.zero())) continue;
            this.manager.invalidateEntryAt(this.recordAddresses[i]);
            this.recordAddresses[i] = Address.zero();
            this.recordIds[i] = 0;
        }
    }

    protected Address findRecordAddress(int recordId) throws InvalidRecordIDException, RecordStoreException {
        int index = this.findRecordIndex(recordId);
        if (index < 0) {
            throw new InvalidRecordIDException("No record with id: " + recordId);
        }
        return this.recordAddresses[index];
    }

    protected int findRecordIndex(int recordId) {
        int low = 0;
        int high = this.numRecords - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = this.recordIds[mid];
            if (midVal < (long)recordId) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)recordId) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected IRecordEntry findRecord(int recordId) throws InvalidRecordIDException, RecordStoreException {
        Address recordAddress = this.findRecordAddress(recordId);
        IRmsEntry entry = this.manager.getEntryAt(recordAddress);
        if (!(entry instanceof IRecordEntry)) {
            throw new RecordStoreException("System error found a non record entry where one expected for id: " + recordId);
        }
        return (IRecordEntry)entry;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getNextRecordId() {
        return this.lastRecordId + 1;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public byte[] getRecord(int recordId) throws InvalidRecordIDException, RecordStoreException {
        IRecordEntry record = this.findRecord(recordId);
        return record.getBytes();
    }

    public int getRecord(int recordId, byte[] buffer, int offset) throws InvalidRecordIDException, RecordStoreException {
        IRecordEntry record = this.findRecord(recordId);
        return record.getBytes(buffer, offset, record.getBytesLength());
    }

    public int[] getRecordIdsCopy() {
        int[] copy = new int[this.numRecords];
        System.arraycopy(this.recordIds, 0, copy, 0, this.numRecords);
        return copy;
    }

    public int getRecordSize(int recordId) throws InvalidRecordIDException, RecordStoreException {
        IRecordEntry record = this.findRecord(recordId);
        return record.getBytesLength();
    }

    public int getRecordsSize() throws RecordStoreException {
        int size = 0;
        try {
            int max = this.numRecords;
            for (int i = 0; i < max; ++i) {
                IRmsEntry entry = this.manager.getEntryAt(this.recordAddresses[i]);
                if (!(entry instanceof IRecordEntry)) {
                    throw new RecordStoreException("System error found a non record entry where one expected");
                }
                size += ((IRecordEntry)entry).getBytesLength();
            }
        }
        catch (RecordStoreException e) {
            throw new RuntimeException(e.getMessage());
        }
        return size;
    }

    public long getTimestamp() {
        return this.lastModifiedTimestamp;
    }

    public int getType() {
        return 3;
    }

    public int getVersion() {
        return this.version;
    }

    protected void insertAtIndex(int index) {
        if (this.numRecords == this.recordIds.length) {
            int[] tempIds = new int[this.recordIds.length + 10];
            System.arraycopy(this.recordIds, 0, tempIds, 0, index);
            if (index != this.numRecords) {
                System.arraycopy(this.recordIds, index, tempIds, index + 1, this.recordIds.length - index);
            }
            this.recordIds = tempIds;
            Address[] tempAddresses = new Address[this.recordIds.length];
            System.arraycopy(this.recordAddresses, 0, tempAddresses, 0, index);
            tempAddresses[index] = Address.zero();
            if (index != this.numRecords) {
                System.arraycopy(this.recordAddresses, index, tempAddresses, index + 1, this.recordAddresses.length - index);
            }
            this.recordAddresses = tempAddresses;
        } else if (index != this.numRecords) {
            System.arraycopy(this.recordIds, index, this.recordIds, index + 1, this.recordIds.length - index - 1);
            this.recordIds[index] = 0;
            System.arraycopy(this.recordAddresses, index, this.recordAddresses, index + 1, this.recordAddresses.length - index - 1);
            this.recordAddresses[index] = Address.zero();
        } else {
            this.recordAddresses[this.numRecords] = Address.zero();
        }
        ++this.numRecords;
    }

    public void readFrom(IMemoryHeapBlock memoryBlock) throws IOException {
        super.readFrom(memoryBlock);
        DataInputStream input = memoryBlock.getDataInputStream();
        this.id = input.readInt();
        this.name = input.readUTF();
        this.lastModifiedTimestamp = input.readLong();
        this.version = input.readInt();
    }

    public void reVisitRecordEntry(IRecordEntry record) throws RecordStoreException {
        int recordId = record.getId();
        int index = this.findRecordIndex(recordId);
        if (index < 0) {
            throw new RecordStoreException("System error, record should have been found");
        }
        this.recordAddresses[index] = record.getAddress();
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRecord(int recordId, byte[] bytes, int offset, int length) throws InvalidRecordIDException, RecordStoreException, RecordStoreFullException {
        int index = this.findRecordIndex(recordId);
        if (index < 0) {
            throw new InvalidRecordIDException();
        }
        Address oldAddress = this.recordAddresses[index];
        RecordEntry record = new RecordEntry();
        record.setBytes(bytes, offset, length);
        record.setStoreId(this.id);
        record.setId(recordId);
        this.recordAddresses[index] = this.manager.logEntry(record);
        this.manager.invalidateEntryAt(oldAddress);
        this.changed();
    }

    public void visit(IRmsEntryVisitor visitor) throws RecordStoreException {
        visitor.visitRecordStore(this);
    }

    public void visitRecordEntry(IRecordEntry record) throws RecordStoreException {
        int recordId = record.getId();
        int index = this.findRecordIndex(recordId);
        if (index < 0) {
            index = -index - 1;
            this.insertAtIndex(index);
            this.recordIds[index] = recordId;
            this.recordAddresses[index] = record.getAddress();
        } else {
            this.manager.invalidateEntryAt(this.recordAddresses[index]);
            this.recordAddresses[index] = record.getAddress();
        }
        if (recordId > this.lastRecordId) {
            this.lastRecordId = recordId;
        }
    }

    public void writeTo(DataOutputStream dataOut) throws IOException {
        super.writeTo(dataOut);
        dataOut.writeInt(this.id);
        dataOut.writeUTF(this.name);
        dataOut.writeLong(this.lastModifiedTimestamp);
        dataOut.writeInt(this.version);
    }
}

