/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.rms;

import com.sun.squawk.Address;
import com.sun.squawk.VM;
import com.sun.squawk.flash.IMemoryHeapBlock;
import com.sun.squawk.flash.INorFlashMemoryHeap;
import com.sun.squawk.flash.INorFlashMemoryHeapScanner;
import com.sun.squawk.rms.ApplicationDescriptorEntry;
import com.sun.squawk.rms.IApplicationDescriptorEntry;
import com.sun.squawk.rms.IRecordStoreEntry;
import com.sun.squawk.rms.IRecordStoreManager;
import com.sun.squawk.rms.IRmsEntry;
import com.sun.squawk.rms.IRmsEntryVisitor;
import com.sun.squawk.rms.RecordEntry;
import com.sun.squawk.rms.RecordStoreEntry;
import com.sun.squawk.rms.RecordStoreManagerReScanVisitor;
import com.sun.squawk.rms.RecordStoreManagerScanVisitor;
import com.sun.squawk.rms.RecordStoreSequenceEntry;
import com.sun.squawk.rms.RmsEntry;
import com.sun.squawk.rms.UnknownEntry;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.rms.RecordStoreException;

public class RecordStoreManager
implements IRecordStoreManager {
    protected INorFlashMemoryHeap memoryHeap;
    protected IRecordStoreEntry[] currentRecordStores;
    protected IApplicationDescriptorEntry currentApplicationDescriptor;
    protected INorFlashMemoryHeapScanner memoryHeapScanner;
    protected IRmsEntryVisitor scanVisitor;
    protected IRmsEntryVisitor reScanVisitor;

    protected RecordStoreManager() {
    }

    public RecordStoreManager(INorFlashMemoryHeap memoryHeap) throws RecordStoreException {
        this.memoryHeap = memoryHeap;
        this.memoryHeapScanner = this;
        this.init();
    }

    public RecordStoreManager(INorFlashMemoryHeap memoryHeap, INorFlashMemoryHeapScanner memoryHeapScanner, IRmsEntryVisitor scanVisitor, IRmsEntryVisitor reScanVisitor) throws RecordStoreException {
        this.memoryHeap = memoryHeap;
        this.memoryHeapScanner = memoryHeapScanner;
        this.scanVisitor = scanVisitor;
        this.reScanVisitor = reScanVisitor;
        this.currentRecordStores = new IRecordStoreEntry[4];
        this.init();
    }

    protected String checkMIDletVersion(String nameInstalled, String vendorInstalled, String versionInstalled) {
        if (this.currentApplicationDescriptor == null) {
            return "Initializing RMS for MID-let: " + nameInstalled + ", -Version: " + versionInstalled + ", -Vendor: " + vendorInstalled;
        }
        String nameFound = this.currentApplicationDescriptor.getMidletName();
        String vendorFound = this.currentApplicationDescriptor.getMidletVendor();
        String versionFound = this.currentApplicationDescriptor.getMidletVersion();
        if (nameInstalled == null) {
            nameInstalled = "";
        }
        if (!nameInstalled.equals(nameFound)) {
            return "Erasing RMS, since installed MIDlet-Name: " + nameInstalled + " does not match prior -Name: " + nameFound;
        }
        if (vendorInstalled == null) {
            vendorInstalled = "";
        }
        if (!vendorInstalled.equals(vendorFound)) {
            return "Erasing RMS, since installed MIDlet-Vendor: " + vendorInstalled + " does not match prior -Vendor: " + vendorFound;
        }
        if (versionInstalled == null ? versionInstalled == versionFound : versionInstalled.compareTo(versionFound) >= 0) {
            return null;
        }
        return "Erasing RMS, since installed MIDlet-Version: " + versionInstalled + " does not match prior -Version: " + versionFound;
    }

    public boolean deleteRecordStore(String name) throws RecordStoreException {
        IRecordStoreEntry recordStore = this.getRecordStore(name, false);
        if (recordStore == null) {
            return false;
        }
        recordStore.deleteRecords();
        this.invalidateEntryAt(recordStore.getAddress());
        this.currentRecordStores[recordStore.getId()] = null;
        return true;
    }

    public IRmsEntry getEntryAt(Address address) throws RecordStoreException {
        return this.getEntryIn(this.memoryHeap.getBlockAt(address));
    }

    public IRmsEntry getEntryIn(IMemoryHeapBlock block) throws RecordStoreException {
        if (block == null || !block.isAllocated()) {
            return null;
        }
        try {
            RmsEntry entry;
            byte type = block.getDataInputStream().readByte();
            switch (type) {
                case 1: {
                    entry = new ApplicationDescriptorEntry();
                    break;
                }
                case 2: {
                    entry = new RecordEntry();
                    break;
                }
                case 3: {
                    entry = new RecordStoreEntry(this);
                    break;
                }
                case 4: {
                    entry = new RecordStoreSequenceEntry();
                    break;
                }
                default: {
                    entry = new UnknownEntry();
                }
            }
            entry.setAddress(block.getAddress());
            entry.readFrom(block);
            return entry;
        }
        catch (IOException e) {
            throw new RecordStoreException(e.getMessage());
        }
    }

    public long getErasedSequenceCurrentValue() {
        return this.memoryHeap.getErasedSequenceCurrentValue();
    }

    protected IRecordStoreEntry getRecordStore(int storeId) {
        if (storeId >= this.currentRecordStores.length) {
            IRecordStoreEntry[] temp = this.currentRecordStores;
            this.currentRecordStores = new IRecordStoreEntry[storeId + 1];
            System.arraycopy(temp, 0, this.currentRecordStores, 0, temp.length);
        }
        return this.currentRecordStores[storeId];
    }

    public IRecordStoreEntry getRecordStore(String name, boolean createIfNecessary) throws RecordStoreException {
        int max = this.currentRecordStores.length;
        for (int i = 0; i < max; ++i) {
            IRecordStoreEntry recordStore = this.currentRecordStores[i];
            if (recordStore == null || !recordStore.getName().equals(name)) continue;
            return recordStore;
        }
        if (createIfNecessary) {
            RecordStoreEntry recordStore = new RecordStoreEntry(this);
            recordStore.setName(name);
            int foundId = -1;
            int max2 = this.currentRecordStores.length;
            for (int i = 0; i < max2; ++i) {
                if (this.currentRecordStores[i] != null) continue;
                foundId = i;
                break;
            }
            if (foundId == -1) {
                foundId = this.currentRecordStores.length;
                this.getRecordStore(foundId);
            }
            recordStore.setId(foundId);
            this.currentRecordStores[foundId] = recordStore;
            this.logEntry(recordStore);
            return recordStore;
        }
        return null;
    }

    public String[] getRecordStoreNames() {
        Vector names = new Vector();
        int max = this.currentRecordStores.length;
        for (int i = 0; i < max; ++i) {
            IRecordStoreEntry entry = this.currentRecordStores[i];
            if (entry == null) continue;
            names.addElement(entry.getName());
        }
        if (names.size() == 0) {
            return null;
        }
        Object[] strings = new String[names.size()];
        names.copyInto(strings);
        return strings;
    }

    public int getSizeAvailable() throws RecordStoreException {
        return this.memoryHeap.getSizeAvailable();
    }

    protected void init() throws RecordStoreException {
        this.currentRecordStores = new IRecordStoreEntry[4];
        if (this.scanVisitor == null) {
            this.scanVisitor = new RecordStoreManagerScanVisitor(this);
        }
        if (this.reScanVisitor == null) {
            this.reScanVisitor = new RecordStoreManagerReScanVisitor(this);
        }
        this.memoryHeap.scanBlocks(this.memoryHeapScanner);
        String installedMidletName = VM.getManifestProperty("MIDlet-Name");
        String installedMidletVendor = VM.getManifestProperty("MIDlet-Vendor");
        String installedMidletVersion = VM.getManifestProperty("MIDlet-Version");
        if (installedMidletName == null || installedMidletVendor == null || installedMidletVersion == null) {
            throw new RecordStoreException("No MIDlet suite installed.");
        }
        String eraseRmsReason = this.checkMIDletVersion(installedMidletName, installedMidletVendor, installedMidletVersion);
        if (eraseRmsReason != null) {
            if (VM.isVerbose()) {
                System.out.println(eraseRmsReason);
            }
            if (this.currentApplicationDescriptor != null) {
                this.invalidateEntryAt(this.currentApplicationDescriptor.getAddress());
            }
            for (int i = 0; i < this.currentRecordStores.length; ++i) {
                IRecordStoreEntry store = this.currentRecordStores[i];
                if (store == null) continue;
                store.deleteRecords();
                this.invalidateEntryAt(store.getAddress());
            }
            this.currentApplicationDescriptor = new ApplicationDescriptorEntry();
            this.currentApplicationDescriptor.setMidletName(installedMidletName);
            this.currentApplicationDescriptor.setMidletVendor(installedMidletVendor);
            this.currentApplicationDescriptor.setMidletVersion(installedMidletVersion);
            this.logEntry(this.currentApplicationDescriptor);
            this.currentRecordStores = new IRecordStoreEntry[4];
        }
    }

    public void invalidateEntryAt(Address address) throws RecordStoreException {
        this.memoryHeap.freeBlockAt(address);
    }

    public Address logEntry(IRmsEntry entry) throws RecordStoreException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream(64);
        DataOutputStream output = new DataOutputStream(bytesOut);
        try {
            output.writeByte(entry.getType());
            entry.writeTo(output);
            int padding = 0;
            if ((bytesOut.size() & 1) == 1) {
                bytesOut.write(0);
                padding = 1;
            }
            entry.setAddress(this.memoryHeap.allocateAndWriteBlock(bytesOut.toByteArray(), 0, bytesOut.size() - padding, this.memoryHeapScanner));
            return entry.getAddress();
        }
        catch (IOException e) {
            throw new RecordStoreException(e.getMessage());
        }
    }

    public void reScanBlock(Address oldAddress, Address newAddress, IMemoryHeapBlock block) throws RecordStoreException {
        IRmsEntry entry = this.getEntryIn(block);
        if (entry == null) {
            return;
        }
        entry.setAddress(newAddress);
        entry.visit(this.reScanVisitor);
    }

    public void scanBlock(IMemoryHeapBlock block) throws RecordStoreException {
        IRmsEntry entry = this.getEntryIn(block);
        if (entry == null) {
            return;
        }
        entry.visit(this.scanVisitor);
    }
}

