/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.rms;

import com.sun.squawk.rms.IApplicationDescriptorEntry;
import com.sun.squawk.rms.IRecordEntry;
import com.sun.squawk.rms.IRecordStoreEntry;
import com.sun.squawk.rms.IRecordStoreSequenceEntry;
import com.sun.squawk.rms.IRmsEntryVisitor;
import com.sun.squawk.rms.IUnknownEntry;
import com.sun.squawk.rms.RecordStoreEntry;
import com.sun.squawk.rms.RecordStoreManager;
import com.sun.squawk.util.NotImplementedYetException;
import javax.microedition.rms.RecordStoreException;

class RecordStoreManagerScanVisitor
implements IRmsEntryVisitor {
    protected RecordStoreManager manager;

    RecordStoreManagerScanVisitor(RecordStoreManager manager) {
        this.manager = manager;
    }

    public void visitApplicationDescriptor(IApplicationDescriptorEntry newDescriptor) throws RecordStoreException {
        if (this.manager.currentApplicationDescriptor == null) {
            this.manager.currentApplicationDescriptor = newDescriptor;
        } else {
            this.manager.invalidateEntryAt(this.manager.currentApplicationDescriptor.getAddress());
            this.manager.currentApplicationDescriptor = newDescriptor;
        }
    }

    public void visitRecord(IRecordEntry entry) throws RecordStoreException {
        int storeId = entry.getStoreId();
        IRecordStoreEntry recordStore = this.manager.getRecordStore(storeId);
        if (recordStore == null) {
            recordStore = this.manager.currentRecordStores[storeId] = new RecordStoreEntry(this.manager);
        }
        recordStore.visitRecordEntry(entry);
    }

    public void visitRecordStore(IRecordStoreEntry entry) throws RecordStoreException {
        int id = entry.getId();
        IRecordStoreEntry recordStore = this.manager.getRecordStore(id);
        if (recordStore == null) {
            this.manager.currentRecordStores[id] = entry;
        } else if (recordStore.getAddress().isZero()) {
            this.manager.currentRecordStores[id] = entry;
            entry.absorbTempEntry(recordStore);
        } else {
            this.manager.invalidateEntryAt(recordStore.getAddress());
            this.manager.currentRecordStores[id] = entry;
        }
    }

    public void visitRecordStoreSequence(IRecordStoreSequenceEntry entry) {
        NotImplementedYetException.throwNow();
    }

    public void visitUnknown(IUnknownEntry entry) {
    }
}

