/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.security;

import com.sun.squawk.security.CryptoException;
import com.sun.squawk.security.ecc.ECCurveFp;
import com.sun.squawk.security.ecc.ECPoint;
import com.sun.squawk.security.ecc.FFA;

public final class ECPublicKey {
    protected ECPoint keyData;
    protected int bitsize;
    protected int bytesize;
    protected ECCurveFp curve = ECCurveFp.getInstance();
    protected FFA ffa = this.curve.getField().getFFA();
    public boolean initOk;

    public ECPublicKey() {
        this.bitsize = this.ffa.getBitSize();
        this.bytesize = this.bitsize + 7 >>> 3;
        this.keyData = new ECPoint(this.curve);
    }

    public void setW(byte[] buffer, int offset, int length) throws CryptoException {
        this.initOk = false;
        boolean ok = this.curve.decodePoint(this.keyData, buffer, offset, length);
        if (!ok || !this.curve.isOnCurve(this.keyData)) {
            CryptoException.throwIt(1);
        }
        this.initOk = true;
    }

    public int getW(byte[] buffer, int offset) throws CryptoException {
        if (!this.initOk) {
            CryptoException.throwIt(2);
        }
        return this.curve.encodePoint(this.keyData, buffer, offset);
    }

    public int getSize() {
        return this.bitsize;
    }

    public ECPoint getKeyData() {
        return this.keyData;
    }

    public void clearKey() {
        this.ffa.set(this.keyData.x, 0);
        this.ffa.set(this.keyData.y, 0);
        this.ffa.set(this.keyData.z, 0);
        this.initOk = false;
    }

    public ECCurveFp getCurve() {
        return this.curve;
    }
}

