/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.security.ecc;

public final class FFA {
    public static final int BITS_PER_WORD = 28;
    public static final int BMASK = 0xFFFFFFF;
    private int[][] vars;
    private int varsCount;
    private int bitLength;
    private int byteLength;
    private int len;
    private int doubleLen;
    private static char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FFA(int bitLength) {
        this.bitLength = bitLength;
        this.len = (bitLength + 27) / 28;
        this.byteLength = (bitLength + 7) / 8;
        this.doubleLen = 2 * this.len;
        this.vars = new int[16][];
    }

    public int[] acquireVar(int bits) {
        int len = (bits + 27) / 28;
        if (len == this.len) {
            return this.acquireVar();
        }
        return new int[len];
    }

    public synchronized int[] acquireVar() {
        return this.varsCount > 0 ? this.vars[--this.varsCount] : new int[this.len];
    }

    public int[] acquireDoubleVar() {
        return new int[this.doubleLen];
    }

    public synchronized void releaseVar(int[] var) {
        if (this.varsCount < this.vars.length && var.length == this.len) {
            this.vars[this.varsCount++] = var;
        }
    }

    public int getBitSize() {
        return this.bitLength;
    }

    public int getByteSize() {
        return this.byteLength;
    }

    public int getIntSize() {
        return this.len;
    }

    public String toString(int[] a) {
        StringBuffer res = new StringBuffer(a.length * 8);
        for (int i = a.length - 1; i >= 0; --i) {
            int ai = a[i];
            for (int j = 24; j >= 0; j -= 4) {
                res.append(hex[ai >> j & 0xF]);
            }
        }
        return res.toString();
    }

    public int[] from(int[] r, String a) {
        int i;
        int strLen = a.length() - 1;
        int intPos = strLen / 7;
        int nibblePos = strLen % 7 * 4;
        int tmp = 0;
        for (i = r.length - 1; i > intPos; --i) {
            r[i] = 0;
        }
        for (i = 0; i <= strLen; ++i) {
            char ch = a.charAt(i);
            int nibble = 0;
            if (ch >= '0' && ch <= '9') {
                nibble = ch - 48;
            } else if (ch >= 'a' && ch <= 'f') {
                nibble = ch - 97 + 10;
            } else if (ch >= 'A' && ch <= 'F') {
                nibble = ch - 65 + 10;
            }
            tmp |= nibble << nibblePos;
            if ((nibblePos -= 4) >= 0) continue;
            r[intPos--] = tmp;
            tmp = 0;
            nibblePos = 24;
            if (intPos < 0) break;
        }
        return r;
    }

    public int[] from(String a) {
        return this.from(this.acquireVar(), a);
    }

    public int[] from(int[] r, int[] a) {
        int srcPos = a.length;
        int dstBit = 0;
        int dstPos = 0;
        int dstLen = r.length;
        long rNext = 0L;
        while (--srcPos >= 0) {
            rNext |= ((long)a[srcPos] & 0xFFFFFFFFL) << dstBit;
            dstBit += 32;
            while (dstBit >= 28) {
                r[dstPos++] = (int)rNext & 0xFFFFFFF;
                if (dstPos >= dstLen) {
                    return r;
                }
                rNext >>>= 28;
                dstBit -= 28;
            }
        }
        r[dstPos++] = (int)rNext & 0xFFFFFFF;
        while (dstPos < dstLen) {
            r[dstPos++] = 0;
        }
        return r;
    }

    public int[] from(int[] a) {
        return this.from(this.acquireVar(), a);
    }

    public int[] from(int[] r, byte[] a, int ofs, int len) {
        int srcPos = ofs + len;
        int dstBit = 0;
        int dstPos = 0;
        int dstLen = r.length;
        long rNext = 0L;
        while (--srcPos >= ofs) {
            rNext |= ((long)a[srcPos] & 0xFFL) << dstBit;
            dstBit += 8;
            while (dstBit >= 28) {
                r[dstPos++] = (int)rNext & 0xFFFFFFF;
                if (dstPos >= dstLen) {
                    return r;
                }
                rNext >>>= 28;
                dstBit -= 28;
            }
        }
        r[dstPos++] = (int)rNext & 0xFFFFFFF;
        while (dstPos < dstLen) {
            r[dstPos++] = 0;
        }
        return r;
    }

    public int[] from(byte[] a, int ofs, int len) {
        return this.from(this.acquireVar(), a, ofs, len);
    }

    public void toByteArray(byte[] dst, int ofs, int len, int[] a) {
        int srcPos = 0;
        int srcLen = a.length;
        int dstBit = 0;
        int dstPos = ofs + len - 1;
        int dstLen = len;
        long rNext = 0L;
        if (dstLen <= 0) {
            return;
        }
        while (srcPos < srcLen) {
            rNext |= (long)(a[srcPos++] & 0xFFFFFFF) << dstBit;
            dstBit += 28;
            while (dstBit >= 8) {
                dst[dstPos--] = (byte)rNext;
                if (dstPos < ofs) {
                    return;
                }
                rNext >>>= 8;
                dstBit -= 8;
            }
        }
        dst[dstPos--] = (byte)rNext;
        while (dstPos >= ofs) {
            dst[dstPos--] = 0;
        }
    }

    public int add(int[] r, int[] a, int[] b) {
        int len = a.length;
        int m = 0;
        for (int i = 0; i < len; ++i) {
            r[i] = (m += a[i] + b[i]) & 0xFFFFFFF;
            m >>= 28;
        }
        return m;
    }

    public int sub(int[] r, int[] a, int[] b) {
        int len = a.length;
        int m = 1;
        for (int i = 0; i < len; ++i) {
            r[i] = (m += a[i] + (b[i] ^ 0xFFFFFFF)) & 0xFFFFFFF;
            m >>= 28;
        }
        return m ^ 1;
    }

    public void mul(int[] r, int[] a, int[] b) {
        int j;
        int k;
        int i;
        int len = a.length - 1;
        int len2 = len + len + 1;
        long acc = 0L;
        for (i = 0; i <= len; ++i) {
            k = 0;
            j = i;
            do {
                acc += (long)a[j--] * (long)b[k++];
            } while (j >= 0);
            r[i] = (int)acc & 0xFFFFFFF;
            acc >>>= 28;
        }
        while (i < len2) {
            j = len;
            k = i - len;
            do {
                acc += (long)a[j--] * (long)b[k++];
            } while (k <= len);
            r[i] = (int)acc & 0xFFFFFFF;
            acc >>>= 28;
            ++i;
        }
        r[i] = (int)acc;
    }

    public void sqr(int[] r, int[] a) {
        int j;
        int k;
        int i;
        int len = a.length - 1;
        int len2 = len + len + 1;
        long acc = 0L;
        for (i = 0; i <= len; ++i) {
            k = 0;
            j = i;
            while (k < j) {
                acc += (long)a[j--] * (long)a[k++] << 1;
            }
            if (k == j) {
                acc += (long)a[k] * (long)a[k];
            }
            r[i] = (int)acc & 0xFFFFFFF;
            acc >>>= 28;
        }
        while (i < len2) {
            j = len;
            k = i - len;
            while (k < j) {
                acc += (long)a[j--] * (long)a[k++] << 1;
            }
            if (k == j) {
                acc += (long)a[k] * (long)a[k];
            }
            r[i] = (int)acc & 0xFFFFFFF;
            acc >>>= 28;
            ++i;
        }
        r[i] = (int)acc;
    }

    public int shl(int[] r, int[] a, int n) {
        int m = 28 - n;
        int len = a.length;
        int res = 0;
        for (int i = 0; i < len; ++i) {
            int tmp = a[i];
            r[i] = res | tmp << n & 0xFFFFFFF;
            res = tmp >> m;
        }
        return res;
    }

    public int shr(int[] r, int[] a, int n) {
        int m = 28 - n;
        int i = a.length;
        int res = 0;
        while (--i >= 0) {
            int tmp = a[i];
            r[i] = res | tmp >> n;
            res = tmp << m & 0xFFFFFFF;
        }
        return res;
    }

    public void xor(int[] r, int[] a, int[] b) {
        for (int i = a.length - 1; i >= 0; --i) {
            r[i] = a[i] ^ b[i];
        }
    }

    public void copy(int[] r, int[] a) {
        int rlen = r.length;
        int alen = a.length;
        if (rlen != alen) {
            while (rlen > alen) {
                r[--rlen] = 0;
            }
            alen = rlen;
        }
        while (--alen >= 0) {
            r[alen] = a[alen];
        }
    }

    public int[] adjustLength(int[] a) {
        if (a.length != this.len) {
            int[] r = this.acquireVar();
            this.copy(r, a);
            return r;
        }
        return a;
    }

    public int cmp(int[] a, int[] b) {
        int aLen = a.length;
        int bLen = b.length;
        while (aLen > bLen) {
            if (a[--aLen] == 0) continue;
            return 1;
        }
        while (bLen > aLen) {
            if (b[--bLen] == 0) continue;
            return -1;
        }
        while (--aLen >= 0) {
            if (a[aLen] < b[aLen]) {
                return -1;
            }
            if (a[aLen] <= b[aLen]) continue;
            return 1;
        }
        return 0;
    }

    public int bitLength(int[] a) {
        int len = a.length - 1;
        while (a[len] == 0) {
            if (len-- > 0) continue;
            return 0;
        }
        int bpos = 27;
        int tmp = a[len];
        while ((tmp >>> bpos & 1) == 0) {
            --bpos;
        }
        return len * 28 + bpos + 1;
    }

    public boolean testBit(int[] a, int bit) {
        return (a[bit / 28] & 1 << bit % 28) != 0;
    }

    public boolean isEven(int[] a) {
        return (a[0] & 1) == 0;
    }

    public boolean isOdd(int[] a) {
        return (a[0] & 1) != 0;
    }

    public boolean is(int[] a, int val) {
        if (a[0] != val) {
            return false;
        }
        for (int i = a.length - 1; i > 0; --i) {
            if (a[i] == 0) continue;
            return false;
        }
        return true;
    }

    public void set(int[] r, int val) {
        r[0] = val;
        for (int i = r.length - 1; i > 0; --i) {
            r[i] = 0;
        }
    }

    private int subShifted(int[] r, int[] b, int n, int len) {
        int m = 1;
        int wordOfs = n / 28;
        int bitOfs = n % 28;
        int bLen = b.length;
        long tmp = 0L;
        int i = wordOfs;
        while (i < wordOfs + bLen & i < len) {
            r[i] = (m += r[i] + ((int)(tmp |= (long)b[i - wordOfs] << bitOfs) & 0xFFFFFFF ^ 0xFFFFFFF)) & 0xFFFFFFF;
            m >>= 28;
            tmp >>= 28;
            ++i;
        }
        while (i < len && (tmp != 0L || m != 1)) {
            r[i++] = (m += r[i] + ((int)tmp & 0xFFFFFFF ^ 0xFFFFFFF)) & 0xFFFFFFF;
            m >>= 28;
            tmp >>= 28;
        }
        return m ^ 1;
    }

    private int addShifted(int[] r, int[] b, int n, int len) {
        int m = 0;
        int wordOfs = n / 28;
        int bitOfs = n % 28;
        int bLen = b.length;
        long tmp = 0L;
        int i = wordOfs;
        while (i < wordOfs + bLen & i < len) {
            r[i] = (m += r[i] + ((int)(tmp |= (long)b[i - wordOfs] << bitOfs) & 0xFFFFFFF)) & 0xFFFFFFF;
            m >>= 28;
            tmp >>= 28;
            ++i;
        }
        while (i < len && (tmp != 0L || m != 0)) {
            r[i++] = (m += r[i] + ((int)tmp & 0xFFFFFFF)) & 0xFFFFFFF;
            m >>= 28;
            tmp >>= 28;
        }
        return m;
    }

    public void mod(int[] a, int[] b) {
        int bBits = this.bitLength(b);
        while (this.cmp(a, b) >= 0) {
            int aLen;
            int aBits = this.bitLength(a);
            if (this.subShifted(a, b, aBits - bBits, aLen = aBits / 28 + 1) != 1) continue;
            this.addShifted(a, b, aBits - bBits - 1, aLen);
        }
    }
}

