/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.security.ecc;

import com.sun.squawk.security.ecc.FFA;

public class PrimeField {
    private int[] tmp;
    protected final FFA ffa;
    protected final int[] p;

    public PrimeField(FFA ffa, int[] p) {
        this.ffa = ffa;
        this.p = p;
        this.tmp = ffa.acquireDoubleVar();
    }

    public void add(int[] r, int[] a, int[] b) {
        if (this.ffa.add(r, a, b) != 0 || this.ffa.cmp(r, this.p) >= 0) {
            this.ffa.sub(r, r, this.p);
        }
    }

    public void subtract(int[] r, int[] a, int[] b) {
        if (this.ffa.sub(r, a, b) != 0) {
            this.ffa.add(r, r, this.p);
        }
    }

    public synchronized void multiply(int[] r, int[] a, int[] b) {
        this.ffa.mul(this.tmp, a, b);
        this.reduce(r, this.tmp);
    }

    public synchronized void square(int[] r, int[] a) {
        this.ffa.sqr(this.tmp, a);
        this.reduce(r, this.tmp);
    }

    public void multiply2(int[] r, int[] a) {
        this.add(r, a, a);
    }

    public void divide2(int[] r, int[] a) {
        if (this.ffa.isOdd(a)) {
            int xhi = this.ffa.add(r, a, this.p);
            this.ffa.shr(r, r, 1);
            int n = a.length - 1;
            r[n] = r[n] | xhi << 27;
        } else {
            this.ffa.shr(r, a, 1);
        }
    }

    public void negate(int[] r, int[] a) {
        this.subtract(r, this.p, a);
    }

    public void invert(int[] r, int[] a) {
        int[] u = this.ffa.acquireVar();
        int[] v = this.ffa.acquireVar();
        int[] x1 = this.ffa.acquireVar();
        int[] x2 = this.ffa.acquireVar();
        this.ffa.copy(u, a);
        this.ffa.copy(v, this.p);
        this.ffa.set(x1, 1);
        this.ffa.set(x2, 0);
        while (!this.ffa.is(u, 1) && !this.ffa.is(v, 1)) {
            while (this.ffa.isEven(u)) {
                this.ffa.shr(u, u, 1);
                this.divide2(x1, x1);
            }
            while (this.ffa.isEven(v)) {
                this.ffa.shr(v, v, 1);
                this.divide2(x2, x2);
            }
            if (this.ffa.cmp(u, v) >= 0) {
                this.ffa.sub(u, u, v);
                this.subtract(x1, x1, x2);
                continue;
            }
            this.ffa.sub(v, v, u);
            this.subtract(x2, x2, x1);
        }
        if (this.ffa.is(u, 1)) {
            this.ffa.copy(r, x1);
        } else {
            this.ffa.copy(r, x2);
        }
        this.ffa.releaseVar(u);
        this.ffa.releaseVar(v);
        this.ffa.releaseVar(x1);
        this.ffa.releaseVar(x2);
    }

    public void trim(int[] r, int[] a) {
        this.ffa.mod(a, this.p);
        if (r != a) {
            this.ffa.copy(r, a);
        }
    }

    protected void reduce(int[] r, int[] a) {
        this.trim(r, a);
    }

    public final int[] getP() {
        return this.p;
    }

    public final FFA getFFA() {
        return this.ffa;
    }

    public int getBitSize() {
        return this.ffa.getBitSize();
    }
}

