/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import java.io.DataInput;
import java.io.IOException;
import java.io.UTFDataFormatException;

public final class DataInputUTF8Decoder {
    private DataInputUTF8Decoder() {
    }

    public static final String readUTF(DataInput in, boolean isClassFile, boolean twoByteLength) throws IOException {
        return DataInputUTF8Decoder.readUTF(in, isClassFile, twoByteLength ? in.readUnsignedShort() : in.readInt());
    }

    public static final String readUTF(DataInput in, boolean isClassFile, int utflen) throws IOException {
        byte[] bytearr = new byte[utflen];
        int count = 0;
        boolean sevenBit = true;
        for (int i = 0; i < utflen; ++i) {
            byte ch;
            bytearr[i] = ch = in.readByte();
            if (ch >= 0 && (!isClassFile || ch != 0)) continue;
            sevenBit = false;
        }
        if (sevenBit) {
            return new String(bytearr, 0, utflen);
        }
        StringBuffer str = new StringBuffer(utflen);
        block6: while (count < utflen) {
            int c = bytearr[count] & 0xFF;
            if (isClassFile && c == 0) {
                throw new UTFDataFormatException();
            }
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str.append((char)c);
                    continue block6;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0x1F) << 6 | char2 & 0x3F));
                    continue block6;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    byte char2 = bytearr[count - 2];
                    byte char3 = bytearr[count - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str.append((char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0));
                    continue block6;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(str);
    }
}

