/*
 * Decompiled with CFR 0.152.
 */
package com.sun.squawk.util;

import com.sun.squawk.util.DataInputUTF8Decoder;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public abstract class StructuredFileInputStream {
    private final String filePath;
    private final DataInputStream in;
    private final String traceFeature;
    private int bytesRead;

    public StructuredFileInputStream(InputStream in, String filePath, String traceFeature) {
        this.in = in instanceof DataInputStream ? (DataInputStream)in : new DataInputStream(in);
        this.filePath = filePath;
        this.traceFeature = traceFeature;
    }

    public final String getFileName() {
        return this.filePath;
    }

    public abstract Error formatError(String var1);

    public final int getBytesRead() {
        return this.bytesRead;
    }

    public final void readFully(byte[] b, String prefix) {
        try {
            this.in.readFully(b);
            this.bytesRead += b.length;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final int readInt(String prefix) {
        try {
            int value = this.in.readInt();
            this.bytesRead += 4;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final int readUnsignedShort(String prefix) {
        try {
            int value = this.in.readUnsignedShort();
            this.bytesRead += 2;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final int readUnsignedByte(String prefix) {
        try {
            int value = this.in.readUnsignedByte();
            ++this.bytesRead;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final int readShort(String prefix) {
        try {
            short value = this.in.readShort();
            this.bytesRead += 2;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final int readByte(String prefix) {
        try {
            byte value = this.in.readByte();
            ++this.bytesRead;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final long readLong(String prefix) {
        try {
            long value = this.in.readLong();
            this.bytesRead += 8;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final float readFloat(String prefix) {
        try {
            float value = this.in.readFloat();
            this.bytesRead += 4;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final double readDouble(String prefix) {
        try {
            double value = this.in.readDouble();
            this.bytesRead += 8;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final String readUTF(String prefix) {
        try {
            int utflen = this.in.readUnsignedShort();
            String value = DataInputUTF8Decoder.readUTF((DataInput)this.in, true, utflen);
            this.bytesRead += 2 + utflen;
            return value;
        }
        catch (EOFException oef) {
            throw this.formatError("truncated file");
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public final void skip(int n, String prefix) {
        try {
            if (this.in.skip(n) != (long)n) {
                throw this.formatError("truncated file");
            }
            this.bytesRead += n;
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }

    public void readEOF() {
        try {
            this.in.readByte();
        }
        catch (EOFException e) {
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw this.formatError("extra bytes in class file");
    }

    public final void close() {
        try {
            this.in.close();
        }
        catch (IOException ioe) {
            throw this.formatError(ioe.toString());
        }
    }
}

