/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.cldchi.jvm.JVM;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private boolean isClosed = false;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[size];
    }

    public synchronized void write(int b) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            JVM.unchecked_byte_arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            JVM.unchecked_byte_arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
        JVM.unchecked_byte_arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        if (this.isClosed && this.buf.length == this.count) {
            return this.buf;
        }
        byte[] newbuf = new byte[this.count];
        JVM.unchecked_byte_arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public synchronized void close() throws IOException {
        this.isClosed = true;
    }
}

