/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.cldc.i18n.Helper;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    private Reader in;

    public InputStreamReader(InputStream is) {
        this.in = Helper.getStreamReader(is);
    }

    public InputStreamReader(InputStream is, String enc) throws UnsupportedEncodingException {
        this.in = Helper.getStreamReader(is, enc);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.in.read();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        return this.in.read(cbuf, off, len);
    }

    public long skip(long n) throws IOException {
        this.ensureOpen();
        return this.in.skip(n);
    }

    public boolean ready() throws IOException {
        this.ensureOpen();
        return this.in.ready();
    }

    public boolean markSupported() {
        if (this.in == null) {
            return false;
        }
        return this.in.markSupported();
    }

    public void mark(int readAheadLimit) throws IOException {
        this.ensureOpen();
        if (!this.in.markSupported()) {
            throw new IOException();
        }
        this.in.mark(readAheadLimit);
    }

    public void reset() throws IOException {
        this.ensureOpen();
        this.in.reset();
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }
}

