/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import com.sun.cldc.i18n.Helper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    private Writer out;

    public OutputStreamWriter(OutputStream os) {
        this.out = Helper.getStreamWriter(os);
    }

    public OutputStreamWriter(OutputStream os, String enc) throws UnsupportedEncodingException {
        this.out = Helper.getStreamWriter(os, enc);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException();
        }
    }

    public void write(int c) throws IOException {
        this.ensureOpen();
        this.out.write(c);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.out.write(cbuf, off, len);
    }

    public void write(String str, int off, int len) throws IOException {
        this.ensureOpen();
        if (off < 0 || off > str.length() || len < 0 || off + len > str.length() || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.out.write(str, off, len);
    }

    public void flush() throws IOException {
        this.ensureOpen();
        this.out.flush();
    }

    public void close() throws IOException {
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
    }
}

