/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic.colorfiltering;

final class ColorConversionUtil {
    private ColorConversionUtil() {
    }

    public static int logBase2(int n) {
        int n2 = 0;
        while (n > 1 || n < 0) {
            n >>>= 1;
            ++n2;
        }
        return n2;
    }

    public static int midOffset(int[] nArray, int n) {
        int n2 = n / 2;
        int n3 = 0;
        int n4 = Math.abs(nArray[0] - n2);
        for (int i = 1; i < nArray.length; ++i) {
            int n5 = Math.abs(nArray[i] - n2);
            if (n4 <= n5) continue;
            n4 = n5;
            n3 = i;
            if (n4 == 0) break;
        }
        return n3;
    }

    public static int[] createConversionTable(int n, int n2) {
        int[] nArray = new int[n];
        int n3 = n2 - 1;
        int n4 = n3 / 2;
        if (n < n2) {
            int n5 = n - 1;
            int n6 = n5 / 2;
            for (int i = 0; i < n; ++i) {
                int n7 = (i * n3 + n6) / n5;
                nArray[i] = (n7 * 255 + n4) / n3;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n8 = i * n2 / n;
                nArray[i] = (n8 * 255 + n4) / n3;
            }
        }
        return nArray;
    }

    public static int[][] createConversionTable(int n, int n2, int[] nArray, int n3) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = ColorConversionUtil.createConversionTable(n, n2, nArray[i], n3);
        }
        return nArrayArray;
    }

    private static int[] createConversionTable(int n, int n2, int n3, int n4) {
        int[] nArray = new int[n];
        int n5 = n2 - 1;
        int n6 = n5 / 2;
        int n7 = n - 1;
        int n8 = n5 * n4;
        int n9 = n3 * n7;
        int n10 = n7 * n4;
        for (int i = 0; i < n; ++i) {
            int n11 = (i * n8 + n9) / n10;
            nArray[i] = (n11 * 255 + n6) / n5;
        }
        return nArray;
    }
}

