/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic.colorfiltering;

import com.sun.jme.emulator.generic.colorfiltering.ColorConversionUtil;
import com.sun.jme.emulator.generic.colorfiltering.DitheringMatrix;
import com.sun.jme.emulator.generic.colorfiltering.Filter;
import com.sun.jme.emulator.generic.colorfiltering.FourByFourMatrix;
import org.apache.log4j.Logger;

final class DitheringGrayscaleFilter
extends Filter {
    public static final Logger LOGGER = Logger.getLogger(DitheringGrayscaleFilter.class);
    private final int ditheringWidthMask;
    private final int ditheringHeightMask;
    private final int ditheringWidthBits;
    private final int ditheringMidIndex;
    private final int[][] cConvTable8;

    DitheringGrayscaleFilter(int n) {
        int n2 = ColorConversionUtil.logBase2(n);
        int n3 = 1 << n2;
        if (n3 > 256) {
            n3 = 256;
        }
        DitheringMatrix ditheringMatrix = FourByFourMatrix.getInstance();
        int[] nArray = ditheringMatrix.getElements();
        int n4 = ditheringMatrix.getDenominator();
        this.ditheringHeightMask = ditheringMatrix.getHeight() - 1;
        int n5 = ditheringMatrix.getWidth();
        this.ditheringWidthMask = n5 - 1;
        this.ditheringWidthBits = ColorConversionUtil.logBase2(n5);
        this.ditheringMidIndex = ColorConversionUtil.midOffset(nArray, n4);
        this.cConvTable8 = ColorConversionUtil.createConversionTable(256, n3, nArray, n4);
        LOGGER.debug((Object)("Created DitheringGrayscaleFilter for " + n3 + " colors"));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        int n4 = this.calcDitheringIndex(n, n2);
        return this.filterRGB(n4, n3);
    }

    @Override
    public int filterRGB(int n) {
        return this.filterRGB(this.ditheringMidIndex, n);
    }

    @Override
    public void filterPixelsToDestination16(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 + 2 * n2 <= n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n3 + 1] << 8 | byArray[n3] & 0xFF;
                int n8 = n7 & 0x1F;
                int n9 = n7 >> 5 & 0x3F;
                int n10 = n7 >> 11 & 0x1F;
                int n11 = this.calcDitheringIndex(n6, n5);
                int n12 = this.cConvTable8[n11][161187 * n10 + 155710 * n9 + 61456 * n8 + 32768 >>> 16];
                nArray[n4] = 0xFF000000 | n12 << 16 | n12 << 8 | n12;
                ++n6;
                n3 += 2;
                ++n4;
            }
            ++n5;
        }
    }

    @Override
    public void filterPixelsToDestination32(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n3 + 4 * n2 <= n) {
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n3 + 0] & 0xFF;
                int n8 = byArray[n3 + 1] & 0xFF;
                int n9 = byArray[n3 + 2] & 0xFF;
                int n10 = this.calcDitheringIndex(n6, n5);
                int n11 = this.cConvTable8[n10][19595 * n9 + 38470 * n8 + 7471 * n7 + 32768 >>> 16];
                nArray[n4] = 0xFF000000 | n11 << 16 | n11 << 8 | n11;
                ++n6;
                n3 += 4;
                ++n4;
            }
            ++n5;
        }
    }

    private int filterRGB(int n, int n2) {
        int n3 = (n2 & 0xFF0000) >> 16;
        int n4 = (n2 & 0xFF00) >> 8;
        int n5 = n2 & 0xFF;
        int n6 = this.cConvTable8[n][19595 * n3 + 38470 * n4 + 7471 * n5 + 32768 >>> 16];
        return n2 & 0xFF000000 | n6 << 16 | n6 << 8 | n6;
    }

    private int calcDitheringIndex(int n, int n2) {
        return (n2 & this.ditheringHeightMask) << this.ditheringWidthBits | n & this.ditheringWidthMask;
    }
}

