/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.generic.colorfiltering;

import com.sun.jme.emulator.generic.colorfiltering.ColorConversionUtil;
import com.sun.jme.emulator.generic.colorfiltering.Filter;
import org.apache.log4j.Logger;

final class LimitedColorFilter
extends Filter {
    public static final Logger LOGGER = Logger.getLogger(LimitedColorFilter.class);
    private final int[] rConvTable8;
    private final int[] gConvTable8;
    private final int[] bConvTable8;
    private final int[] rConvTable5;
    private final int[] gConvTable6;
    private final int[] bConvTable5;

    LimitedColorFilter(int n) {
        int n2 = ColorConversionUtil.logBase2(n);
        int n3 = n2 / 3;
        int n4 = n3 + (n2 % 3 > 1 ? 1 : 0);
        int n5 = n3 + (n2 % 3 > 0 ? 1 : 0);
        int n6 = 1 << n4;
        int n7 = 1 << n5;
        int n8 = 1 << n3;
        this.rConvTable8 = ColorConversionUtil.createConversionTable(256, n6);
        this.gConvTable8 = ColorConversionUtil.createConversionTable(256, n7);
        this.bConvTable8 = ColorConversionUtil.createConversionTable(256, n8);
        this.rConvTable5 = ColorConversionUtil.createConversionTable(32, n6);
        this.gConvTable6 = ColorConversionUtil.createConversionTable(64, n7);
        this.bConvTable5 = ColorConversionUtil.createConversionTable(32, n8);
        LOGGER.debug((Object)("Created LimitedColorFilter for " + n + " colors"));
    }

    @Override
    public int filterRGB(int n, int n2, int n3) {
        return this.filterRGB(n3);
    }

    @Override
    public int filterRGB(int n) {
        return n & 0xFF000000 | this.rConvTable8[(n & 0xFF0000) >> 16] << 16 | this.gConvTable8[(n & 0xFF00) >> 8] << 8 | this.bConvTable8[n & 0xFF];
    }

    @Override
    public void filterPixelsToDestination16(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; i += 2) {
            int n4 = byArray[i + 1] << 8 | byArray[i] & 0xFF;
            int n5 = n4 & 0x1F;
            int n6 = n4 >> 5 & 0x3F;
            int n7 = n4 >> 11 & 0x1F;
            nArray[n3++] = 0xFF000000 | this.rConvTable5[n7] << 16 | this.gConvTable6[n6] << 8 | this.bConvTable5[n5];
        }
    }

    @Override
    public void filterPixelsToDestination32(byte[] byArray, int n, int[] nArray, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; i += 4) {
            int n4 = byArray[i + 0] & 0xFF;
            int n5 = byArray[i + 1] & 0xFF;
            int n6 = byArray[i + 2] & 0xFF;
            nArray[n3++] = 0xFF000000 | this.rConvTable8[n6] << 16 | this.gConvTable8[n5] << 8 | this.bConvTable8[n4];
        }
    }
}

