/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.tools.http;

import com.sun.kvem.tools.http.HttpServer;
import com.sun.kvem.tools.http.SecureServerConfiguration;
import java.io.IOException;
import java.net.ServerSocket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.log4j.Logger;

public class HttpsServer
extends HttpServer
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(HttpsServer.class);
    private SSLServerSocketFactory ssf;

    public HttpsServer(SecureServerConfiguration secureServerConfiguration) {
        super(secureServerConfiguration);
        try {
            KeyStore keyStore = KeyStore.getInstance(secureServerConfiguration.getKeyStoreFormat(), secureServerConfiguration.getKeyStoreProvider());
            keyStore.load(secureServerConfiguration.getKeyStoreAsStream(), secureServerConfiguration.getKeyStorePassword());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(secureServerConfiguration.getKeyManagerAlgorithm());
            keyManagerFactory.init(keyStore, secureServerConfiguration.getKeyPassword());
            SSLContext sSLContext = SSLContext.getInstance(secureServerConfiguration.getSLLProtocol());
            sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
            this.ssf = sSLContext.getServerSocketFactory();
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception, (Throwable)exception);
        }
    }

    @Override
    protected void handleServerStarted() {
        System.out.println("HTTPS server started!");
    }

    @Override
    protected void handleServerNotStarted() {
        LOGGER.warn((Object)"HTTPS server not started!");
    }

    @Override
    protected ServerSocket createServerSocket() throws IOException {
        SSLServerSocket sSLServerSocket;
        if (this.ssf == null) {
            return null;
        }
        if (this.configuration.willUseDynamicPort()) {
            sSLServerSocket = (SSLServerSocket)this.ssf.createServerSocket(0);
            this.configuration.setPort(sSLServerSocket.getLocalPort());
        } else {
            sSLServerSocket = (SSLServerSocket)this.ssf.createServerSocket(this.configuration.getPort());
        }
        return sSLServerSocket;
    }
}

