/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.devicedetection.addrrapi;

import com.sun.jme.toolkit.devicedetection.api.DeviceAddress;
import com.sun.jme.toolkit.devicedetection.api.DeviceAddressManager;
import com.sun.jme.toolkit.devicedetection.api.DeviceIpAddress;
import com.sun.jme.toolkit.devicedetection.rapiclient.ConnectionInfo;
import com.sun.jme.toolkit.devicedetection.rapiclient.RapiClientService;
import com.sun.jme.toolkit.devicedetection.rapiclient.RapiConnectionListener;
import java.util.HashMap;
import java.util.Map;

public final class RapiAddressDetector
implements RapiConnectionListener {
    private final Map<String, DeviceAddress> addedDeviceAddresses = new HashMap<String, DeviceAddress>();
    private DeviceAddressManager deviceAddressManager;
    private RapiClientService rapiClientService;
    private boolean stopping;

    public void setDeviceAddressManager(DeviceAddressManager deviceAddressManager) {
        this.deviceAddressManager = deviceAddressManager;
    }

    public void setRapiClientService(RapiClientService rapiClientService) {
        this.rapiClientService = rapiClientService;
    }

    public synchronized void start() {
        ConnectionInfo[] connectionInfoArray;
        this.rapiClientService.addConnectionListener((RapiConnectionListener)this);
        for (ConnectionInfo connectionInfo : connectionInfoArray = this.rapiClientService.getConnectedDevices()) {
            this.addDeviceAddress(connectionInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.rapiClientService.removeConnectionListener((RapiConnectionListener)this);
        RapiAddressDetector rapiAddressDetector = this;
        synchronized (rapiAddressDetector) {
            this.stopping = true;
        }
        for (DeviceAddress deviceAddress : this.addedDeviceAddresses.values()) {
            this.deviceAddressManager.removeDeviceAddress(deviceAddress);
        }
        this.addedDeviceAddresses.clear();
    }

    public synchronized void deviceConnected(ConnectionInfo connectionInfo) {
        if (this.stopping) {
            return;
        }
        this.addDeviceAddress(connectionInfo);
    }

    public synchronized void deviceDisconnected(String string) {
        if (this.stopping) {
            return;
        }
        this.removeDeviceAddress(string);
    }

    private void addDeviceAddress(ConnectionInfo connectionInfo) {
        DeviceAddress deviceAddress = this.createDeviceAddress(connectionInfo);
        this.deviceAddressManager.addDeviceAddress(deviceAddress);
        this.addedDeviceAddresses.put(connectionInfo.getDeviceName(), deviceAddress);
    }

    private void removeDeviceAddress(String string) {
        DeviceAddress deviceAddress = this.addedDeviceAddresses.get(string);
        if (deviceAddress != null) {
            this.deviceAddressManager.removeDeviceAddress(deviceAddress);
            this.addedDeviceAddresses.remove(string);
        }
    }

    private DeviceAddress createDeviceAddress(ConnectionInfo connectionInfo) {
        return new DeviceIpAddress(connectionInfo.getDeviceAddress().getHostAddress(), connectionInfo.getHostAddress().getHostAddress());
    }
}

