/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.aut.proxy;

import com.sun.jme.toolkit.aut.proxy.ProxyDiscovery;
import com.sun.jme.toolkit.util.winreg.NativeException;
import com.sun.jme.toolkit.util.winreg.WindowsRegistry;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class IEProxyDiscovery
extends ProxyDiscovery {
    private static final Logger LOGGER = Logger.getLogger(IEProxyDiscovery.class);
    private static final String IE_SETTINGS_KEY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    private static final String PROXY_ENABLE = "ProxyEnable";
    private static final String PROXY_SERVER = "ProxyServer";

    public Proxy findProxy() {
        int n;
        String string;
        String string2 = null;
        String string3 = null;
        boolean bl = true;
        try {
            WindowsRegistry windowsRegistry = WindowsRegistry.getInstance();
            int n2 = windowsRegistry.get32BitValue(1, IE_SETTINGS_KEY, PROXY_ENABLE);
            if (n2 == -1) {
                LOGGER.warn((Object)"Registry: cannot find value ProxyEnable");
                this.proxyCache = null;
                return this.proxyCache;
            }
            boolean bl2 = bl = 1 == n2;
            if (!bl) {
                LOGGER.trace((Object)"Direct connection is used");
                return Proxy.NO_PROXY;
            }
            string = windowsRegistry.getStringValue(1, IE_SETTINGS_KEY, PROXY_SERVER);
        }
        catch (NativeException nativeException) {
            LOGGER.error((Object)nativeException, (Throwable)nativeException);
            this.proxyCache = null;
            return this.proxyCache;
        }
        if (string == null) {
            LOGGER.trace((Object)"Registry: cannot find value ProxyServer");
            this.proxyCache = null;
            return this.proxyCache;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string2 == null || string2.length() == 0 || string3 == null || string3.length() == 0) {
            this.proxyCache = null;
            return this.proxyCache;
        }
        try {
            n = Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.error((Object)numberFormatException, (Throwable)numberFormatException);
            this.proxyCache = null;
            return this.proxyCache;
        }
        try {
            this.proxyCache = new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(string2, n));
            LOGGER.debug((Object)("Proxy discovered: " + this.proxyCache));
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception, (Throwable)exception);
            this.proxyCache = null;
        }
        return this.proxyCache;
    }

    private String[] toStringArray(String string, char c) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(c);
        if (n > 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string.substring(0, n);
            stringArray = stringArray2;
            stringArray2[1] = string.substring(n + 1);
        } else {
            stringArray = null;
        }
        return stringArray;
    }
}

