/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.aut.proxy;

import com.sun.jme.toolkit.aut.proxy.ProxyDiscovery;
import com.sun.jme.toolkit.aut.proxy.ProxySettingsParser;
import com.sun.jme.toolkit.util.winreg.NativeException;
import com.sun.jme.toolkit.util.winreg.WindowsRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Proxy;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class OperaProxyDiscovery
extends ProxyDiscovery
implements ProxySettingsParser {
    private static final boolean EXPAND = true;
    private static final Logger LOGGER = Logger.getLogger(OperaProxyDiscovery.class);
    private static final String OPERA_INSTALL_DIR_VALUE = "Last CommandLine";
    private static final String OPERA_REGISTRY_KEY = "Software\\Opera Software";
    private static final String WIN_USER_SETTINGS_DIR = "Application Data\\Opera";
    private static final Pattern fptrn = Pattern.compile("^operaprefs[.]ini");
    private String operaSettingsDir = "Application Data\\Opera";

    public void setSettingsDir(String string) {
        this.operaSettingsDir = string;
    }

    public Proxy findProxy() {
        String string = System.getProperty("user.home");
        if (string == null) {
            this.proxyCache = null;
            return this.proxyCache;
        }
        File file = new File(string + File.separator + this.operaSettingsDir);
        if (!file.exists()) {
            LOGGER.trace((Object)("Cannot find settings file under: " + file));
        } else {
            LOGGER.trace((Object)"Scanning user dir for Opera preferences ...");
            this.proxyCache = this.scanSettingsForProxy(file, fptrn, this);
        }
        if (this.proxyCache == null) {
            try {
                Object object;
                LOGGER.trace((Object)"Trying under Opera installation dir.");
                WindowsRegistry windowsRegistry = WindowsRegistry.getInstance();
                String[] stringArray = windowsRegistry.getValueNames(1, OPERA_REGISTRY_KEY);
                String string2 = null;
                for (String string3 : stringArray) {
                    if (!string3.startsWith(OPERA_INSTALL_DIR_VALUE)) continue;
                    string2 = windowsRegistry.getStringValue(1, OPERA_REGISTRY_KEY, string3, true);
                    break;
                }
                if (string2 == null) {
                    object = new StringBuffer();
                    ((StringBuffer)object).append("Can't find registry key: HKEY_CURRENT_USER/");
                    ((StringBuffer)object).append(OPERA_REGISTRY_KEY);
                    ((StringBuffer)object).append("/");
                    ((StringBuffer)object).append(OPERA_INSTALL_DIR_VALUE);
                    LOGGER.warn((Object)((StringBuffer)object).toString());
                    this.proxyCache = null;
                    return this.proxyCache;
                }
                object = new File(string2).getParent();
                if (object == null) {
                    LOGGER.warn((Object)"Installation dir is null !");
                    this.proxyCache = null;
                    return this.proxyCache;
                }
                file = new File((String)object);
                if (!file.exists()) {
                    LOGGER.trace((Object)("Dir doesn't exist: " + file.toString()));
                    this.proxyCache = null;
                    return this.proxyCache;
                }
                this.proxyCache = this.scanSettingsForProxy(file, fptrn, this);
            }
            catch (NativeException nativeException) {
                LOGGER.trace((Object)"Can't get Opera proxy:", (Throwable)nativeException);
                this.proxyCache = null;
            }
        }
        LOGGER.trace((Object)("Proxy found: " + this.proxyCache));
        return this.proxyCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] parse(File file) {
        String string = null;
        String string2 = null;
        BufferedReader bufferedReader = null;
        try {
            String[] stringArray;
            block23: {
                String string3;
                bufferedReader = new BufferedReader(new FileReader(file));
                int n = 0;
                while (null != (string3 = bufferedReader.readLine())) {
                    n = string3.indexOf("Use HTTP");
                    if (-1 < n) {
                        String[] stringArray2;
                        if (string3.charAt(n + 8) == 'S' || -1 >= (n = string3.indexOf("=", n))) continue;
                        string = string3.substring(n + 1).trim();
                        if (string2 == null) continue;
                        if (string.equals("1")) {
                            stringArray2 = this.toStringArray(string2, ':');
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = "";
                            stringArray2 = stringArray3;
                            stringArray3[1] = "";
                        }
                        String[] stringArray4 = stringArray2;
                        return stringArray4;
                    }
                    n = string3.indexOf("HTTP server");
                    if (-1 >= n || -1 >= (n = string3.indexOf("=", n))) continue;
                    string2 = string3.substring(n + 1).trim();
                    if (string == null) {
                        continue;
                    }
                    break block23;
                }
                return null;
            }
            if (string.equals("1")) {
                stringArray = this.toStringArray(string2, ':');
            } else {
                String[] stringArray5 = new String[2];
                stringArray5[0] = "";
                stringArray = stringArray5;
                stringArray5[1] = "";
            }
            String[] stringArray6 = stringArray;
            return stringArray6;
        }
        catch (IOException iOException) {
            LOGGER.debug((Object)"Can't parse:", (Throwable)iOException);
            return null;
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    private String[] toStringArray(String string, char c) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        int n = string.indexOf(c);
        if (n > 0) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = string.substring(0, n);
            stringArray = stringArray2;
            stringArray2[1] = string.substring(n + 1);
        } else {
            stringArray = null;
        }
        return stringArray;
    }
}

