/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.memprof;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CountDownLatch;

public class MemoryProfilerLoader {
    private static final String profilerMainClass = "view.Client";
    private static CountDownLatch shutdownFinishedLatch;
    private static File jar;
    private static List<String> args;

    public static void setShutdownFinishedLatch(CountDownLatch countDownLatch) {
        shutdownFinishedLatch = countDownLatch;
    }

    public static void setJar(File file) {
        jar = file;
    }

    public static void setArguments(List<String> list) {
        args = list;
    }

    public static void start() throws Exception {
        Object object;
        Object object2;
        shutdownFinishedLatch.countDown();
        String string = "localhost";
        int n = -1;
        Iterator<String> iterator = args.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            if (((String)object2).equals("-host")) {
                if (!iterator.hasNext()) {
                    MemoryProfilerLoader.argError("Host argument is missing.");
                }
                string = iterator.next();
                continue;
            }
            if (((String)object2).equals("-port")) {
                if (!iterator.hasNext()) {
                    MemoryProfilerLoader.argError("Port argument is missing.");
                }
                object = iterator.next();
                try {
                    n = Integer.parseInt((String)object);
                    if (n > 0 && n <= 65535) continue;
                    MemoryProfilerLoader.argError("Invalid port number.");
                }
                catch (NumberFormatException numberFormatException) {
                    MemoryProfilerLoader.argError("Port number cannot be parsed: '" + (String)object + "'.");
                }
                continue;
            }
            if (((String)object2).equals("-h") || ((String)object2).equals("--help")) {
                MemoryProfilerLoader.usage(System.out, null);
                System.exit(0);
                continue;
            }
            MemoryProfilerLoader.argError("Unknown argument '" + (String)object2 + "'.");
        }
        if (n == -1) {
            MemoryProfilerLoader.argError("Missing -port argument.");
        }
        if (!jar.exists()) {
            MemoryProfilerLoader.error("Cannot open file: " + jar.getPath());
        }
        object2 = jar.toURI();
        try {
            object = new URLClassLoader(new URL[]{((URI)object2).toURL()});
            Class<?> clazz = ((ClassLoader)object).loadClass(profilerMainClass);
            Method method = clazz.getMethod("main", String[].class);
            method.invoke((Object)null, new Object[]{new String[]{"-host", string, "-port", Integer.toString(n)}});
            System.out.println("Memory profiler is running, will communicate to runtime on " + string + ", port " + n);
        }
        catch (MalformedURLException malformedURLException) {
            MemoryProfilerLoader.error("Cannot load memory profiler jar (wrong URI): " + object2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            MemoryProfilerLoader.error("Cannot find view.Client class in profiler jar: " + jar.getPath());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MemoryProfilerLoader.error("Memory profiler's class view.Client has no main method.");
        }
        catch (IllegalAccessException illegalAccessException) {
            MemoryProfilerLoader.error("Memory profiler's main method cannot be accessed.");
        }
        catch (InvocationTargetException invocationTargetException) {
            MemoryProfilerLoader.error("Memory profiler's main method cannot be invoked.");
        }
    }

    private static void argError(String string) {
        MemoryProfilerLoader.usage(System.err, string);
        System.exit(1);
    }

    private static void error(String string) {
        System.err.println(string);
        System.exit(1);
    }

    private static void usage(PrintStream printStream, String string) {
        if (string != null) {
            printStream.println(string);
        }
        printStream.println("memory-profiler [-host <host>] -port <port>");
        printStream.println("  -host <host>: host of the profiled runtime, defaults to localhost");
        printStream.println("  -port <port>: JDWP debugging port of the profiled runtime");
    }
}

