/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.winreg;

import com.sun.jme.toolkit.util.winreg.NativeException;
import java.io.File;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public final class WindowsRegistry {
    private static WindowsRegistry instance;
    private static final Logger LOGGER;
    private int mode;
    private Boolean wow64process;
    public static final int HKEY_CLASSES_ROOT = 0;
    public static final int HKEY_CURRENT_USER = 1;
    public static final int HKEY_LOCAL_MACHINE = 2;
    public static final int HKEY_USERS = 3;
    public static final int HKEY_CURRENT_CONFIG = 4;
    public static final int HKEY_DYN_DATA = 5;
    public static final int HKEY_PERFORMANCE_DATA = 6;
    public static final int HKEY_PERFORMANCE_NLSTEXT = 7;
    public static final int HKEY_PERFORMANCE_TEXT = 8;
    public static final int HKCR = 0;
    public static final int HKCU = 1;
    public static final int HKLM = 2;
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    public static final int REG_QWORD_LITTLE_ENDIAN = 11;
    public static final int REG_QWORD = 11;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_32BIT = 1;
    public static final int MODE_64BIT = 2;
    public static final String SEPARATOR = "\\";
    private static int KEY_READ_LEVEL;
    private static int KEY_MODIFY_LEVEL;

    private WindowsRegistry() {
        this.setMode(0);
        String string = System.getProperty("emulator.home").replace('/', File.separatorChar);
        String string2 = new File(string, "bin").toString() + File.separatorChar;
        String string3 = string2 + "winreg.dll";
        System.load(string3);
    }

    public static WindowsRegistry getInstance() {
        if (instance == null) {
            instance = new WindowsRegistry();
        }
        return instance;
    }

    public boolean keyExists(int n, String string) throws NativeException {
        this.validateSection(n);
        this.validateKey(string);
        try {
            return this.checkKeyAccess0(this.mode, n, string, KEY_READ_LEVEL);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new NativeException(unsatisfiedLinkError);
        }
    }

    public boolean keyExists(int n, String string, String string2) throws NativeException {
        this.validateKey(string);
        this.validateKeyName(string2);
        this.validateParenthood(string, string2);
        try {
            return this.keyExists(n, string + SEPARATOR + string2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new NativeException(unsatisfiedLinkError);
        }
    }

    public boolean valueExists(int n, String string, String string2) throws NativeException {
        this.validateValueName(string2);
        if (this.keyExists(n, string)) {
            try {
                return this.valueExists0(this.mode, n, string, string2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
        throw new NativeException("Cannot check for value existance - key does not exist");
    }

    public boolean keyEmpty(int n, String string) throws NativeException {
        if (this.keyExists(n, string)) {
            try {
                return this.keyEmpty0(this.mode, n, string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
        throw new NativeException("Cannot check -- key does not exist");
    }

    public int countSubKeys(int n, String string) throws NativeException {
        if (this.keyExists(n, string)) {
            try {
                return this.countSubKeys0(this.mode, n, string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
        throw new NativeException("Cannot count subkeys -- key does not exist");
    }

    public int countValues(int n, String string) throws NativeException {
        if (this.keyExists(n, string)) {
            try {
                return this.countValues0(this.mode, n, string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
        throw new NativeException("Cannot count values -- key does not exist");
    }

    public String[] getSubKeys(int n, String string) throws NativeException {
        String[] stringArray = this.getSubKeyNames(n, string);
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = this.constructKey(string, stringArray[i]);
        }
        return stringArray2;
    }

    public String[] getSubKeyNames(int n, String string) throws NativeException {
        if (this.keyExists(n, string)) {
            try {
                return this.getSubkeyNames0(this.mode, n, string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
        throw new NativeException("Cannot get subkey names -- key does not exist");
    }

    public String[] getValueNames(int n, String string) throws NativeException {
        if (this.keyExists(n, string)) {
            try {
                return this.getValueNames0(this.mode, n, string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
        throw new NativeException("Cannot list value names -- key does not exist");
    }

    public int getValueType(int n, String string, String string2) throws NativeException {
        if (this.keyExists(n, string)) {
            if (this.valueExists(n, string, string2)) {
                try {
                    return this.getValueType0(this.mode, n, string, string2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeException(unsatisfiedLinkError);
                }
            }
            throw new NativeException("Cannot get value type -- value does not exist");
        }
        throw new NativeException("Cannot get value type -- key does not exist");
    }

    public void createKey(int n, String string) throws NativeException {
        this.createKey(n, this.getKeyParent(string), this.getKeyName(string));
    }

    public void createKey(int n, String string, String string2) throws NativeException {
        if (!this.keyExists(n, string, string2)) {
            if (!this.keyExists(n, string)) {
                this.createKey(n, this.getKeyParent(string), this.getKeyName(string));
            }
            try {
                this.createKey0(this.mode, n, string, string2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
    }

    public void deleteKey(int n, String string) throws NativeException {
        this.deleteKey(n, this.getKeyParent(string), this.getKeyName(string));
    }

    public void deleteKey(int n, String string, String string2) throws NativeException {
        if (this.keyExists(n, string, string2)) {
            try {
                this.deleteKey0(this.mode, n, string, string2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        }
    }

    public void deleteValue(int n, String string, String string2) throws NativeException {
        if (this.keyExists(n, string)) {
            if (this.valueExists(n, string, string2)) {
                try {
                    this.deleteValue0(this.mode, n, string, string2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeException(unsatisfiedLinkError);
                }
            }
        } else {
            throw new NativeException("Cannot delete value -- key does not exist");
        }
    }

    public String getStringValue(int n, String string, String string2) throws NativeException {
        return this.getStringValue(n, string, string2, false);
    }

    public String getStringValue(int n, String string, String string2, boolean bl) throws NativeException {
        if (this.keyExists(n, string)) {
            if (this.valueExists(n, string, string2)) {
                try {
                    return this.getStringValue0(this.mode, n, string, string2, bl);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeException(unsatisfiedLinkError);
                }
            }
            throw new NativeException("Cannot get string value -- value does not exist");
        }
        throw new NativeException("Cannot get string value -- key does not exist");
    }

    public void setStringValue(int n, String string, String string2, Object object) throws NativeException {
        this.setStringValue(n, string, string2, object.toString());
    }

    public void setStringValue(int n, String string, String string2, String string3) throws NativeException {
        this.setStringValue(n, string, string2, string3, false);
    }

    public void setStringValue(int n, String string, String string2, String string3, boolean bl) throws NativeException {
        this.validateValueName(string2);
        this.validateStringValue(string3);
        if (this.keyExists(n, string)) {
            try {
                this.setStringValue0(this.mode, n, string, string2, string3, bl);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        } else {
            throw new NativeException("Cannot set string value -- key does not exist");
        }
    }

    public int get32BitValue(int n, String string, String string2) throws NativeException {
        if (this.keyExists(n, string)) {
            if (this.valueExists(n, string, string2)) {
                try {
                    return this.get32BitValue0(this.mode, n, string, string2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeException(unsatisfiedLinkError);
                }
            }
            throw new NativeException("Cannot get 32-bit value -- value does not exist");
        }
        throw new NativeException("Cannot get 32-bit value -- key does not exist");
    }

    public void set32BitValue(int n, String string, String string2, int n2) throws NativeException {
        this.validateValueName(string2);
        this.validate32BitValue(n2);
        if (this.keyExists(n, string)) {
            try {
                this.set32BitValue0(this.mode, n, string, string2, n2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        } else {
            throw new NativeException("Cannot set 32-bit value -- key does not exist");
        }
    }

    public String[] getMultiStringValue(int n, String string, String string2) throws NativeException {
        if (this.keyExists(n, string)) {
            if (this.valueExists(n, string, string2)) {
                try {
                    return this.getMultiStringValue0(this.mode, n, string, string2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeException(unsatisfiedLinkError);
                }
            }
            throw new NativeException("Cannot get multistring value -- value does not exist");
        }
        throw new NativeException("Cannot get multistring value -- key does not exist");
    }

    public void setMultiStringValue(int n, String string, String string2, String[] stringArray) throws NativeException {
        this.validateValueName(string2);
        this.validateMultiStringValue(stringArray);
        if (this.keyExists(n, string)) {
            try {
                this.setMultiStringValue0(this.mode, n, string, string2, stringArray);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        } else {
            throw new NativeException("Cannot set multistring value -- key does not exist");
        }
    }

    public byte[] getBinaryValue(int n, String string, String string2) throws NativeException {
        if (this.keyExists(n, string)) {
            if (this.valueExists(n, string, string2)) {
                try {
                    return this.getBinaryValue0(this.mode, n, string, string2);
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw new NativeException(unsatisfiedLinkError);
                }
            }
            throw new NativeException("Cannot get binary value -- value does not exist");
        }
        throw new NativeException("Cannot get binary value -- key does not exist");
    }

    public void setBinaryValue(int n, String string, String string2, byte[] byArray) throws NativeException {
        this.validateValueName(string2);
        this.validateBinaryValue(byArray);
        if (this.keyExists(n, string)) {
            try {
                this.setBinaryValue0(this.mode, n, string, string2, byArray);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        } else {
            throw new NativeException("Cannot set binary value -- key does not exist");
        }
    }

    public void setNoneValue(int n, String string, String string2, byte ... byArray) throws NativeException {
        this.validateValueName(string2);
        if (this.keyExists(n, string)) {
            try {
                this.setNoneValue0(this.mode, n, string, string2, byArray);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw new NativeException(unsatisfiedLinkError);
            }
        } else {
            throw new NativeException("Cannot access value -- key does not exist");
        }
    }

    public void setAdditionalValues(int n, String string, Map<String, Object> map) throws NativeException {
        LOGGER.debug((Object)("setting " + map.size() + " values"));
        for (String string2 : map.keySet()) {
            Object object = map.get(string2);
            LOGGER.debug((Object)(string2 + " = " + object.toString()));
            if (object instanceof Short) {
                LOGGER.debug((Object)"Type is short. Set REG_DWORD value");
                this.set32BitValue(n, string, string2, ((Short)object).intValue());
                continue;
            }
            if (object instanceof Integer) {
                LOGGER.debug((Object)"Type is integer. Set REG_DWORD value");
                this.set32BitValue(n, string, string2, (Integer)object);
                continue;
            }
            if (object instanceof Long) {
                LOGGER.debug((Object)"Type is long. Set REG_DWORD value");
                this.set32BitValue(n, string, string2, ((Long)object).intValue());
                continue;
            }
            if (object instanceof byte[]) {
                LOGGER.debug((Object)"Type is byte[]. Set REG_BINARY value");
                this.setBinaryValue(n, string, string2, (byte[])object);
                continue;
            }
            if (object instanceof String[]) {
                LOGGER.debug((Object)"Type is String[]. Set REG_MULTI_SZ value");
                this.setMultiStringValue(n, string, string2, (String[])object);
                continue;
            }
            if (object instanceof String) {
                LOGGER.debug((Object)"Type is String. Set REG_SZ value");
                this.setStringValue(n, string, string2, (String)object, false);
                continue;
            }
            LOGGER.warn((Object)"Type can't be determined. Set REG_SZ value");
            this.setStringValue(n, string, string2, object.toString(), false);
        }
    }

    public boolean canModifyKey(int n, String string) throws NativeException {
        try {
            if (this.keyExists(n, string)) {
                boolean bl = this.checkKeyAccess0(this.mode, n, string, KEY_MODIFY_LEVEL);
                if (bl) {
                    String string2 = "rndkey" + new Random().nextLong();
                    try {
                        this.createKey0(this.mode, n, string, string2);
                        this.deleteKey0(this.mode, n, string, string2);
                    }
                    catch (NativeException nativeException) {
                        bl = false;
                    }
                }
                return bl;
            }
            return this.canModifyKey(n, this.getKeyParent(string));
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            throw new NativeException(unsatisfiedLinkError);
        }
    }

    public String constructKey(String string, String string2) {
        return string + SEPARATOR + string2;
    }

    public String getKeyParent(String string) {
        String string2 = string;
        while (string2.endsWith(SEPARATOR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string2.lastIndexOf(SEPARATOR);
        if (n != -1) {
            return string2.substring(0, n);
        }
        return "";
    }

    public String getKeyName(String string) {
        String string2 = string;
        while (string2.endsWith(SEPARATOR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n = string2.lastIndexOf(SEPARATOR);
        if (n != -1) {
            return string2.substring(n + 1);
        }
        return string2;
    }

    public void setMode(int n) {
        if (this.isModeSupported(n)) {
            this.mode = n;
        }
    }

    public boolean isAlternativeModeSupported() {
        return this.IsWow64Process() || System.getProperty("os.arch").equals("amd64");
    }

    public void setMode(Boolean bl) {
        this.setMode(this.modeBooleanToInteger(bl));
    }

    public boolean isModeSupported(int n) {
        switch (n) {
            case 0: {
                return true;
            }
            case 1: 
            case 2: {
                return this.isAlternativeModeSupported();
            }
        }
        return false;
    }

    public int getMode() {
        return this.mode;
    }

    public Boolean isAlternativeMode() {
        return this.modeIntegerToBoolean(this.mode);
    }

    public boolean IsWow64Process() {
        if (this.wow64process == null) {
            this.wow64process = new Boolean(this.IsWow64Process0());
        }
        return this.wow64process;
    }

    private Boolean modeIntegerToBoolean(int n) {
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            return new Boolean(System.getProperty("os.arch").equals("amd64"));
        }
        if (n == 2) {
            return new Boolean(this.IsWow64Process());
        }
        return null;
    }

    private int modeBooleanToInteger(Boolean bl) {
        if (bl == null) {
            return 0;
        }
        if (this.IsWow64Process()) {
            return bl != false ? 2 : 1;
        }
        if (System.getProperty("os.arch").equals("amd64")) {
            return bl == false ? 2 : 1;
        }
        return 0;
    }

    private void validateSection(int n) throws NativeException {
        if (n < 0 || n > 8) {
            throw new NativeException("Section \"" + n + "\" is " + "invalid, should be between " + 0 + " " + "and " + 8);
        }
    }

    private void validateKey(String string) throws NativeException {
        if (string == null) {
            throw new NativeException("Key cannot be null");
        }
    }

    private void validateKeyName(String string) throws NativeException {
        if (string == null) {
            throw new NativeException("Key name cannot be null");
        }
    }

    private void validateParenthood(String string, String string2) throws NativeException {
        if (string.equals(string2)) {
            throw new NativeException("Parent cannot be equal to child");
        }
    }

    private void validateValueName(String string) throws NativeException {
        if (string == null) {
            throw new NativeException("Value name cannot be null");
        }
    }

    private void validateStringValue(String string) throws NativeException {
        if (string == null) {
            throw new NativeException("String value cannot be null");
        }
    }

    private void validate32BitValue(int n) throws NativeException {
    }

    private void validateMultiStringValue(String[] stringArray) throws NativeException {
        if (stringArray == null) {
            throw new NativeException("Multistring value cannot be null");
        }
    }

    private void validateBinaryValue(byte[] byArray) throws NativeException {
        if (byArray == null) {
            throw new NativeException("Binary value cannot be null");
        }
    }

    private native boolean keyExists0(int var1, int var2, String var3) throws NativeException;

    private native boolean valueExists0(int var1, int var2, String var3, String var4) throws NativeException;

    private native boolean keyEmpty0(int var1, int var2, String var3) throws NativeException;

    private native int countSubKeys0(int var1, int var2, String var3) throws NativeException;

    private native int countValues0(int var1, int var2, String var3) throws NativeException;

    private native String[] getSubkeyNames0(int var1, int var2, String var3) throws NativeException;

    private native String[] getValueNames0(int var1, int var2, String var3) throws NativeException;

    private native int getValueType0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void createKey0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void deleteKey0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void deleteValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native String getStringValue0(int var1, int var2, String var3, String var4, boolean var5) throws NativeException;

    private native void setStringValue0(int var1, int var2, String var3, String var4, String var5, boolean var6);

    private native int get32BitValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void set32BitValue0(int var1, int var2, String var3, String var4, int var5) throws NativeException;

    private native String[] getMultiStringValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void setMultiStringValue0(int var1, int var2, String var3, String var4, String[] var5) throws NativeException;

    private native byte[] getBinaryValue0(int var1, int var2, String var3, String var4) throws NativeException;

    private native void setBinaryValue0(int var1, int var2, String var3, String var4, byte[] var5) throws NativeException;

    private native void setNoneValue0(int var1, int var2, String var3, String var4, Object var5) throws NativeException;

    private native boolean checkKeyAccess0(int var1, int var2, String var3, int var4) throws NativeException;

    private native boolean IsWow64Process0();

    static {
        LOGGER = Logger.getLogger(WindowsRegistry.class);
        KEY_READ_LEVEL = 0;
        KEY_MODIFY_LEVEL = 1;
    }
}

