/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.EMBitmapFont;
import com.sun.kvem.EMFont;
import com.sun.kvem.EMSystemFont;
import java.awt.Font;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class FontManager {
    private static final Logger LOGGER = Logger.getLogger(FontManager.class);
    private static FontManager instance = null;
    public static final String FONT_PREFIX = "font.";
    private JComponent screenComponent;
    private Hashtable fonts = new Hashtable();
    private static final String fontKeyDefault = "default";
    private Vector fontList = new Vector();

    public static FontManager getInstance() {
        return instance;
    }

    public FontManager() {
        instance = this;
    }

    public void setScreenComponent(JComponent jComponent) {
        this.screenComponent = jComponent;
    }

    private EMFont getFont(Object object) {
        return (EMFont)this.fonts.get(object);
    }

    private void putFont(Object object, EMFont eMFont) {
        this.fonts.put(object, eMFont);
    }

    public EMFont getBitmapFont(String string) throws IOException {
        Properties properties;
        string = FONT_PREFIX + string;
        String string2 = Device.getProperty((String)string);
        if (string2 == null) {
            string = "font.default";
            string2 = Device.getProperty((String)string);
        }
        EMFont eMFont = null;
        if (string2 == null) {
            LOGGER.warn((Object)"No font definition found in device property file.");
        } else {
            eMFont = this.getFont(string2);
        }
        if (eMFont == null && (properties = Device.getPropertiesResource((String)string)) != null) {
            eMFont = new EMBitmapFont(properties, this.screenComponent);
            this.putFont(Device.getProperty((String)string), eMFont);
        }
        return eMFont;
    }

    private EMFont getSystemFont(String string) {
        string = FONT_PREFIX + string;
        String string2 = Device.getProperty((String)string, (String)Device.getProperty((String)"font.default"));
        EMFont eMFont = null;
        if (string2 == null) {
            LOGGER.warn((Object)"No font definition found in device property file.");
        } else {
            eMFont = this.getFont(string2);
        }
        if (eMFont == null) {
            eMFont = new EMSystemFont(string2, this.screenComponent);
            this.putFont(string2, eMFont);
        }
        return eMFont;
    }

    private EMFont getSystemFont(Font font) {
        EMFont eMFont = this.getFont(font);
        if (eMFont == null) {
            eMFont = new EMSystemFont(font, this.screenComponent);
            this.putFont(font, eMFont);
        }
        return eMFont;
    }

    public int getSystemFontID(Font font) {
        EMFont eMFont = this.getSystemFont(font);
        return this.getFontID(eMFont);
    }

    public int getFontID(String string) {
        EMFont eMFont;
        try {
            eMFont = this.getBitmapFont(string);
        }
        catch (IOException iOException) {
            eMFont = this.getSystemFont(string);
        }
        return this.getFontID(eMFont);
    }

    private int getFontID(EMFont eMFont) {
        int n = this.fontList.indexOf(eMFont);
        if (n == -1) {
            n = this.fontList.size();
            this.fontList.addElement(eMFont);
        }
        return n;
    }

    public EMFont getFont(int n) {
        return (EMFont)this.fontList.elementAt(n);
    }
}

