/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Icon {
    private final String name;
    private final Point location = new Point();
    private final Hashtable states = new Hashtable();
    private String state;
    private static final MediaTracker tracker = new MediaTracker(new Canvas());
    private Color background;
    public static final String ICON_PREFIX = "icon.";

    public static Icon[] createIcons() {
        ArrayList<Icon> arrayList = new ArrayList<Icon>();
        int n = ICON_PREFIX.length();
        Enumeration enumeration = Device.propertyKeys((String)ICON_PREFIX);
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf(".", n) != -1) continue;
            String string2 = string.substring(n);
            Icon icon = new Icon(string2, string);
            arrayList.add(icon);
        }
        return arrayList.toArray(new Icon[arrayList.size()]);
    }

    private void syntax(String string) {
        String string2 = "Malformed icon specification in property file\nSyntax: icon.<icon name>: <x>, <y> , <initial state>\nFound: '" + string + "'";
        throw new IllegalArgumentException(string2);
    }

    protected Icon(String string, String string2) {
        this.name = string;
        String string3 = Device.getProperty((String)string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string3, ", \t");
        if (stringTokenizer.countTokens() != 3) {
            this.syntax(string3);
        }
        this.location.x = Integer.parseInt(stringTokenizer.nextToken());
        this.location.y = Integer.parseInt(stringTokenizer.nextToken());
        this.state = stringTokenizer.nextToken();
        String string4 = string2 + ".";
        int n = string4.length();
        Enumeration enumeration = Device.propertyKeys((String)string4);
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            this.states.put(string5.substring(n), string5);
        }
    }

    public Point getLocation() {
        return new Point(this.location);
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public void setState(String string) {
        this.state = string;
    }

    public String getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public Image getImage() {
        Object v = this.states.get(this.state);
        if (v == null || v.toString().length() == 0) {
            return null;
        }
        if (v instanceof Image) {
            return (Image)v;
        }
        String string = (String)v;
        URL uRL = Device.getResource((String)string);
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        tracker.removeImage(image);
        this.states.put(this.state, image);
        return image;
    }

    public void clear(Graphics graphics) {
        Image image = this.getImage();
        if (image != null) {
            Rectangle rectangle = this.getBounds();
            graphics.setPaintMode();
            graphics.setColor(this.background);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public Rectangle getBounds() {
        Image image = this.getImage();
        return new Rectangle(this.location.x, this.location.y, image == null ? 0 : image.getWidth(null), image == null ? 0 : image.getHeight(null));
    }

    public void paint(Graphics graphics) {
        graphics.setPaintMode();
        Image image = this.getImage();
        if (image != null) {
            graphics.drawImage(image, this.location.x, this.location.y, null);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ", location=" + this.location + ", state=" + this.state + "]";
    }

    public Rectangle setState(String string, Graphics graphics) {
        Rectangle rectangle = new Rectangle(this.location.x, this.location.y, 0, 0);
        if (!this.getState().equals(string)) {
            rectangle = this.getBounds();
            this.clear(graphics);
            this.setState(string);
            this.paint(graphics);
            rectangle = rectangle.union(this.getBounds());
        }
        return rectangle;
    }
}

