/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.ObservableGraphics;
import com.sun.kvem.Orientation;
import com.sun.kvem.PositionTranslator;
import com.sun.kvem.RotateTranslator;
import com.sun.kvem.ScreenBorderPainter;
import com.sun.kvem.ScreenExtension;
import com.sun.kvem.ScreenExtensionManager;
import com.sun.kvem.ScreenGraphics;
import com.sun.kvem.ScreenImplBase;
import com.sun.kvem.ScreenImplMBean;
import com.sun.kvem.SoftButton;
import com.sun.kvem.SoftButtonSupport;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class ScreenImpl
extends ScreenImplBase
implements ScreenExtensionManager,
SoftButtonSupport,
ScreenImplMBean {
    private Color foreground = Color.black;
    private Color background = Color.white;
    private static final Logger LOGGER = Logger.getLogger(ScreenImpl.class);
    private Graphics2D graphics;
    private Graphics componentGraphics;
    private ObservableGraphics faceGraphics;
    private Graphics2D directFaceGraphics;
    Rectangle faceBounds;
    private Rectangle displayBounds;
    private Rectangle scaledFaceBounds;
    Rectangle displayBoundsInFace;
    Dimension pixelSize;
    Dimension facePixelSize;
    BufferedImage visibleFaceImage;
    BufferedImage rotatedImage;
    private SoftButton[] softButtons;
    int scale = 1;
    private int latency = 0;
    private Color borderColor;
    private JComponent videoComponent;
    private Orientation rotation = Orientation.NORMAL;
    private Rectangle currentFaceBounds;
    private Rectangle currentScaledFaceBounds;
    private Dimension currentFacePixelSize;
    private Rectangle currentDisplayBounds;
    private Rectangle currentDisplayBoundsInFace;
    PositionTranslator rotator;
    PositionTranslator reverseRotator;
    private Dimension currentPixelSize;
    private AffineTransformOp rotationOp;
    private ScreenGraphics screenGraphics;
    private Point position;
    ObservableGraphics.Observer latencyObserver = new ObservableGraphics.Observer(){

        public void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
            if (ScreenImpl.this.latency == 0) {
                return;
            }
            try {
                Thread.sleep(ScreenImpl.this.latency);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    private JComponent component;
    public static final String DPI_X = "screen.dpi.x";
    public static final String DPI_Y = "screen.dpi.y";
    protected int colorCount;
    protected float gamma = 1.0f;
    private boolean isColor = true;
    private JComponent screenComponent;
    private List<ScreenExtension> extensionList = new ArrayList<ScreenExtension>();
    private List<ScreenBorderPainter> screenBorderPainters = new ArrayList<ScreenBorderPainter>();

    public void setScreenGraphics(ScreenGraphics screenGraphics) {
        this.screenGraphics = screenGraphics;
    }

    public void setComponent(JComponent jComponent) {
        this.component = jComponent;
    }

    public void setScreenComponent(JComponent jComponent) {
        this.screenComponent = jComponent;
    }

    @Override
    public void setScale(int n) {
        this.scale = n;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setColor(boolean bl) {
        this.isColor = bl;
    }

    public void setGamma(float f) {
        this.gamma = f;
    }

    public void setLatency(int n) {
        this.latency = n;
    }

    public void setAlphaCompose(boolean bl) {
        this.alphaCompose = bl;
    }

    public void setFaceBounds(Rectangle rectangle) {
        LOGGER.debug((Object)("Face bounds are " + rectangle));
        this.faceBounds = rectangle;
        this.currentFaceBounds = rectangle;
    }

    public void setPosition(Point point) {
        this.position = point;
    }

    public void setDisplayBoundsInFace(Rectangle rectangle) {
        LOGGER.debug((Object)("Display bounds (in face) are " + rectangle));
        this.displayBoundsInFace = rectangle;
        this.currentDisplayBoundsInFace = rectangle;
    }

    public void setPixelSize(Dimension dimension) {
        this.pixelSize = dimension;
        this.currentPixelSize = dimension;
    }

    public void setIsColor(boolean bl) {
        this.isColor = bl;
    }

    @Override
    public void setColorCount(int n) {
        this.colorCount = n;
    }

    public Dimension getPixelSize() {
        return this.pixelSize;
    }

    public Dimension getFacePixelSize() {
        return this.facePixelSize;
    }

    private AffineTransformOp getRotationOp(Orientation orientation) {
        if (orientation == Orientation.NORMAL) {
            return null;
        }
        int n = this.facePixelSize.width;
        int n2 = this.facePixelSize.height;
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        switch (orientation) {
            case RIGHT: {
                d = 1.5707963267948966;
                n3 = n2;
                break;
            }
            case LEFT: {
                d = -1.5707963267948966;
                n4 = n;
                break;
            }
            case UPSIDE_DOWN: {
                d = Math.PI;
                n3 = n;
                n4 = n2;
            }
        }
        if (d == 0.0) {
            return null;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n3, n4);
        affineTransform.rotate(d);
        return new AffineTransformOp(affineTransform, 2);
    }

    public void reposition(PositionTranslator positionTranslator, Orientation orientation) {
        this.rotation = orientation;
        RotateTranslator rotateTranslator = new RotateTranslator(this.rotation, this.displayBounds.width, this.displayBounds.height);
        this.rotator = rotateTranslator;
        this.reverseRotator = rotateTranslator.getReverseTranslator();
        this.currentFaceBounds = positionTranslator.translateRect(this.faceBounds);
        this.currentScaledFaceBounds = positionTranslator.translateRect(this.scaledFaceBounds);
        this.screenComponent.setBounds(this.currentScaledFaceBounds);
        if (this.rotation == Orientation.NORMAL || this.rotation == Orientation.UPSIDE_DOWN) {
            this.currentFacePixelSize = this.facePixelSize;
            this.currentPixelSize = this.pixelSize;
        } else {
            this.currentFacePixelSize = new Dimension(this.facePixelSize.height, this.facePixelSize.width);
            this.currentPixelSize = new Dimension(this.pixelSize.height, this.pixelSize.width);
        }
        this.currentDisplayBoundsInFace = positionTranslator.translateRect(new Rectangle(this.displayBoundsInFace.x + this.faceBounds.x, this.displayBoundsInFace.y + this.faceBounds.y, this.displayBoundsInFace.width, this.displayBoundsInFace.height));
        this.currentDisplayBoundsInFace.x -= this.currentFaceBounds.x;
        this.currentDisplayBoundsInFace.y -= this.currentFaceBounds.y;
        this.rotatedImage = new BufferedImage(this.currentFacePixelSize.width, this.currentFacePixelSize.height, this.visibleFaceImage.getType());
        this.currentDisplayBounds = positionTranslator.translateRect(this.displayBounds);
        this.componentGraphics = null;
        this.rotationOp = this.getRotationOp(orientation);
    }

    public void notifyScreenImageRotated(Orientation orientation) {
        this.notifyRotationListeners(orientation);
    }

    public Orientation getRotation() {
        return this.rotation;
    }

    public Rectangle getCurrentFaceBounds() {
        return this.currentFaceBounds;
    }

    public Dimension getCurrentFacePixelSize() {
        return this.currentFacePixelSize;
    }

    public AffineTransformOp getImageRotator() {
        return this.rotationOp;
    }

    public void create() {
        super.create();
        if (this.pixelSize == null) {
            this.pixelSize = new Dimension(1, 1);
        }
        if (this.screenGraphics != null) {
            this.screenGraphics.addScreen(this);
            Dimension dimension = this.screenGraphics.getDimension();
            if (this.position == null) {
                this.position = new Point(0, 0);
            }
            this.faceBounds = new Rectangle(this.position.x, this.position.y, dimension.width * this.pixelSize.width, dimension.height * this.pixelSize.height);
        }
        if (this.displayBoundsInFace == null) {
            this.displayBoundsInFace = new Rectangle(0, 0, this.faceBounds.width, this.faceBounds.height);
        }
        this.updateDisplay();
        this.currentFacePixelSize = this.facePixelSize = new Dimension(this.faceBounds.width / this.pixelSize.width, this.faceBounds.height / this.pixelSize.height);
        this.currentDisplayBounds = this.displayBounds = new Rectangle(this.displayBoundsInFace.x + this.faceBounds.x, this.displayBoundsInFace.y + this.faceBounds.y, this.displayBoundsInFace.width, this.displayBoundsInFace.height);
        this.currentScaledFaceBounds = this.scaledFaceBounds = new Rectangle(this.faceBounds.x * this.scale, this.faceBounds.y * this.scale, this.faceBounds.width * this.scale, this.faceBounds.height * this.scale);
        LOGGER.debug((Object)("{" + this.screenComponent + "}"));
        LOGGER.debug((Object)this.scaledFaceBounds);
        this.screenComponent.setBounds(this.scaledFaceBounds);
        if (this.screenGraphics == null) {
            this.visibleFaceImage = new BufferedImage(this.facePixelSize.width, this.facePixelSize.height, 2);
            LOGGER.trace((Object)"Created visible face image");
        } else {
            this.visibleFaceImage = this.screenGraphics.getFaceImage();
            this.currentFacePixelSize = this.facePixelSize = this.screenGraphics.getDimension();
        }
        this.directFaceGraphics = (Graphics2D)this.visibleFaceImage.getGraphics();
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        this.directFaceGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        if (!this.alphaCompose) {
            this.directFaceGraphics.setComposite(AlphaComposite.Src);
        }
        LOGGER.trace((Object)"Created direct face graphics");
        this.faceGraphics = new ObservableGraphics(this.directFaceGraphics);
        if (this.screenGraphics != null) {
            if (this.latency > 0) {
                this.screenGraphics.getGraphics().addObserver(this.latencyObserver);
            }
            this.screenGraphics.getGraphics().addObserver((ObservableGraphics.Observer)this.getScreenUpdatePolicy());
        } else {
            if (this.latency > 0) {
                this.faceGraphics.addObserver(this.latencyObserver);
            }
            this.faceGraphics.addObserver((ObservableGraphics.Observer)this.getScreenUpdatePolicy());
        }
        this.graphics = (Graphics2D)this.faceGraphics.create(this.displayBoundsInFace.x / this.pixelSize.width, this.displayBoundsInFace.y / this.pixelSize.height, this.displayBoundsInFace.width / this.pixelSize.width, this.displayBoundsInFace.height / this.pixelSize.height);
        LOGGER.trace((Object)"Created graphics");
        this.softButtons = SoftButton.createSoftButtons();
        LOGGER.trace((Object)"Created soft buttons");
        this.faceGraphics.setColor(this.background);
        this.faceGraphics.fillRect(0, 0, this.faceBounds.width, this.faceBounds.height);
        this.reverseRotator = this.rotator = new RotateTranslator(Orientation.NORMAL, this.displayBounds.width, this.displayBounds.height);
        this.rotationOp = null;
        this.drawFaceBorder();
        this.updateFace();
    }

    public void destroy() {
        if (this.screenGraphics != null) {
            this.screenGraphics.removeScreen(this);
        }
    }

    private void drawFaceBorder() {
        Graphics2D graphics2D = this.directFaceGraphics;
        graphics2D.setColor(this.borderColor);
        if (this.displayBoundsInFace.y > 0) {
            graphics2D.fillRect(0, 0, this.faceBounds.width, this.displayBoundsInFace.y);
        }
        if (!this.isFullScreenMode()) {
            if (this.displayBoundsInFace.y + this.displayBoundsInFace.height < this.faceBounds.height) {
                graphics2D.fillRect(0, this.displayBoundsInFace.y + this.displayBoundsInFace.height, this.faceBounds.width, this.faceBounds.height - (this.displayBoundsInFace.y + this.displayBoundsInFace.height));
            }
            if (this.displayBoundsInFace.x > 0) {
                graphics2D.fillRect(0, this.displayBoundsInFace.y, this.displayBoundsInFace.x, this.displayBoundsInFace.height);
            }
            if (this.displayBoundsInFace.x + this.displayBoundsInFace.width < this.faceBounds.width) {
                graphics2D.fillRect(this.displayBoundsInFace.x + this.displayBoundsInFace.width, this.displayBoundsInFace.y, this.faceBounds.width - (this.displayBoundsInFace.x + this.displayBoundsInFace.width), this.displayBoundsInFace.height);
            }
            if (this.faceBounds.height - this.displayBoundsInFace.y - this.displayBoundsInFace.height > 3) {
                graphics2D.setColor(new Color(0x6A6A6A));
                graphics2D.drawLine(0, this.displayBoundsInFace.y + this.displayBoundsInFace.height, this.faceBounds.width, this.displayBoundsInFace.y + this.displayBoundsInFace.height);
                graphics2D.setColor(new Color(0xFFFFFF));
                graphics2D.drawLine(1, this.displayBoundsInFace.y + this.displayBoundsInFace.height + 1, this.faceBounds.width - 1, this.displayBoundsInFace.y + this.displayBoundsInFace.height + 1);
            }
            Shape shape = graphics2D.getClip();
            Object object = this.foreground;
            for (int i = 0; i < this.softButtons.length; ++i) {
                this.softButtons[i].setBackground(this.borderColor);
                this.softButtons[i].setForeground((Color)object);
                this.softButtons[i].paint(graphics2D);
                graphics2D.setClip(shape);
            }
        }
        for (Object object : this.screenBorderPainters) {
            object.paint((Graphics)graphics2D);
        }
    }

    public Graphics2D getDisplayGraphics() {
        return (Graphics2D)this.graphics.create();
    }

    public Graphics2D getFaceGraphics() {
        return (Graphics2D)this.faceGraphics.create();
    }

    public Graphics2D getComponentGraphics() {
        Graphics graphics;
        if (this.componentGraphics == null && (graphics = this.component.getGraphics()) != null) {
            this.componentGraphics = graphics.create();
        }
        return (Graphics2D)this.componentGraphics;
    }

    public void setVideoComponent(JComponent jComponent) {
        this.videoComponent = jComponent;
    }

    public BufferedImage getFaceImage() {
        return this.visibleFaceImage;
    }

    public Rectangle getFaceBoundsInImage() {
        return new Rectangle(this.faceBounds);
    }

    public Rectangle getFaceBoundsInComponent() {
        return new Rectangle(this.scaledFaceBounds);
    }

    public Dimension getFaceSize() {
        return new Dimension(this.facePixelSize);
    }

    public Rectangle getDisplayBoundsInFace() {
        return new Rectangle(this.displayBoundsInFace);
    }

    public void setSoftButtonLabel(int n, String string) {
        this.setSoftButtonLabel(n, string, null);
    }

    public void setSoftButtonLabel(int n, String string, String string2) {
        this.softButtons[n].setText(string, string2);
        Graphics2D graphics2D = this.getComponentGraphics();
        this.softButtons[n].paint(graphics2D);
        Rectangle rectangle = this.softButtons[n].getBounds();
        this.updateComponent(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public String getSoftButtonLabel(int n) {
        return this.softButtons[n].getText();
    }

    public int getSoftButtonCount() {
        return Device.getIntegerProperty((String)"softbutton.count", (int)0);
    }

    public Dimension getDisplaySize() {
        return new Dimension(this.displayBounds.width / this.pixelSize.width, this.displayBounds.height / this.pixelSize.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point translatePoint(int n, int n2) {
        JComponent jComponent;
        Serializable serializable = jComponent = this.component;
        synchronized (serializable) {
            while (!jComponent.isShowing()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        serializable = jComponent.getLocationOnScreen();
        Point point = this.rotator.translatePoint(new Point(n, n2));
        return new Point(((Point)serializable).x + (this.currentFaceBounds.x + point.x * this.currentPixelSize.width) * this.scale, ((Point)serializable).y + (this.currentFaceBounds.y + point.y * this.currentPixelSize.height) * this.scale);
    }

    public Point translatePoint(Point point) {
        return this.translatePoint(point.x, point.y);
    }

    @Override
    public boolean isColor() {
        return this.isColor;
    }

    @Override
    public int getColorCount() {
        return this.colorCount;
    }

    public void updateDisplay(int n, int n2, int n3, int n4) {
        this.getScreenUpdatePolicy().updateFace(n + this.displayBoundsInFace.x / this.pixelSize.width, n2 + this.displayBoundsInFace.y / this.pixelSize.height, n3, n4);
    }

    public void updateDisplay() {
        this.getScreenUpdatePolicy().updateFace(this.displayBoundsInFace.x / this.pixelSize.width, this.displayBoundsInFace.y / this.pixelSize.height, this.displayBoundsInFace.width / this.pixelSize.width, this.displayBoundsInFace.height / this.pixelSize.height);
    }

    public void updateFace(int n, int n2, int n3, int n4) {
        this.getScreenUpdatePolicy().updateFace(n, n2 + this.displayBoundsInFace.y / this.pixelSize.height, n3, n4);
    }

    public void updateFace() {
        this.getScreenUpdatePolicy().updateFace(0, 0, this.facePixelSize.width, this.facePixelSize.height);
    }

    public Point getNearestLocationInScreen(int n, int n2) {
        int n3;
        int n4;
        int n5 = (n - this.currentScaledFaceBounds.x / this.scale) / this.currentPixelSize.width;
        int n6 = (n2 - this.currentScaledFaceBounds.y / this.scale) / this.currentPixelSize.height;
        if (n5 < 0) {
            n5 = 0;
        }
        if (n6 < 0) {
            n6 = 0;
        }
        if (n5 > (n4 = this.currentScaledFaceBounds.width / this.scale / this.currentPixelSize.width)) {
            n5 = n4;
        }
        if (n6 > (n3 = this.currentScaledFaceBounds.height / this.scale / this.currentPixelSize.height)) {
            n6 = n3;
        }
        return this.reverseRotator.translatePoint(new Point(n5, n6));
    }

    public void updateComponent(int n, int n2, int n3, int n4) {
        if (!this.visible) {
            return;
        }
        Rectangle rectangle = this.rotator.translateRect(new Rectangle(n, n2, n3, n4));
        n = rectangle.x;
        n2 = rectangle.y;
        n3 = rectangle.width;
        n4 = rectangle.height;
        if (n3 < 0 || n4 < 0 || n + n3 < 0 || n2 + n4 < 0 || n >= this.currentFacePixelSize.width || n2 >= this.currentFacePixelSize.height) {
            return;
        }
        this.component.repaint((this.currentFaceBounds.x + n) * this.scale, (this.currentFaceBounds.y + n2) * this.scale, n3 * this.scale, n4 * this.scale);
    }

    public BufferedImage getRotatedFaceImage() {
        if (this.rotation == Orientation.NORMAL) {
            return this.getFaceImage();
        }
        return this.rotatedImage;
    }

    private void rotateFace() {
        if (this.rotationOp == null) {
            return;
        }
        this.rotationOp.filter(this.getFaceImage(), this.rotatedImage);
    }

    protected void paint(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.videoComponent != null && this.videoComponent.isVisible()) {
            this.videoComponent.paint(graphics);
        }
        this.rotateFace();
        this.screenComponent.paint(graphics);
        for (ScreenExtension screenExtension : this.extensionList) {
            screenExtension.postPaintHook(graphics, this.currentScaledFaceBounds);
        }
    }

    public void setFaceForegroundColor(Color color) {
        this.foreground = color;
        this.updateFace();
    }

    public void setFaceBackgroundColor(Color color) {
        this.background = color;
        this.updateFace();
    }

    public int getResolution() {
        int n = Device.getIntegerProperty((String)DPI_X, (int)0);
        int n2 = Device.getIntegerProperty((String)DPI_Y, (int)n);
        if (n == 0) {
            n = n2;
        }
        if (n == 0) {
            int n3 = Toolkit.getDefaultToolkit().getScreenResolution();
            return this.displayBounds.width * n3 / this.displayBoundsInFace.width;
        }
        return (n + n2) / 2;
    }

    public void addScreenExtension(ScreenExtension screenExtension) {
        this.extensionList.add(screenExtension);
    }

    public void removeScreenExtension(ScreenExtension screenExtension) {
        this.extensionList.remove(screenExtension);
    }

    public void addScreenBorderPainter(ScreenBorderPainter screenBorderPainter) {
        this.screenBorderPainters.add(screenBorderPainter);
    }

    public void removeScreenBorderPainter(ScreenBorderPainter screenBorderPainter) {
        this.screenBorderPainters.remove(screenBorderPainter);
    }

    public boolean isIn(int n, int n2) {
        return this.currentScaledFaceBounds.contains(n * this.scale, n2 * this.scale);
    }

    public boolean isTouch() {
        return this.screenGraphics.isTouch();
    }

    public boolean isEventOnMouseMove() {
        return this.screenGraphics.isEventOnMouseMove();
    }
}

