/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.EMFont;
import com.sun.kvem.FontManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.StringTokenizer;

public class SoftButton {
    private static boolean debug = false;
    private Rectangle bounds;
    private EMFont font;
    private String text;
    private Color fg;
    private Color bg;
    private int xoffset;
    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int CENTER = 2;
    private int alignment;
    public static final String FONT_SOFT_BUTTON = "softButton";
    public static final String SOFT_BUTTON_PREFIX = "softbutton.";

    public SoftButton(int n, int n2, int n3, int n4, EMFont eMFont, int n5) {
        this.bounds = new Rectangle(n, n2, n3, n4);
        this.font = eMFont;
        this.setAlignment(n5);
    }

    void setAlignment(int n) {
        this.alignment = n;
        this.updateTextPosition();
    }

    private void updateTextPosition() {
        if (this.alignment == 0 || this.text == null) {
            this.xoffset = 0;
        } else {
            int n = this.font.stringWidth(this.text);
            this.xoffset = this.alignment == 1 ? Math.max(0, this.bounds.width - n) : Math.max(0, (this.bounds.width - n) / 2);
        }
    }

    void setForeground(Color color) {
        this.fg = color;
    }

    void setBackground(Color color) {
        this.bg = color;
    }

    Color getForeground() {
        return this.fg;
    }

    Color getBackground() {
        return this.bg;
    }

    void paint(Graphics graphics) {
        graphics.setPaintMode();
        graphics.setColor(this.bg);
        graphics.clipRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        graphics.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        if (this.text != null && this.text.length() != 0) {
            graphics.setColor(this.fg);
            this.font.drawString(graphics, this.text, this.bounds.x + this.xoffset, this.bounds.y);
            if (debug) {
                System.out.println("Drew soft button\n  " + this + "\n at (" + this.bounds.x + this.xoffset + "," + this.bounds.y + ")");
            }
        }
    }

    Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    void setText(String string) {
        String string2 = this.text = string == null ? "" : string;
        if (debug) {
            System.out.println("Set soft button text:\n  " + this);
        }
        this.updateTextPosition();
    }

    void setText(String string, String string2) {
        if (string2 != null && this.font.stringWidth(string2) < this.bounds.width) {
            this.setText(string2);
        } else {
            this.setText(string);
        }
    }

    String getText() {
        return this.text;
    }

    public String toString() {
        return this.getClass().getName() + "[bounds=" + this.bounds + ", text='" + this.text + "', font=" + this.font + "]";
    }

    public static SoftButton[] createSoftButtons() {
        int n = 0;
        while (Device.getProperty((String)(SOFT_BUTTON_PREFIX + n)) != null) {
            ++n;
        }
        Device.getProperties().setProperty("softbutton.count", String.valueOf(n));
        SoftButton[] softButtonArray = new SoftButton[n];
        for (n = 0; n < softButtonArray.length; ++n) {
            String string = Device.getProperty((String)(SOFT_BUTTON_PREFIX + n));
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",:; \t\n");
            int n2 = Integer.decode(stringTokenizer.nextToken());
            int n3 = Integer.decode(stringTokenizer.nextToken());
            int n4 = Integer.decode(stringTokenizer.nextToken());
            int n5 = Integer.decode(stringTokenizer.nextToken());
            String string2 = FONT_SOFT_BUTTON;
            int n6 = 0;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equalsIgnoreCase("right")) {
                        n6 = 1;
                    } else if (string3.equalsIgnoreCase("center")) {
                        n6 = 2;
                    }
                }
            }
            int n7 = FontManager.getInstance().getFontID(string2);
            EMFont eMFont = FontManager.getInstance().getFont(n7);
            softButtonArray[n] = new SoftButton(n2, n3, n4, n5, eMFont, n6);
        }
        return softButtonArray;
    }
}

