/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.util.parmon;

import com.sun.jme.toolkit.util.parmon.ParentProcessListener;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.log4j.Logger;

public final class ParentProcessMonitor {
    private static final Logger LOGGER;
    private final Set<ParentProcessListener> parentProcessListeners = new CopyOnWriteArraySet<ParentProcessListener>();
    private long nativeData;

    public ParentProcessMonitor() {
        this.initialize();
    }

    public void addParentProcessListener(ParentProcessListener parentProcessListener) {
        this.parentProcessListeners.add(parentProcessListener);
    }

    public void removeParentProcessListener(ParentProcessListener parentProcessListener) {
        this.parentProcessListeners.remove(parentProcessListener);
    }

    public void start() {
        try {
            this.startNative();
        }
        catch (IllegalStateException illegalStateException) {
            LOGGER.error((Object)"Failed to start! Notifications will be disabled.", (Throwable)illegalStateException);
        }
    }

    public void stop() {
        this.stopNative();
    }

    private native void initialize() throws IllegalStateException;

    private native void startNative() throws IllegalStateException;

    private native void stopNative();

    private void parentTerminated() {
        LOGGER.debug((Object)"Parent process terminated.");
        try {
            ParentProcessMonitor.fixContextClassLoader();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Notifying " + this.parentProcessListeners.size() + " listeners."));
            }
            for (ParentProcessListener parentProcessListener : this.parentProcessListeners) {
                parentProcessListener.processTerminated();
            }
        }
        catch (Throwable throwable) {
            LOGGER.error((Object)"Exception while notifying listeners.", throwable);
        }
    }

    private static void fixContextClassLoader() {
        Thread.currentThread().setContextClassLoader(ParentProcessMonitor.class.getClassLoader());
    }

    static {
        System.loadLibrary("parentmon");
        LOGGER = Logger.getLogger(ParentProcessMonitor.class);
    }
}

