/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.emulator.cldc;

import com.sun.jme.services.appmanager.AppManagerService;
import com.sun.jme.toolkit.bridge.midletmanager.AppManagerAdapter;
import com.sun.jme.toolkit.device.appmanager.AppManagerException;
import java.util.HashMap;
import java.util.Map;
import kdp.KDP;

public final class MidletManagerAdapter
extends AppManagerAdapter {
    private KDP debugProxy;
    private Map<Integer, Integer> ids = new HashMap<Integer, Integer>();
    private int lastId = -1;

    public MidletManagerAdapter(AppManagerService appManagerService) {
        super(appManagerService);
    }

    public void setDebugProxy(KDP kDP) {
        this.debugProxy = kDP;
    }

    private int getAppIdFromName(String string) throws IllegalArgumentException, AppManagerException {
        String[] stringArray = this.getStorageNames();
        int[] nArray = this.getStorageIds();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return nArray[i];
        }
        throw new IllegalArgumentException("Application " + string + " not found.");
    }

    protected void installingMidlet(String string) {
        this.lastId = this.debugProxy.addApplication(string);
    }

    protected void midletInstalled(String string, int n) {
        if (this.lastId != -1) {
            this.ids.put(n, this.lastId);
        }
    }

    protected void midletRemoved(int n) {
        Integer n2 = this.ids.get(n);
        if (n2 != null) {
            this.debugProxy.removeApplication(n2.intValue());
        }
    }

    protected void midletRemoved(String string) {
        int n = -1;
        try {
            n = this.getAppIdFromName(string);
        }
        catch (Exception exception) {
            return;
        }
        Integer n2 = this.ids.get(n);
        if (n2 != null) {
            this.debugProxy.removeApplication(n2.intValue());
        }
    }
}

