/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public class ObservableGraphics
extends Graphics2D {
    public Graphics2D g;
    ObserverList observers = new ObserverList();
    private int offsetX = 0;
    private int offsetY = 0;

    public ObservableGraphics(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    private void update(int n, int n2, int n3, int n4) {
        this.observers.update(this, n + this.offsetX, n2 + this.offsetY, n3, n4);
    }

    private void update(Shape shape) {
        this.update(shape.getBounds());
    }

    private void update(Rectangle rectangle) {
        this.update(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void updateFontArea(String string, int n, int n2) {
        FontMetrics fontMetrics = this.g.getFontMetrics();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.stringWidth(string);
        int n5 = fontMetrics.getHeight();
        this.update(n, n2 - n3, n4, n5);
    }

    private void updateFontArea(char[] cArray, int n, int n2, int n3, int n4) {
        FontMetrics fontMetrics = this.g.getFontMetrics();
        int n5 = fontMetrics.getAscent();
        int n6 = fontMetrics.charsWidth(cArray, n, n2);
        int n7 = fontMetrics.getHeight();
        this.update(n3, n4 - n5, n6, n7);
    }

    public void addObserver(Observer observer) {
        this.observers.addObserver(observer);
    }

    public void removeObserver(Observer observer) {
        this.observers.removeObserver(observer);
    }

    public void addRenderingHints(Map map) {
        this.g.addRenderingHints(map);
    }

    @Override
    public void clip(Shape shape) {
        this.g.clip(shape);
    }

    @Override
    public void draw(Shape shape) {
        this.g.draw(shape);
        this.update(shape);
    }

    @Override
    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.g.draw3DRect(n, n2, n3, n4, bl);
        this.update(n, n2, n3, n4);
    }

    @Override
    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.g.drawGlyphVector(glyphVector, f, f2);
    }

    @Override
    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.g.drawImage(image, affineTransform, imageObserver);
    }

    @Override
    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.g.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    @Override
    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.g.drawRenderableImage(renderableImage, affineTransform);
    }

    @Override
    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.g.drawRenderedImage(renderedImage, affineTransform);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        this.g.drawString(string, f, f2);
        this.updateFontArea(string, (int)f, (int)f2);
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.g.drawString(string, n, n2);
        this.updateFontArea(string, n, n2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.g.drawString(attributedCharacterIterator, f, f2);
    }

    @Override
    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.g.drawString(attributedCharacterIterator, n, n2);
    }

    @Override
    public void fill(Shape shape) {
        this.g.fill(shape);
        this.update(shape);
    }

    @Override
    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.g.fill3DRect(n, n2, n3, n4, bl);
        this.update(n, n2, n3, n4);
    }

    @Override
    public Color getBackground() {
        return this.g.getBackground();
    }

    @Override
    public Composite getComposite() {
        return this.g.getComposite();
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.g.getDeviceConfiguration();
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.g.getFontRenderContext();
    }

    @Override
    public Paint getPaint() {
        return this.g.getPaint();
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key key) {
        return this.g.getRenderingHint(key);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.g.getRenderingHints();
    }

    @Override
    public Stroke getStroke() {
        return this.g.getStroke();
    }

    @Override
    public AffineTransform getTransform() {
        return this.g.getTransform();
    }

    @Override
    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.g.hit(rectangle, shape, bl);
    }

    @Override
    public void rotate(double d) {
        this.g.rotate(d);
    }

    @Override
    public void rotate(double d, double d2, double d3) {
        this.g.rotate(d, d2, d3);
    }

    @Override
    public void scale(double d, double d2) {
        this.g.scale(d, d2);
    }

    @Override
    public void setBackground(Color color) {
        this.g.setBackground(color);
    }

    @Override
    public void setComposite(Composite composite) {
        this.g.setComposite(composite);
    }

    @Override
    public void setPaint(Paint paint) {
        this.g.setPaint(paint);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.g.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.g.setRenderingHints(map);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.g.setStroke(stroke);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.g.setTransform(affineTransform);
    }

    @Override
    public void shear(double d, double d2) {
        this.g.shear(d, d2);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.g.transform(affineTransform);
    }

    @Override
    public void translate(double d, double d2) {
        this.g.translate(d, d2);
        this.offsetX += (int)d;
        this.offsetY += (int)d2;
    }

    @Override
    public void translate(int n, int n2) {
        this.g.translate(n, n2);
        this.offsetX += n;
        this.offsetY += n2;
    }

    @Override
    public void clearRect(int n, int n2, int n3, int n4) {
        this.g.clearRect(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    @Override
    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.copyArea(n, n2, n3, n4, n5, n6);
    }

    @Override
    public Graphics create() {
        ObservableGraphics observableGraphics = new ObservableGraphics((Graphics2D)this.g.create());
        observableGraphics.observers = this.observers;
        observableGraphics.offsetX = this.offsetX;
        observableGraphics.offsetY = this.offsetY;
        return observableGraphics;
    }

    @Override
    public Graphics create(int n, int n2, int n3, int n4) {
        ObservableGraphics observableGraphics = new ObservableGraphics((Graphics2D)this.g.create(n, n2, n3, n4));
        observableGraphics.observers = this.observers;
        observableGraphics.offsetX = this.offsetX + n;
        observableGraphics.offsetY = this.offsetY + n2;
        return observableGraphics;
    }

    @Override
    public void dispose() {
        this.g.dispose();
    }

    @Override
    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.g.drawChars(cArray, n, n2, n3, n4);
        this.updateFontArea(cArray, n, n2, n3, n4);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
        this.update(n, n2, n3 - n, n4 - n2);
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
        this.update(n, n2, n3 - n, n4 - n2);
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, color, imageObserver);
        this.update(n, n2, n3 + 1, n4 + 1);
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, n3, n4, imageObserver);
        this.update(n, n2, n3 + 1, n4 + 1);
        return bl;
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, color, imageObserver);
    }

    @Override
    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        boolean bl = this.g.drawImage(image, n, n2, imageObserver);
        this.update(n, n2, image.getWidth(null), image.getHeight(null));
        return bl;
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
        this.update(n, n2, n3 - n + 1, n4 - n2 + 1);
    }

    @Override
    public void drawOval(int n, int n2, int n3, int n4) {
        this.g.drawOval(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void drawPolygon(Polygon polygon) {
        this.g.drawPolygon(polygon);
    }

    @Override
    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolygon(nArray, nArray2, n);
    }

    @Override
    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolyline(nArray, nArray2, n);
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawRoundRect(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void fillOval(int n, int n2, int n3, int n4) {
        this.g.fillOval(n, n2, n3, n4);
        this.update(n, n2, n3 + 1, n4 + 1);
    }

    @Override
    public void fillPolygon(Polygon polygon) {
        this.g.fillPolygon(polygon);
    }

    @Override
    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.fillPolygon(nArray, nArray2, n);
    }

    @Override
    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
        this.update(n, n2, n3, n4);
    }

    @Override
    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
        this.update(n, n2, n3, n4);
    }

    @Override
    public void finalize() {
        super.finalize();
    }

    @Override
    public Shape getClip() {
        return this.g.getClip();
    }

    @Override
    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    @Override
    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.g.getClipBounds(rectangle);
    }

    @Override
    public Color getColor() {
        return this.g.getColor();
    }

    @Override
    public Font getFont() {
        return this.g.getFont();
    }

    @Override
    public FontMetrics getFontMetrics() {
        return this.g.getFontMetrics();
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    @Override
    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.g.hitClip(n, n2, n3, n4);
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    @Override
    public void setClip(Shape shape) {
        this.g.setClip(shape);
    }

    @Override
    public void setColor(Color color) {
        this.g.setColor(color);
    }

    @Override
    public void setFont(Font font) {
        this.g.setFont(font);
    }

    @Override
    public void setPaintMode() {
        this.g.setPaintMode();
    }

    @Override
    public void setXORMode(Color color) {
        this.g.setXORMode(color);
    }

    @Override
    public String toString() {
        return this.getClass().toString() + "[" + this.g.toString() + "]";
    }

    private static class ObserverList {
        Observer head;
        ObserverList tail;

        private ObserverList() {
        }

        void addObserver(Observer observer) {
            if (this.head == null) {
                this.head = observer;
            } else if (!this.head.equals(observer)) {
                if (this.tail == null) {
                    this.tail = new ObserverList();
                }
                this.tail.addObserver(observer);
            }
        }

        void removeObserver(Observer observer) {
            if (this.head != null && !this.head.equals(observer)) {
                this.tail.removeObserver(observer);
            }
        }

        void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
            if (this.head != null) {
                this.head.update(observableGraphics, n, n2, n3, n4);
                if (this.tail != null) {
                    this.tail.update(observableGraphics, n, n2, n3, n4);
                }
            }
        }
    }

    public static interface Observer {
        public void update(ObservableGraphics var1, int var2, int var3, int var4, int var5);
    }
}

