/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem;

import com.sun.kvem.Device;
import com.sun.kvem.ObservableGraphics;
import com.sun.kvem.Screen;
import com.sun.kvem.ScreenUpdatePolicy;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PeriodicFaceUpdatePolicy
implements ScreenUpdatePolicy,
ObservableGraphics.Observer {
    protected static transient Logger LOGGER = Logger.getLogger(PeriodicFaceUpdatePolicy.class);
    private int faceRefreshRate;
    private int[] faceRefreshRateRange = new int[2];
    private int sleepTime;
    private final Rectangle updateClip = new Rectangle();
    private Screen screen;
    public static final String DISPLAY_REFRESH_RATE = "screen.refresh.rate";
    public static final String DISPLAY_REFRESH_RATE_RANGE = "screen.refresh.rateRange";

    public PeriodicFaceUpdatePolicy(Screen screen) {
        this.screen = screen;
        this.start();
    }

    public PeriodicFaceUpdatePolicy() {
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    private void start() {
        final Dimension dimension = this.screen.getPixelSize();
        final Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Rectangle rectangle = PeriodicFaceUpdatePolicy.this.updateClip;
                synchronized (rectangle) {
                    PeriodicFaceUpdatePolicy.this.screen.updateComponent(((PeriodicFaceUpdatePolicy)PeriodicFaceUpdatePolicy.this).updateClip.x * dimension.width, ((PeriodicFaceUpdatePolicy)PeriodicFaceUpdatePolicy.this).updateClip.y * dimension.height, ((PeriodicFaceUpdatePolicy)PeriodicFaceUpdatePolicy.this).updateClip.width * dimension.width, ((PeriodicFaceUpdatePolicy)PeriodicFaceUpdatePolicy.this).updateClip.height * dimension.height);
                    PeriodicFaceUpdatePolicy.this.updateClip.setBounds(0, 0, 0, 0);
                }
            }
        };
        String string = Device.getProperty((String)DISPLAY_REFRESH_RATE_RANGE, (String)"1,30");
        try {
            this.faceRefreshRateRange[0] = Integer.parseInt(string.substring(0, string.indexOf(44)).trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.faceRefreshRateRange[0] = 1;
        }
        try {
            this.faceRefreshRateRange[1] = Integer.parseInt(string.substring(string.indexOf(44) + 1, string.length()).trim());
        }
        catch (NumberFormatException numberFormatException) {
            this.faceRefreshRateRange[1] = 30;
        }
        this.setFaceRefreshRate(Device.getIntegerProperty((String)DISPLAY_REFRESH_RATE, (int)this.faceRefreshRateRange[1]));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(PeriodicFaceUpdatePolicy.this.sleepTime);
                            Rectangle rectangle = PeriodicFaceUpdatePolicy.this.updateClip;
                            synchronized (rectangle) {
                                if (((PeriodicFaceUpdatePolicy)PeriodicFaceUpdatePolicy.this).updateClip.width <= 0 || ((PeriodicFaceUpdatePolicy)PeriodicFaceUpdatePolicy.this).updateClip.height <= 0) {
                                    continue;
                                }
                            }
                            SwingUtilities.invokeAndWait(runnable);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        LOGGER.warn((Object)interruptedException, (Throwable)interruptedException);
                        continue;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        LOGGER.warn((Object)invocationTargetException, (Throwable)invocationTargetException);
                        continue;
                    }
                    break;
                }
            }
        }, "Periodic Display Updater").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFace(int n, int n2, int n3, int n4) {
        Rectangle rectangle = this.updateClip;
        synchronized (rectangle) {
            if (this.updateClip.width == 0 || this.updateClip.height == 0) {
                this.updateClip.setBounds(n, n2, n3, n4);
            } else {
                int n5 = Math.min(this.updateClip.x, n);
                int n6 = Math.min(this.updateClip.y, n2);
                int n7 = Math.max(this.updateClip.x + this.updateClip.width, n + n3);
                int n8 = Math.max(this.updateClip.y + this.updateClip.height, n2 + n4);
                this.updateClip.x = n5;
                this.updateClip.y = n6;
                this.updateClip.width = n7 - n5;
                this.updateClip.height = n8 - n6;
            }
        }
    }

    @Override
    public void updateFace() {
        Dimension dimension = this.screen.getFacePixelSize();
        this.updateFace(0, 0, dimension.width, dimension.height);
    }

    @Override
    public void update(ObservableGraphics observableGraphics, int n, int n2, int n3, int n4) {
        this.updateFace(n, n2, n3, n4);
    }

    public int[] getFaceRefreshRateRange() {
        return this.faceRefreshRateRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFaceRefreshRate(int n) {
        if (n >= this.faceRefreshRateRange[0] && n <= this.faceRefreshRateRange[1]) {
            Rectangle rectangle = this.updateClip;
            synchronized (rectangle) {
                this.faceRefreshRate = n;
                this.sleepTime = 1000 / n;
            }
        }
        return this.faceRefreshRate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFaceRefreshRate() {
        int n;
        Rectangle rectangle = this.updateClip;
        synchronized (rectangle) {
            n = this.faceRefreshRate;
        }
        return n;
    }

    public String toString() {
        return "[PeriodicFaceUpdatePolicy, refresh rate = " + this.faceRefreshRate + "rateRange = (" + this.faceRefreshRateRange[0] + " - " + this.faceRefreshRateRange[1] + ")]";
    }
}

