/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.jsr120.impl.rmi;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistration;
import com.sun.jme.toolkit.deviceRegistry.api.DeviceRegistrationManager;
import com.sun.jme.toolkit.jsr120.api.PhoneNumberHolder;
import com.sun.jme.toolkit.jsr120.api.Sms;
import com.sun.jme.toolkit.jsr120.api.SmsConsumer;
import com.sun.jme.toolkit.jsr120.api.SmsRouter;
import com.sun.jme.toolkit.jsr120.impl.rmi.SmsRouterServiceMBean;
import com.sun.jme.toolkit.remoting.client.api.DeviceConnectionManager;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SmsRouterService
implements SmsRouter,
SmsRouterServiceMBean,
DeviceRegistration {
    private static final Logger LOGGER = Logger.getLogger(SmsRouterService.class);
    protected transient DeviceConnectionManager deviceConnectionManager;
    protected transient DeviceRegistrationManager deviceRegistrationManager;
    protected transient Map<String, SmsConsumer> routingTable = new HashMap<String, SmsConsumer>();

    public void setDeviceConnectionManager(DeviceConnectionManager deviceConnectionManager) {
        this.deviceConnectionManager = deviceConnectionManager;
    }

    public void setDeviceRegistrationManager(DeviceRegistrationManager deviceRegistrationManager) {
        this.deviceRegistrationManager = deviceRegistrationManager;
    }

    public void start() throws Exception {
        this.deviceRegistrationManager.addDeviceManagerListener((DeviceRegistration)this);
    }

    public void stop() throws Exception {
        this.deviceRegistrationManager.removeDeviceManagerListener((DeviceRegistration)this);
    }

    public void routeSms(Sms sms) throws Exception {
        String string = new String(sms.getDestinationPhoneNumber());
        LOGGER.info((Object)("Routing SMS to device with number " + string));
        SmsConsumer smsConsumer = this.routingTable.get(string);
        if (smsConsumer == null) {
            LOGGER.warn((Object)("Could not find device with number " + string));
            throw new IllegalArgumentException("Could not find device with number " + string);
        }
        smsConsumer.processSms(sms);
    }

    public void registeredDevice(int n) {
        LOGGER.info((Object)("Allocating phone number for device with ID " + n));
        String string = this.toPhoneNumber(n);
        LOGGER.info((Object)("Allocated phone number " + string));
        try {
            ObjectServerConnection objectServerConnection = this.deviceConnectionManager.openDeviceConnection(n);
            SmsConsumer smsConsumer = (SmsConsumer)objectServerConnection.findObject(SmsConsumer.class, "SmsConsumer");
            this.routingTable.put(string, smsConsumer);
            PhoneNumberHolder phoneNumberHolder = (PhoneNumberHolder)objectServerConnection.findObject(PhoneNumberHolder.class, "PhoneNumberHolder");
            phoneNumberHolder.setPhoneNumber(string);
        }
        catch (Exception exception) {
            LOGGER.error((Object)exception, (Throwable)exception);
        }
    }

    public void unregisteredDevice(int n) {
        LOGGER.info((Object)("Deallocating phone number for device with ID " + n));
        String string = this.toPhoneNumber(n);
        LOGGER.info((Object)("Deallocated phone number " + string));
        this.routingTable.remove(string);
    }

    private String toPhoneNumber(int n) {
        return "+" + (123456789 + n);
    }
}

