/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kdp.KVMDebugProxy;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.PacketStreamException;
import kdp.ProxyConnectionException;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.FieldInfo;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LocalVariable;
import kdp.classparser.attributes.SourceFileAttribute;

class DebuggerListener
extends ProxyListener
implements VMConstants {
    SocketConnection connDebugger;
    ProxyListener KVMListener;
    ClassManager manager = null;
    KVMDebugProxy parent = null;
    Packet replyPacket;
    boolean Ready = false;
    ServerSocket serverSocket = null;
    Socket acceptSocket = null;
    boolean stopDebuggerListener = false;
    Thread myThread;
    int remotePort = 0;
    boolean memprofSuspended;

    public DebuggerListener(ServerSocket serverSocket, Options options) {
        super(options);
        this.options = options;
        this.serverSocket = serverSocket;
    }

    public void set(ProxyListener proxyListener, ClassManager classManager, KVMDebugProxy kVMDebugProxy) {
        this.KVMListener = proxyListener;
        this.manager = classManager;
        this.parent = kVMDebugProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Packet packet) throws ProxyConnectionException {
        while (!this.Ready && !this.stopDebuggerListener) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.stopDebuggerListener) {
            return;
        }
        String string = String.valueOf(packet.id);
        Map map = this.waitingQueue;
        synchronized (map) {
            if ((packet.flags & 0xFFFFFF80) == 0 && packet.id < 0) {
                this.waitingQueue.put(string, packet);
            }
        }
        try {
            this.connDebugger.send(packet);
        }
        catch (IOException iOException) {
            throw new ProxyConnectionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStop() {
        Object object;
        if (this.stopDebuggerListener) {
            return;
        }
        Log.LOGN(3, "Debuggerlistener: setStop called");
        if (this.memprofSuspended) {
            Log.LOGN(3, "Resuming VM before disconnecting.");
            object = new Packet();
            ((Packet)object).cmdSet = (byte)18;
            ((Packet)object).cmd = (byte)6;
            ((Packet)object).data = new byte[0];
            this.KVMListener.send((Packet)object);
            this.memprofSuspended = false;
        }
        this.stopDebuggerListener = true;
        this.KVMListener.setStop();
        if (this.myThread == null) {
            this.parent.notifyProxyListenerStopped(this);
            return;
        }
        this.myThread.interrupt();
        object = this.packetQueue;
        synchronized (object) {
            this.packetQueue.notify();
        }
        object = this.waitingQueue;
        synchronized (object) {
            this.waitingQueue.notify();
        }
        try {
            if (this.acceptSocket != null) {
                this.acceptSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendErrorReply(ProxyListener proxyListener, PacketStream packetStream, short s) throws ProxyConnectionException {
        PacketStream packetStream2 = new PacketStream(proxyListener, packetStream.id(), -128, s);
        packetStream2.send();
    }

    public void connectToDebugger() throws IOException {
        try {
            Log.LOGN(3, "Waiting for debugger on port " + this.serverSocket.getLocalPort());
            this.acceptSocket = this.serverSocket.accept();
            this.connDebugger = new SocketConnection(this, this.acceptSocket);
            Log.LOGN(3, "Debugger connection received. " + this.acceptSocket);
            this.remotePort = this.acceptSocket.getPort();
        }
        catch (SecurityException securityException) {
            System.out.println("DebuggerListener1: " + securityException + " " + securityException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Packet packet = null;
        Object var3_2 = null;
        Object var4_3 = null;
        Object var5_4 = null;
        PacketStream packetStream = null;
        byte[] byArray = new String("JDWP-Handshake").getBytes();
        this.myThread = Thread.currentThread();
        try {
            int n;
            for (n = 0; n < byArray.length; ++n) {
                this.connDebugger.receiveByte();
            }
            for (n = 0; n < byArray.length; ++n) {
                this.connDebugger.sendByte(byArray[n]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        DebuggerListener debuggerListener = this;
        synchronized (debuggerListener) {
            this.Ready = true;
            this.notify();
        }
        new Thread((Runnable)this.connDebugger, "KDP Packet Receiver").start();
        boolean bl = this.options.getProxyMode();
        try {
            while (!this.stopDebuggerListener) {
                boolean bl2 = false;
                packet = this.waitForPacket();
                if (packet == null) {
                    Log.LOGN(3, "DebuggerListener: quitting");
                    this.setStop();
                    break;
                }
                if (packet.isReply() || !bl) {
                    Log.LOG(3, "DebuggerListener: ");
                    Log.LOGN(3, packet.toString(this.options.getVerbosity()));
                    this.KVMListener.send(packet);
                    continue;
                }
                Log.LOG(3, "DebuggerListener: start: " + this.remotePort + ": ");
                Log.LOGN(3, packet.toString(this.options.getVerbosity()));
                packetStream = new PacketStream(this, packet);
                switch (packet.cmdSet) {
                    case 1: {
                        bl2 = this.doVirtualMachineCmdset(packetStream);
                        break;
                    }
                    case 2: {
                        bl2 = this.doReferenceTypeCmdset(packetStream);
                        break;
                    }
                    case 6: {
                        bl2 = this.doMethodCmdset(packetStream);
                        break;
                    }
                    case 11: {
                        bl2 = this.doThreadReferenceCmdset(packetStream);
                        break;
                    }
                    case 12: {
                        bl2 = this.doThreadGroupReferenceCmdset(packetStream);
                        break;
                    }
                    case 16: {
                        bl2 = this.doStackFrameCmdset(packetStream);
                        break;
                    }
                    case 18: {
                        bl2 = this.doMemoryProfilerCmdset(packetStream);
                    }
                }
                if (bl2) continue;
                Log.LOG(6, "DebuggerListener:" + this.remotePort + ": ");
                Log.LOGN(6, packet.toString(this.options.getVerbosity()));
                this.KVMListener.send(packet);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println(packet.cmdSet + "/" + packet.cmd + " caused: " + arrayIndexOutOfBoundsException);
            arrayIndexOutOfBoundsException.printStackTrace();
            PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 41);
            packetStream2.send();
        }
        catch (ProxyConnectionException proxyConnectionException) {
            Log.LOGN(3, "DebuggerListener: caught ProxyConnectionException");
            this.setStop();
        }
        this.parent.notifyProxyListenerStopped(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doVirtualMachineCmdset(PacketStream packetStream) throws ProxyConnectionException {
        boolean bl = false;
        switch (packetStream.cmd()) {
            case 1: {
                PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream2.writeString("Version 1.0");
                packetStream2.writeInt(1);
                packetStream2.writeInt(0);
                packetStream2.writeString("1.1.3");
                packetStream2.writeString("KVM/CLDC_VM");
                packetStream2.send();
                bl = true;
                break;
            }
            case 2: {
                String string = null;
                try {
                    ClassFile classFile2;
                    PacketStream packetStream3 = new PacketStream(this, packetStream.id(), -128, 0);
                    string = packetStream.readString();
                    if (string == null || string.length() < 2 || string.length() == 2 && string.charAt(0) == 'L') {
                        Log.LOGN(3, "ClassBySig: null class ");
                        packetStream3.writeInt(0);
                        packetStream3.send();
                        bl = true;
                        break;
                    }
                    Log.LOGN(3, "ClassBySig: class " + string);
                    for (ClassFile classFile2 : this.manager.classMap.values()) {
                        if (classFile2 == null) {
                            Log.LOGN(3, "ClassesBySig: Couldn't find classFile object");
                            this.sendErrorReply(this, packetStream, (short)41);
                            bl = true;
                            break;
                        }
                        if (string.compareTo(classFile2.getClassSignature()) != 0) continue;
                        Log.LOGN(3, "ClassBySig matched " + classFile2.getClassName());
                        Log.LOGN(6, "Class Signature: " + classFile2.getClassSignature());
                        packetStream3.writeInt(1);
                        packetStream3.writeByte(classFile2.getJDWPTypeTag());
                        packetStream3.writeInt(classFile2.getClassID());
                        packetStream3.writeInt(classFile2.getClassStatus());
                        packetStream3.send();
                        bl = true;
                        break;
                    }
                    if (bl) break;
                    Log.LOGN(3, "ClassBySig: class not found: " + string);
                    VMCall vMCall = new VMCall();
                    classFile2 = vMCall.callVMForClassBySig(string, "ClassBySig");
                    if (classFile2 == null) {
                        packetStream3.writeInt(0);
                        packetStream3.send();
                        bl = true;
                        break;
                    }
                    int n = vMCall.getNumClasses();
                    Log.LOGN(3, "ClassBySig: VM: numclasses " + n);
                    packetStream3.writeInt(n);
                    if (n > 0) {
                        packetStream3.writeByte(classFile2.getJDWPTypeTag());
                        packetStream3.writeInt(classFile2.getClassID());
                        packetStream3.writeInt(classFile2.getClassStatus());
                    }
                    packetStream3.send();
                    bl = true;
                }
                catch (PacketStreamException packetStreamException) {
                    Log.LOGN(3, "ClassBySig: VM exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)103);
                    bl = true;
                }
                break;
            }
            case 3: {
                Log.LOGN(3, "All_Classes command");
                PacketStream packetStream4 = new PacketStream(this.KVMListener, 1, 3);
                PacketStream packetStream5 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream4.send();
                packetStream4.waitForReply();
                int n = packetStream4.readInt();
                packetStream5.writeInt(n);
                for (int i = 0; i < n; ++i) {
                    byte by = packetStream4.readByte();
                    int n2 = packetStream4.readInt();
                    String string = packetStream4.readString();
                    int n3 = packetStream4.readInt();
                    packetStream5.writeByte(by);
                    packetStream5.writeInt(n2);
                    packetStream5.writeString(string);
                    packetStream5.writeInt(n3);
                    if (by != 3) {
                        string = new String(string.substring(1, string.length() - 1));
                    }
                    Log.LOGN(3, "AllClasses:  " + string + ", ID = " + Log.intToHex(n2));
                    ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n2));
                    if (classFile == null) {
                        classFile = this.manager.findClass(n2, string, by, n3);
                        if (classFile != null) continue;
                        Log.LOGN(3, "ALL_CLASSES_CMD: couldn't find classfile object");
                        continue;
                    }
                    classFile.setClassStatus(n3);
                }
                packetStream5.send();
                bl = true;
                break;
            }
            case 5: {
                PacketStream packetStream6 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream6.writeInt(1);
                packetStream6.writeInt(-32);
                packetStream6.send();
                bl = true;
                break;
            }
            case 6: {
                Log.LOGN(3, "Dispose");
                if (this.options.isVM_Version_3()) {
                    PacketStream packetStream7 = new PacketStream(this.KVMListener, 1, 6);
                    packetStream7.send();
                } else {
                    PacketStream packetStream8 = new PacketStream(this.KVMListener, 1, 10);
                    packetStream8.writeInt(0);
                    packetStream8.send();
                }
                PacketStream packetStream9 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream9.send();
                bl = true;
                this.setStop();
                break;
            }
            case 7: {
                while (!this.options.isReady()) {
                    DebuggerListener debuggerListener = this;
                    synchronized (debuggerListener) {
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new ProxyConnectionException();
                        }
                    }
                }
                Log.LOGN(3, "IDSizes");
                PacketStream packetStream10 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream10.writeInt(8);
                if (this.options.isVM_Version_3()) {
                    packetStream10.writeInt(8);
                } else {
                    packetStream10.writeInt(4);
                }
                packetStream10.writeInt(4);
                packetStream10.writeInt(4);
                packetStream10.writeInt(4);
                packetStream10.send();
                bl = true;
                break;
            }
            case 12: {
                PacketStream packetStream11 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream11.writeBoolean(false);
                packetStream11.writeBoolean(false);
                packetStream11.writeBoolean(true);
                packetStream11.writeBoolean(false);
                packetStream11.writeBoolean(false);
                packetStream11.writeBoolean(false);
                packetStream11.writeBoolean(false);
                packetStream11.send();
                bl = true;
                break;
            }
            case 13: {
                PacketStream packetStream12 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream12.writeString("");
                packetStream12.writeInt(0);
                packetStream12.writeInt(0);
                packetStream12.send();
                bl = true;
                break;
            }
            case 14: {
                Log.LOGN(3, "Dispose Objects: ");
                PacketStream packetStream13 = new PacketStream(this, packetStream.id(), -128, 0);
                packetStream13.send();
                bl = true;
                break;
            }
            case 9: {
                if (!this.options.getNetbeans40compat()) break;
                Log.LOGN(3, "Resume Command: ");
                this.options.decSuspendCount();
                if (this.options.getSuspendCount() >= 0) break;
                Log.LOGN(3, "Resume Command: not forwarding ");
                this.options.setSuspendCount(0);
                bl = true;
            }
        }
        return bl;
    }

    private boolean doReferenceTypeCmdset(PacketStream packetStream) throws ProxyConnectionException {
        boolean bl = false;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        switch (packetStream.cmd()) {
            case 1: {
                VMCall vMCall;
                int n;
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    Log.LOGN(3, "Signature cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                Log.LOGN(3, "Signature cmd: class id = " + Log.intToHex(n));
                if (n == -32) {
                    packetStream2.writeString("Lkvm_threadgroup;");
                    packetStream2.send();
                    bl = true;
                    break;
                }
                ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n));
                if (classFile == null && (classFile = (vMCall = new VMCall()).callVMForClass(n, "Signature")) == null) {
                    Log.LOGN(3, "Signature cmd: couldn't find classfile object");
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                Log.LOGN(3, "Signature cmd: returning " + classFile.getClassSignature());
                packetStream2.writeString(classFile.getClassSignature());
                packetStream2.send();
                bl = true;
                break;
            }
            case 2: {
                try {
                    packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    // empty catch block
                }
                packetStream2.writeInt(0);
                packetStream2.send();
                bl = true;
                break;
            }
            case 3: {
                VMCall vMCall;
                int n;
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    System.out.println("Modifiers cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n));
                if (classFile == null && (classFile = (vMCall = new VMCall()).callVMForClass(n, "Modifiers")) == null) {
                    Log.LOGN(3, "Modifiers cmd: Couldn't get ClassFile object");
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                packetStream2.writeInt(classFile.getRawAccessFlags());
                packetStream2.send();
                bl = true;
                break;
            }
            case 4: {
                VMCall vMCall;
                int n;
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    System.out.println("Fields cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                Log.LOGN(3, "field command: cid = " + Log.intToHex(n));
                ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n));
                if (classFile == null && (classFile = (vMCall = new VMCall()).callVMForClass(n, "Fields")) == null) {
                    Log.LOGN(3, "field_cmd: cf == null");
                    packetStream2.writeInt(0);
                    packetStream2.send();
                    bl = true;
                    break;
                }
                if (this.processFields(classFile, packetStream2, packetStream)) {
                    packetStream2.send();
                }
                bl = true;
                break;
            }
            case 5: {
                Object object;
                int n;
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    System.out.println("Methods cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                Log.LOGN(3, "methods command: cid = " + Log.intToHex(n));
                ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n));
                if (classFile == null && (classFile = ((VMCall)(object = new VMCall())).callVMForClass(n, "Methods")) == null) {
                    Log.LOGN(3, "method_cmd: cf == null");
                    packetStream2.writeInt(0);
                    packetStream2.send();
                    bl = true;
                    break;
                }
                if (classFile.getJDWPTypeTag() == 3) {
                    Log.LOGN(3, "methods_cmd: cf == arrayclass");
                    packetStream2.writeInt(0);
                    packetStream2.send();
                    bl = true;
                    break;
                }
                Log.LOGN(3, "methods for " + classFile.getClassFileName());
                int n2 = this.options.getMethod_index_base();
                ProxyListener.MethodID methodID = new ProxyListener.MethodID(this, classFile.getClassID(), n2);
                List list = classFile.getAllMethodInfo();
                Iterator iterator = list.iterator();
                Log.LOGN(5, "Methods: " + list.size() + " methods");
                packetStream2.writeInt(list.size());
                while (iterator.hasNext()) {
                    object = (MethodInfo)iterator.next();
                    if (object == null) {
                        Log.LOGN(3, "Methods cmd: MethodInfo is null ");
                        this.sendErrorReply(this, packetStream, (short)41);
                        return true;
                    }
                    methodID.setMethodPart(n2++);
                    Log.LOGN(5, "Method: id = " + methodID.toString());
                    methodID.writeMethodID(packetStream2);
                    Log.LOGN(5, "Method: name = " + ((MethodInfo)object).getName());
                    packetStream2.writeString(((MethodInfo)object).getName());
                    Log.LOGN(5, "Method: sig = " + ((MethodInfo)object).getSignatureRaw());
                    packetStream2.writeString(((MethodInfo)object).getSignatureRaw());
                    Log.LOGN(5, "Method: flags = " + ((MethodInfo)object).getAccessFlags());
                    packetStream2.writeInt(((MethodInfo)object).getAccessFlags());
                }
                packetStream2.send();
                bl = true;
                break;
            }
            case 7: {
                Object object;
                int n;
                Log.LOGN(3, "Source file cmd");
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    System.out.println("Sourcefile cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n));
                if (classFile == null && (classFile = ((VMCall)(object = new VMCall())).callVMForClass(n, "SourceFile")) == null) {
                    Log.LOGN(3, "Sourcefile cmd: Couldn't get ClassFile object");
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                SourceFileAttribute sourceFileAttribute = classFile.getSourceAttribute();
                if (sourceFileAttribute != null) {
                    object = sourceFileAttribute.getSourceFileName();
                    Log.LOGN(3, "Returning from attribute: " + (String)object);
                    packetStream2.writeString((String)object);
                } else {
                    Log.LOGN(3, "Creating source name: " + classFile.getBaseName() + ".java");
                    packetStream2.writeString(classFile.getBaseName() + ".java");
                }
                packetStream2.send();
                bl = true;
                break;
            }
            case 9: {
                int n;
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    Log.LOGN(3, "status cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                VMCall vMCall = new VMCall();
                ClassFile classFile = vMCall.callVMForClass(n, "Status");
                if (classFile == null) {
                    Log.LOGN(3, "Status cmd: Couldn't get ClassFile object ");
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                packetStream2.writeInt(classFile.getClassStatus());
                packetStream2.send();
                bl = true;
                break;
            }
            case 10: {
                Object object;
                int n;
                try {
                    n = packetStream.readInt();
                }
                catch (PacketStreamException packetStreamException) {
                    System.out.println("Interfaces cmd: exception: " + packetStreamException);
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                Log.LOGN(3, "Interface cmd: class id " + Log.intToHex(n));
                ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n));
                if (classFile == null && (classFile = ((VMCall)(object = new VMCall())).callVMForClass(n, "Interfaces")) == null) {
                    Log.LOGN(3, "Interfaces cmd: Couldn't get ClassFile object for id = " + Log.intToHex(n));
                    this.sendErrorReply(this, packetStream, (short)20);
                    bl = true;
                    break;
                }
                object = classFile.getAllInterfaces();
                Iterator iterator = object.iterator();
                Log.LOGN(3, "Interfaces: class " + classFile.getClassName() + " " + object.size() + " interfaces");
                packetStream2.writeInt(object.size());
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Log.LOGN(3, "interfaces: interfacename: " + string);
                    if (string == null) {
                        Log.LOGN(3, "Interfaces cmd: interface name is null");
                        this.sendErrorReply(this, packetStream, (short)20);
                        return true;
                    }
                    classFile = this.manager.findClass((byte)76, string);
                    if (classFile == null) {
                        VMCall vMCall = new VMCall();
                        String string2 = "L" + string + ";";
                        classFile = vMCall.callVMForClassBySig(string2, "Interfaces");
                        if (classFile == null) {
                            Log.LOGN(3, "interfaces: classname: null ClassFile");
                            packetStream2.writeInt(0);
                            continue;
                        }
                        Log.LOGN(3, "interfaces: classID: " + classFile.getClassID());
                        packetStream2.writeInt(classFile.getClassID());
                        continue;
                    }
                    Log.LOGN(3, "interfaces: classID: " + classFile.getClassID());
                    packetStream2.writeInt(classFile.getClassID());
                }
                packetStream2.send();
                bl = true;
            }
        }
        return bl;
    }

    private boolean doMethodCmdset(PacketStream packetStream) throws ProxyConnectionException {
        boolean bl = false;
        switch (packetStream.cmd()) {
            case 1: {
                this.lineTable(packetStream);
                bl = true;
                break;
            }
            case 2: {
                this.variableTable(packetStream);
                bl = true;
                break;
            }
            case 3: {
                this.byteCode(packetStream);
                bl = true;
            }
        }
        return bl;
    }

    private boolean doThreadReferenceCmdset(PacketStream packetStream) throws ProxyConnectionException {
        boolean bl = false;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        switch (packetStream.cmd()) {
            case 5: {
                Log.LOGN(3, "Threadreference: threadgroup");
                packetStream2.writeInt(-32);
                packetStream2.send();
                bl = true;
            }
        }
        return bl;
    }

    private boolean doThreadGroupReferenceCmdset(PacketStream packetStream) throws ProxyConnectionException {
        boolean bl = false;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        int n = 0;
        try {
            n = packetStream.readInt();
        }
        catch (PacketStreamException packetStreamException) {
            Log.LOGN(3, "ThreadGroup cmd: exception: " + packetStreamException);
        }
        switch (packetStream.cmd()) {
            case 1: {
                Log.LOGN(3, "ThreadGroup: name");
                packetStream2.writeString("KVM_System");
                packetStream2.send();
                bl = true;
                break;
            }
            case 2: {
                Log.LOGN(3, "ThreadGroup: parent");
                packetStream2.writeInt(0);
                packetStream2.send();
                bl = true;
                break;
            }
            case 3: {
                Log.LOGN(3, "ThreadGroup: children");
                if (n == -32) {
                    PacketStream packetStream3 = new PacketStream(this.KVMListener, 1, 4);
                    packetStream3.send();
                    try {
                        packetStream3.waitForReply();
                    }
                    catch (ProxyConnectionException proxyConnectionException) {
                        packetStream2.writeInt(0);
                        packetStream2.writeInt(0);
                        packetStream2.send();
                        bl = true;
                        break;
                    }
                    int n2 = packetStream3.readInt();
                    Log.LOGN(3, "threadgroup: " + n2 + " children");
                    packetStream2.writeInt(n2);
                    while (n2-- > 0) {
                        packetStream2.writeInt(packetStream3.readInt());
                    }
                } else {
                    packetStream2.writeInt(0);
                }
                packetStream2.writeInt(0);
                packetStream2.send();
                bl = true;
            }
        }
        return bl;
    }

    private boolean doStackFrameCmdset(PacketStream packetStream) throws ProxyConnectionException {
        boolean bl = false;
        int n = 1;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        switch (packetStream.cmd()) {
            case 3: {
                int n2;
                Log.LOGN(3, "Stackframe: thisobject");
                int n3 = packetStream.readInt();
                int n4 = packetStream.readInt();
                PacketStream packetStream3 = new PacketStream(this.KVMListener, 11, 6);
                packetStream3.writeInt(n3);
                packetStream3.writeInt(0);
                packetStream3.writeInt(1);
                packetStream3.send();
                try {
                    packetStream3.waitForReply();
                    packetStream3.readInt();
                    int n5 = packetStream3.readInt();
                    if (n5 == 0) {
                        n = 0;
                    }
                }
                catch (ProxyConnectionException proxyConnectionException) {
                    // empty catch block
                }
                packetStream3 = new PacketStream(this.KVMListener, 11, 6);
                packetStream3.writeInt(n3);
                packetStream3.writeInt(n4 - n);
                packetStream3.writeInt(1);
                packetStream3.send();
                try {
                    VMCall vMCall;
                    ClassFile classFile = null;
                    packetStream3.waitForReply();
                    packetStream3.readInt();
                    int n6 = packetStream3.readInt();
                    if (n6 != n4) {
                        Log.LOGN(3, "Stackframe: thisobject: mismatched frames");
                        throw new ProxyConnectionException();
                    }
                    n2 = packetStream3.readByte();
                    if (n2 != 1) {
                        Log.LOGN(3, "Stackframe: thisobject: wrong type tag");
                        throw new ProxyConnectionException();
                    }
                    int n7 = packetStream3.readInt();
                    ProxyListener.MethodID methodID = new ProxyListener.MethodID(this);
                    int n8 = methodID.readMethodPart(packetStream3) - this.options.getMethod_index_base();
                    classFile = (ClassFile)this.manager.classMap.get(new Integer(n7));
                    if (classFile == null && (classFile = (vMCall = new VMCall()).callVMForClass(n7, "ThisObject")) == null) {
                        Log.LOGN(3, "Stackframe: thisobject: could not find class object");
                        throw new ProxyConnectionException();
                    }
                    MethodInfo methodInfo = classFile.getMethodInfoByIndex(n8);
                    if (methodInfo == null) {
                        Log.LOGN(3, "Stackframe: thisobject: could not find method object");
                        throw new ProxyConnectionException();
                    }
                    if (methodInfo.is_static()) {
                        packetStream2.writeByte((byte)76);
                        packetStream2.writeInt(0);
                        packetStream2.send();
                        bl = true;
                        break;
                    }
                }
                catch (ProxyConnectionException proxyConnectionException) {
                    // empty catch block
                }
                packetStream3 = new PacketStream(this.KVMListener, 16, 1);
                packetStream3.writeInt(n3);
                packetStream3.writeInt(n4);
                packetStream3.writeInt(1);
                packetStream3.writeInt(0);
                packetStream3.writeByte((byte)76);
                packetStream3.send();
                try {
                    packetStream3.waitForReply();
                }
                catch (ProxyConnectionException proxyConnectionException) {
                    packetStream2.writeByte((byte)76);
                    packetStream2.writeInt(0);
                    packetStream2.send();
                    bl = true;
                    break;
                }
                int n9 = packetStream3.readInt();
                byte by = packetStream3.readByte();
                n2 = packetStream3.readInt();
                Log.LOGN(3, "Stackframe: thisobject tag: " + by + " objectID " + Log.intToHex(n2));
                packetStream2.writeByte(by);
                packetStream2.writeInt(n2);
                packetStream2.send();
                bl = true;
            }
        }
        return bl;
    }

    private boolean doMemoryProfilerCmdset(PacketStream packetStream) throws ProxyConnectionException {
        switch (packetStream.cmd()) {
            case 5: {
                this.memprofSuspended = true;
                break;
            }
            case 6: {
                this.memprofSuspended = false;
            }
        }
        return false;
    }

    @Override
    public String toString() {
        return new String("DebuggerListener: ");
    }

    protected String getClassName(byte[] byArray) {
        return new String("");
    }

    protected String getMethodName(byte[] byArray) {
        return new String("");
    }

    protected boolean processFields(ClassFile classFile, PacketStream packetStream, PacketStream packetStream2) {
        Log.LOGN(3, "processFields for " + classFile.getClassFileName());
        List list = classFile.getAllFieldInfo();
        if (list == null) {
            packetStream.writeInt(0);
            return true;
        }
        Iterator iterator = list.iterator();
        long l = (long)classFile.getClassID() << 32;
        Log.LOGN(5, "field class id is " + Log.intToHex(classFile.getClassID()) + " fieldid is " + Log.longToHex(l));
        packetStream.writeInt(list.size());
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = (FieldInfo)iterator.next();
            if (fieldInfo == null) {
                Log.LOGN(3, "Fields cmd: fieldinfo null ");
                this.sendErrorReply(this, packetStream2, (short)20);
                return false;
            }
            Log.LOGN(5, "Field: id = " + Log.longToHex(l));
            packetStream.writeLong(l++);
            Log.LOGN(5, "Field: name = " + fieldInfo.getName());
            packetStream.writeString(fieldInfo.getName());
            Log.LOGN(5, "Field: sig = " + fieldInfo.getType());
            packetStream.writeString(fieldInfo.getType());
            Log.LOGN(5, "Field: flags = " + fieldInfo.getAccessFlags());
            packetStream.writeInt(fieldInfo.getAccessFlags());
        }
        return true;
    }

    public void lineTable(PacketStream packetStream) {
        int n;
        Object object;
        ClassFile classFile = null;
        int[][] nArray = null;
        long l = -1L;
        long l2 = -1L;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        int n2 = packetStream.readInt();
        ProxyListener.MethodID methodID = new ProxyListener.MethodID(this);
        int n3 = methodID.readMethodPart(packetStream) - this.options.getMethod_index_base();
        if (this.options.isVM_Version_3()) {
            object = new PacketStream(this.KVMListener, -128, 5);
            ((PacketStream)object).writeInt(n2);
            methodID.writeMethodID((PacketStream)object);
            ((PacketStream)object).send();
            try {
                ((PacketStream)object).waitForReply();
                int n4 = ((PacketStream)object).readInt();
                Log.LOGN(3, "linenumber table: VM returned " + n4 + " entries.");
                if (n4 > 0) {
                    l2 = ((PacketStream)object).readLong();
                    l = ((PacketStream)object).readLong();
                    nArray = new int[n4][2];
                    for (int i = 0; i < n4; ++i) {
                        nArray[i][0] = ((PacketStream)object).readShort();
                        nArray[i][1] = ((PacketStream)object).readShort();
                    }
                }
            }
            catch (ProxyConnectionException proxyConnectionException) {
                nArray = null;
            }
        }
        if (nArray == null) {
            Log.LOGN(4, "linetable: class id= " + Log.intToHex(n2) + ", method id= " + methodID.toString());
            classFile = (ClassFile)this.manager.classMap.get(new Integer(n2));
            if (classFile == null && (classFile = ((VMCall)(object = new VMCall())).callVMForClass(n2, "LineTable")) == null) {
                Log.LOGN(3, "Linetable cmd: not found");
                this.sendErrorReply(this, packetStream, (short)41);
                return;
            }
            Log.LOGN(4, "linetable: class: " + classFile.getClassFileName());
            MethodInfo methodInfo = classFile.getMethodInfoByIndex(n3);
            if (methodInfo == null) {
                Log.LOGN(1, "Couldn't find methodinfo for index " + methodID + this.options.getMethod_index_base());
                this.sendErrorReply(this, packetStream, (short)23);
                return;
            }
            object = methodInfo.getCodeAttribute();
            if (object == null) {
                l = -1L;
                l2 = -1L;
            } else {
                l2 = 0L;
                l = ((CodeAttribute)object).getCodeLength() - 1;
            }
            nArray = methodInfo.getBreakableLineNumbers();
        }
        if (nArray == null) {
            Log.LOGN(1, "No linenumber table found for class " + classFile.getClassName());
            n = 0;
        } else {
            n = nArray.length;
        }
        packetStream2.writeLong(l2);
        packetStream2.writeLong(l);
        Log.LOGN(5, "Starting code offset = " + l2 + ", Ending code offset = " + l);
        Log.LOGN(5, "Code Length = " + n);
        packetStream2.writeInt(n);
        for (int i = 0; i < n; ++i) {
            packetStream2.writeLong(nArray[i][0]);
            packetStream2.writeInt(nArray[i][1]);
            Log.LOGN(5, "  index=" + nArray[i][0] + " l#=" + nArray[i][1]);
        }
        packetStream2.send();
    }

    public void variableTable(PacketStream packetStream) {
        int n;
        VMCall vMCall;
        List list = null;
        MethodInfo methodInfo = null;
        boolean bl = true;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        int n2 = packetStream.readInt();
        Log.LOGN(3, "variable: class id = " + Log.intToHex(n2));
        ProxyListener.MethodID methodID = new ProxyListener.MethodID(this);
        int n3 = methodID.readMethodPart(packetStream) - this.options.getMethod_index_base();
        ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n2));
        if (classFile == null && (classFile = (vMCall = new VMCall()).callVMForClass(n2, "VariableTable")) == null) {
            Log.LOGN(3, "Variabletable cmd: not found");
            this.sendErrorReply(this, packetStream, (short)41);
            return;
        }
        Log.LOGN(3, "variable: method id = " + methodID.toString());
        list = classFile.getVariableTableForMethodIndex(n3);
        methodInfo = classFile.getMethodInfoByIndex(n3);
        if (methodInfo == null) {
            Log.LOGN(3, "HandleVariableTable: Couldn't find method info for class " + classFile.getClassName());
            this.sendErrorReply(this, packetStream, (short)20);
            return;
        }
        short[][] sArray = null;
        if (this.options.isVM_Version_3()) {
            PacketStream packetStream3 = new PacketStream(this.KVMListener, -128, 4);
            packetStream3.writeInt(n2);
            methodID.writeMethodID(packetStream3);
            packetStream3.send();
            try {
                packetStream3.waitForReply();
                int n4 = packetStream3.readInt();
                Log.LOGN(3, "variable: VM returned " + n4 + " entries.");
                if (n4 > 0) {
                    bl = false;
                    sArray = new short[n4][3];
                    for (n = 0; n < n4; ++n) {
                        sArray[n][0] = packetStream3.readShort();
                        sArray[n][1] = packetStream3.readShort();
                        sArray[n][2] = packetStream3.readShort();
                    }
                }
            }
            catch (ProxyConnectionException proxyConnectionException) {
                bl = true;
            }
            catch (PacketStreamException packetStreamException) {
                bl = true;
            }
        }
        int n5 = methodInfo.getArgCount();
        Log.LOGN(3, "variable: argcount is " + n5);
        packetStream2.writeInt(n5);
        n = 0;
        if (list != null) {
            Log.LOGN(3, "variable: table size is " + list.size());
            packetStream2.writeInt(list.size());
            for (LocalVariable localVariable : list) {
                if (bl) {
                    packetStream2.writeLong(localVariable.getCodeIndex());
                } else {
                    packetStream2.writeLong(sArray[n][0]);
                }
                packetStream2.writeString(localVariable.getName());
                packetStream2.writeString(this.getJNISignature(localVariable.getType()));
                if (bl) {
                    packetStream2.writeInt(localVariable.getLength());
                } else {
                    packetStream2.writeInt(sArray[n][1]);
                }
                if (bl) {
                    packetStream2.writeInt(localVariable.getSlot());
                } else {
                    packetStream2.writeInt(sArray[n][2]);
                }
                ++n;
            }
        } else {
            packetStream2.writeInt(0);
        }
        packetStream2.send();
    }

    private void byteCode(PacketStream packetStream) {
        int n;
        Object object;
        MethodInfo methodInfo = null;
        PacketStream packetStream2 = new PacketStream(this, packetStream.id(), -128, 0);
        Log.LOGN(3, "Method: Bytecodes");
        Object var6_4 = null;
        int n2 = packetStream.readInt();
        Log.LOGN(3, "class id=0x" + Log.intToHex(n2));
        ProxyListener.MethodID methodID = new ProxyListener.MethodID(this);
        int n3 = methodID.readMethodPart(packetStream) - this.options.getMethod_index_base();
        ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n2));
        if (classFile == null && (classFile = ((VMCall)(object = new VMCall())).callVMForClass(n2, "Fields")) == null) {
            Log.LOGN(3, "Bytecode cmd: not found");
            this.sendErrorReply(this, packetStream, (short)20);
            return;
        }
        Log.LOGN(3, "method id=0x" + methodID.toString());
        methodInfo = classFile.getMethodInfoByIndex(n3);
        if (methodInfo == null) {
            Log.LOGN(3, "HandleByteCode: couldn't find method info for class " + classFile.getClassFileName());
            this.sendErrorReply(this, packetStream, (short)23);
            return;
        }
        object = methodInfo.getCodeAttribute();
        byte[] byArray = null;
        if (object == null) {
            n = 0;
        } else {
            byArray = methodInfo.getCodeAttribute().getByteCodes();
            n = byArray.length;
        }
        packetStream2.writeInt(n);
        if (n > 0) {
            packetStream2.writeByteArray(byArray);
        }
        packetStream2.send();
    }

    private String getJNISignature(String string) {
        int n;
        int n2 = n = string.length();
        String string2 = new String();
        Log.LOGN(6, "getJNISignature()  type == " + string);
        while ((n = string.lastIndexOf("[]", n)) != -1) {
            string2 = string2 + "[";
            n2 = n--;
        }
        String string3 = string.substring(0, n2);
        string2 = "int".equalsIgnoreCase(string3) ? string2 + "I" : ("boolean".equalsIgnoreCase(string3) ? string2 + "Z" : ("short".equalsIgnoreCase(string3) ? string2 + "S" : ("byte".equalsIgnoreCase(string3) ? string2 + "B" : ("char".equalsIgnoreCase(string3) ? string2 + "C" : ("long".equalsIgnoreCase(string3) ? string2 + "J" : ("float".equalsIgnoreCase(string3) ? string2 + "F" : ("double".equalsIgnoreCase(string3) ? string2 + "D" : string2 + "L" + string3.replace('.', '/') + ";")))))));
        return string2;
    }

    class VMCall {
        int numClasses;

        VMCall() {
        }

        protected ClassFile callVMForClass(int n, String string) {
            PacketStream packetStream;
            if (!DebuggerListener.this.options.isVM_Version_3()) {
                return null;
            }
            Log.LOGN(3, string + " cmd: calling VM");
            try {
                packetStream = new PacketStream(DebuggerListener.this.KVMListener, 2, 1);
                packetStream.writeInt(n);
                packetStream.send();
                packetStream.waitForReply();
            }
            catch (PacketStreamException packetStreamException) {
                Log.LOGN(3, string + " cmd: Couldn't get ClassFile object");
                return null;
            }
            String string2 = packetStream.readString();
            Log.LOGN(3, string + " cmd: VM returned " + string2);
            try {
                packetStream = new PacketStream(DebuggerListener.this.KVMListener, 1, 2);
                packetStream.writeString(string2);
                packetStream.send();
                packetStream.waitForReply();
            }
            catch (PacketStreamException packetStreamException) {
                Log.LOGN(3, string + " cmd: Couldn't get Class info");
                return null;
            }
            packetStream.readInt();
            byte by = packetStream.readByte();
            int n2 = packetStream.readInt();
            int n3 = packetStream.readInt();
            if (n != n2) {
                Log.LOGN(3, string + " cmd: class id mismatch: old " + n + " new " + n2);
            }
            Log.LOGN(3, string + " cmd: VM returned: tag:  " + by + ", cid " + n2 + ", status " + n3);
            String string3 = string2;
            if (by != 3) {
                string3 = new String(string2.substring(1, string2.length() - 1));
            }
            ClassFile classFile = DebuggerListener.this.manager.findClass(n2, string3, by, n3);
            return classFile;
        }

        protected ClassFile callVMForClassBySig(String string, String string2) {
            if (!DebuggerListener.this.options.isVM_Version_3()) {
                return null;
            }
            PacketStream packetStream = new PacketStream(DebuggerListener.this.KVMListener, 1, 2);
            packetStream.writeString(string);
            packetStream.send();
            packetStream.waitForReply();
            this.numClasses = packetStream.readInt();
            Log.LOGN(3, string2 + ": VM: numclasses " + this.numClasses);
            if (this.numClasses > 0) {
                byte by = packetStream.readByte();
                int n = packetStream.readInt();
                int n2 = packetStream.readInt();
                String string3 = new String(string);
                if (by != 3) {
                    string3 = new String(string3.substring(1, string3.length() - 1));
                }
                Log.LOGN(3, string2 + ": VM class found: " + Log.intToHex(n));
                ClassFile classFile = DebuggerListener.this.manager.findClass(n, string3, by, n2);
                if (classFile == null) {
                    Log.LOGN(3, string2 + ": couldn't find classfile object");
                }
                return classFile;
            }
            return null;
        }

        protected int getNumClasses() {
            return this.numClasses;
        }
    }
}

