/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Map;
import kdp.KVMDebugProxy;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.ProxyConnectionException;
import kdp.ProxyListener;
import kdp.SocketConnection;
import kdp.VMConstants;
import kdp.classparser.ClassFile;
import kdp.classparser.ClassManager;
import kdp.classparser.MethodInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;

class KVMListener
extends ProxyListener
implements VMConstants {
    SocketConnection connKvm;
    ProxyListener debuggerListener = null;
    KVMDebugProxy parent = null;
    ClassManager manager;
    boolean Ready = false;
    Socket remoteSocket = null;
    boolean stopKVMListener = false;
    Thread myThread;
    int localPort = 0;

    public KVMListener(Options options) {
        super(options);
    }

    public void set(ProxyListener proxyListener, ClassManager classManager, KVMDebugProxy kVMDebugProxy) {
        this.debuggerListener = proxyListener;
        this.manager = classManager;
        this.parent = kVMDebugProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void send(Packet packet) throws ProxyConnectionException {
        Object object;
        while (!this.Ready && !this.stopKVMListener) {
            object = this;
            synchronized (object) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.stopKVMListener) {
            return;
        }
        if (packet == null) {
            return;
        }
        object = String.valueOf(packet.id);
        if ((packet.flags & 0xFFFFFF80) == 0 && packet.id < 0) {
            Map map = this.waitingQueue;
            synchronized (map) {
                this.waitingQueue.put(object, packet);
            }
        }
        try {
            this.connKvm.send(packet);
        }
        catch (IOException iOException) {
            throw new ProxyConnectionException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStop() {
        if (this.stopKVMListener) {
            return;
        }
        Log.LOGN(3, "KVMlistener: setStop called");
        this.stopKVMListener = true;
        this.debuggerListener.setStop();
        if (this.myThread == null) {
            this.parent.notifyProxyListenerStopped(this);
            return;
        }
        this.myThread.interrupt();
        Object object = this.packetQueue;
        synchronized (object) {
            this.packetQueue.notify();
        }
        object = this.waitingQueue;
        synchronized (object) {
            this.waitingQueue.notify();
        }
        try {
            if (this.remoteSocket != null) {
                this.remoteSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        Object object;
        this.myThread = Thread.currentThread();
        try {
            while (this.remoteSocket == null) {
                try {
                    if (this.stopKVMListener) {
                        this.parent.notifyProxyListenerStopped(this);
                        return;
                    }
                    Log.LOGN(3, "KVMListener: attempting connection");
                    this.remoteSocket = new Socket(this.options.getRemoteHost(), this.options.getRemotePort());
                    Log.LOGN(3, "KVMListener: got connection " + this.remoteSocket);
                }
                catch (ConnectException connectException) {
                    System.err.println("KVMListener: Exception " + connectException + " KVM not ready");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.localPort = this.remoteSocket.getLocalPort();
            this.connKvm = new SocketConnection(this, this.remoteSocket);
        }
        catch (IOException iOException) {
            System.out.println("KVMListener: " + iOException.getMessage());
        }
        catch (SecurityException securityException) {
            System.out.println("KVMListener: " + securityException.getMessage());
        }
        if (!this.options.getProxyMode()) {
            object = new String("JDWP-Handshake").getBytes();
            try {
                int n;
                for (n = 0; n < ((Object)object).length; ++n) {
                    this.connKvm.sendByte((byte)object[n]);
                }
                for (n = 0; n < ((Object)object).length; ++n) {
                    this.connKvm.receiveByte();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = this;
        synchronized (object) {
            this.Ready = true;
            this.notify();
        }
        new Thread((Runnable)this.connKvm, "KDP KVM Connection Thread").start();
        if (this.options.getProxyMode()) {
            PacketStream packetStream = new PacketStream(this, -128, 1);
            packetStream.writeString("KVM Reference Debugger Agent");
            packetStream.writeByte((byte)1);
            packetStream.writeByte((byte)4);
            try {
                packetStream.send();
                packetStream.waitForReply();
            }
            catch (Exception exception) {
                System.out.println("Exception during handshake: " + exception + " exiting...");
                this.setStop();
                this.parent.notifyProxyListenerStopped(this);
                return;
            }
            object = packetStream.readString();
            int n = packetStream.readInt();
            Log.LOGN(1, "KVM Handshake return string: " + (String)object);
            Log.LOGN(1, "KVM Handshake return options: " + Log.intToHex(n));
            if ((n & 0x18000) >> 15 == 2) {
                Log.LOGN(1, "Method index base being set to 1");
                this.options.setMethod_index_base(1);
            }
            if ((n & 0x60000) >> 17 == 2) {
                Log.LOGN(1, "VM has line number table");
                Log.LOGN(1, "VM supports DISPOSE command");
                Log.LOGN(1, "VM supports ClassesBySig command");
                this.options.setVM_Version_3(true);
            }
        }
        this.options.setReady();
        try {
            while (!this.stopKVMListener) {
                boolean bl = false;
                Packet packet = this.waitForPacket();
                if (packet == null) {
                    Log.LOGN(3, "KVMListener: quitting");
                    this.setStop();
                    break;
                }
                Log.LOG(3, "KVMListener: start:" + this.localPort + ": ");
                Log.LOGN(3, packet.toString(this.options.getVerbosity()));
                if (this.options.getProxyMode() && (packet.flags & 0xFFFFFF80) == 0) {
                    switch (packet.cmdSet) {
                        case 64: {
                            switch (packet.cmd) {
                                case 100: {
                                    object = new PacketStream(this, packet);
                                    byte by = ((PacketStream)object).readByte();
                                    if (by > 0) {
                                        this.options.incSuspendCount();
                                    }
                                    int n = ((PacketStream)object).readInt();
                                    byte by2 = ((PacketStream)object).readByte();
                                    if (by2 != 8) break;
                                    int n2 = ((PacketStream)object).readInt();
                                    int n3 = ((PacketStream)object).readInt();
                                    byte by3 = ((PacketStream)object).readByte();
                                    int n4 = ((PacketStream)object).readInt();
                                    String string = ((PacketStream)object).readString();
                                    int n5 = ((PacketStream)object).readInt();
                                    if (by3 != 3) {
                                        string = new String(string.substring(1, string.length() - 1));
                                    }
                                    Log.LOGN(3, "ClassPrepare:  " + string + ", ID = " + Log.intToHex(n4));
                                    ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n4));
                                    if (classFile == null) {
                                        classFile = this.manager.findClass(n4, string, by3, n5);
                                        if (classFile == null) {
                                            Log.LOGN(3, "ClassPrepare: Could not load classfile " + string);
                                            break;
                                        }
                                    } else {
                                        Log.LOGN(3, "ClassPrepare: got classfile " + classFile.getClassName());
                                        classFile.setClassStatus(n5);
                                    }
                                }
                            }
                            break;
                        }
                        case -128: {
                            switch (packet.cmd) {
                                case 3: {
                                    object = new PacketStream(this, packet);
                                    this.handleSteppingInfo((PacketStream)object);
                                    bl = true;
                                }
                            }
                            break;
                        }
                    }
                }
                if (bl) continue;
                Log.LOG(6, "KVMListener:" + this.localPort + ": ");
                Log.LOGN(6, packet.toString(this.options.getVerbosity()));
                this.debuggerListener.send(packet);
            }
        }
        catch (ProxyConnectionException proxyConnectionException) {
            Log.LOGN(3, "KVMListener: caught ProxyConnectionException");
            this.setStop();
        }
        this.parent.notifyProxyListenerStopped(this);
    }

    private void handleSteppingInfo(PacketStream packetStream) throws ProxyConnectionException {
        int n;
        long l;
        long l2;
        long l3;
        MethodInfo methodInfo;
        int n2 = packetStream.readInt();
        int n3 = packetStream.readInt();
        ProxyListener.MethodID methodID = new ProxyListener.MethodID(this);
        int n4 = methodID.readMethodPart(packetStream) - this.options.getMethod_index_base();
        long l4 = packetStream.readLong();
        Log.LOGN(3, "handleSteppingInfo: cep = " + Log.intToHex(n2) + " cid = " + Log.intToHex(n3) + " mid = " + methodID.toString());
        PacketStream packetStream2 = new PacketStream(this, -128, 2);
        packetStream2.writeInt(n2);
        ClassFile classFile = (ClassFile)this.manager.classMap.get(new Integer(n3));
        if (classFile == null || (methodInfo = classFile.getMethodInfoByIndex(n4)) == null) {
            packetStream2.writeLong(0L);
            packetStream2.writeLong(0L);
            packetStream2.send();
            packetStream2.waitForReply();
            return;
        }
        LineNumberTableAttribute lineNumberTableAttribute = null;
        CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
        if (codeAttribute != null) {
            lineNumberTableAttribute = codeAttribute.getLineNumberTable();
        }
        if (codeAttribute == null || lineNumberTableAttribute == null) {
            l3 = -1L;
            l2 = -1L;
            l = -1L;
            n = -1;
            int n5 = -1;
            int n6 = -1;
        } else {
            n = lineNumberTableAttribute.getCurrentLineCodeIndex(l4);
            int n7 = lineNumberTableAttribute.getNextExecutableLineCodeIndex(l4);
            int n8 = lineNumberTableAttribute.getDupCurrentExecutableLineCodeIndex(l4);
            l = lineNumberTableAttribute.getStartPCFromIndex(n7);
            l2 = lineNumberTableAttribute.getStartPCFromIndex(n8);
            l3 = lineNumberTableAttribute.getOffsetofDupNextLine(n8);
        }
        Log.LOGN(3, "handleSteppingInfo  current offset = " + l4);
        Log.LOGN(3, "handleSteppingInfo  target offset = " + l);
        Log.LOGN(3, "handleSteppingInfo  dup of current line offset = " + l2);
        Log.LOGN(3, "handleSteppingInfo  offset after current dup = " + l3);
        if (lineNumberTableAttribute != null) {
            Log.LOGN(3, "handleSteppingInfo current line number = " + lineNumberTableAttribute.getLineNumberFromIndex(n));
        }
        packetStream2.writeLong(l);
        packetStream2.writeLong(l2);
        packetStream2.writeLong(l3);
        packetStream2.send();
        packetStream2.waitForReply();
    }

    @Override
    public String toString() {
        return new String("KVMListener: ");
    }
}

