/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.LocalVariableTable;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class LocalVariableTableAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int localVariableTableLength;
    private LocalVariableTable[] localVariableTable;

    public LocalVariableTableAttribute(DataInputStream dataInputStream, int n, int n2) throws IOException {
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.localVariableTableLength = dataInputStream.readUnsignedShort();
        this.localVariableTable = new LocalVariableTable[this.localVariableTableLength];
        for (int i = 0; i < this.localVariableTableLength; ++i) {
            this.localVariableTable[i] = new LocalVariableTable();
            this.localVariableTable[i].startPC = dataInputStream.readUnsignedShort();
            this.localVariableTable[i].length = dataInputStream.readUnsignedShort();
            this.localVariableTable[i].nameIndex = dataInputStream.readUnsignedShort();
            this.localVariableTable[i].descriptorIndex = dataInputStream.readUnsignedShort();
            this.localVariableTable[i].index = dataInputStream.readUnsignedShort();
        }
    }

    @Override
    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + "\t" + constantUtf8Info.toString();
        for (int i = 0; i < this.localVariableTableLength; ++i) {
            constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.localVariableTable[i].nameIndex];
            string = string + "\n\t\t\t\tName =\t" + constantUtf8Info.toString();
            constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.localVariableTable[i].descriptorIndex];
            string = string + "\n\t\t\t\tClass=\t" + StringParser.parseDataType(constantUtf8Info.toString());
        }
        return string;
    }

    public LocalVariableTable[] getLocalVariableTable() {
        return this.localVariableTable;
    }
}

