/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.kvem.ScreenSpi;
import com.sun.kvem.mma.QTPlayer;
import com.sun.mmedia.MediaException;
import com.sun.mmedia.VideoPlayer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.ImageProducer;
import org.apache.log4j.Logger;
import quicktime.QTException;
import quicktime.app.view.QTImageProducer;
import quicktime.qd.QDRect;
import quicktime.std.movies.Movie;
import quicktime.std.movies.MovieDrawingComplete;

public class QTMoviePlayer
extends QTPlayer
implements VideoPlayer {
    private static final Logger LOGGER = Logger.getLogger(QTMoviePlayer.class);
    private QTImageProducer imgProducer;
    private ScreenSpi screen;
    private boolean fullScreen = false;
    private Rectangle movieBounds = new Rectangle();
    private Rectangle fullScreenBounds;

    @Override
    public void init(byte[] byArray, String string) throws MediaException {
        super.init(byArray, string);
        this.initMovie();
    }

    @Override
    public void init(String string, String string2) throws MediaException {
        super.init(string, string2);
        this.initMovie();
    }

    public void setScreen(ScreenSpi screenSpi) {
        this.screen = screenSpi;
    }

    private void fitMovieInScreen(QDRect qDRect) {
        Rectangle rectangle = this.screen.getDisplayBoundsInFace();
        float f = (float)qDRect.getWidth() / (float)rectangle.width;
        float f2 = (float)qDRect.getHeight() / (float)rectangle.height;
        if (f > 1.0f || f2 > 1.0f) {
            int n;
            int n2;
            if (f > f2) {
                n2 = rectangle.width;
                n = (int)((float)rectangle.height / f2);
            } else {
                n2 = (int)((float)rectangle.width / f);
                n = rectangle.height;
            }
            qDRect.resize(n2, n);
        }
    }

    private void initMovie() throws MediaException {
        QDRect qDRect;
        int n = 100;
        try {
            LOGGER.debug((Object)"QTMoviePlayer.initMovie()");
            while (this.getMovie().getBox().getWidth() == 0 && n-- > 0) {
                this.getMovie().task(200);
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (n < 0) {
                throw new MediaException("Can't retrieve movie header");
            }
            qDRect = this.getMoviePlayer().getDisplayBounds();
            this.fitMovieInScreen(qDRect);
            this.getMoviePlayer().setDisplayBounds(qDRect);
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
        this.getMovieBounds().setSize(qDRect.getWidth(), qDRect.getHeight());
        LOGGER.debug((Object)"QTMoviePlayer.initMovie() finished successfully");
    }

    private void setDrawingCompleteHook(final QTImageProducer qTImageProducer) throws QTException {
        this.getMovie().setDrawingCompleteProc(0, new MovieDrawingComplete(){

            public int execute(Movie movie) {
                try {
                    qTImageProducer.updateConsumers(null);
                }
                catch (QTException qTException) {
                    return qTException.errorCode();
                }
                return 0;
            }
        });
    }

    private QTImageProducer createImageProducer() throws QTException {
        return new QTImageProducer(this.getMoviePlayer(), new Dimension(this.getMovieBounds().width, this.getMovieBounds().height));
    }

    private boolean validateBounds() {
        return this.getMovieBounds().width > 0 && this.getMovieBounds().height > 0;
    }

    @Override
    public void start() throws MediaException {
        if (this.imgProducer == null && this.validateBounds()) {
            try {
                this.imgProducer = this.createImageProducer();
                this.setDrawingCompleteHook(this.imgProducer);
            }
            catch (QTException qTException) {
                throw new MediaException((Throwable)qTException);
            }
        }
        super.start();
    }

    @Override
    public void close() throws MediaException {
        try {
            this.getMovie().removeDrawingCompleteProc();
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
        super.close();
    }

    public ImageProducer getImageProducer() {
        return this.imgProducer;
    }

    public int getResourceWidth() {
        try {
            return this.getMoviePlayer().getOriginalSize().getWidth();
        }
        catch (QTException qTException) {
            return -1;
        }
    }

    public int getResourceHeight() {
        try {
            return this.getMoviePlayer().getOriginalSize().getHeight();
        }
        catch (QTException qTException) {
            return -1;
        }
    }

    public long mapFrameToTime(int n) {
        try {
            if (n < 0) {
                return -1L;
            }
            return (long)(1000000.0f * (float)n / (float)this.getMovie().getTimeScale());
        }
        catch (QTException qTException) {
            return -1L;
        }
    }

    public int mapTimeToFrame(long l) {
        try {
            if (l < 0L) {
                return 0;
            }
            float f = (float)l / 1000000.0f;
            return Math.round(f * (float)this.getMovie().getTimeScale());
        }
        catch (QTException qTException) {
            return -1;
        }
    }

    public int skip(int n) throws MediaException {
        int n2 = this.mapTimeToFrame(this.getMediaTime());
        return this.seek(n2 + n) - n2;
    }

    private long getMovieDuration() throws QTException {
        Movie movie = this.getMovie();
        return (long)((float)movie.getDuration() / (float)movie.getTimeScale() / movie.getRate());
    }

    private int validateFrameNumber(int n) throws QTException {
        int n2 = this.mapTimeToFrame(this.getMovieDuration() * 1000000L);
        if (n > n2) {
            n = n2;
        } else if (n < 0) {
            n = 0;
        }
        return n;
    }

    public int seek(int n) throws MediaException {
        try {
            n = this.validateFrameNumber(n);
            this.setMediaTime(this.mapFrameToTime(n));
            return n;
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public void setFullScreen(boolean bl) {
        this.fullScreen = bl;
        if (this.fullScreenBounds == null) {
            this.setFullScreenBounds();
        }
    }

    public boolean isFullScreen() {
        return this.fullScreen;
    }

    public Rectangle getMovieBounds() {
        if (this.fullScreen) {
            return this.fullScreenBounds;
        }
        return this.movieBounds;
    }

    private void setFullScreenBounds() {
        int n;
        int n2;
        int n3;
        int n4;
        QDRect qDRect = this.getVideoRect();
        Rectangle rectangle = this.screen.getDisplayBoundsInFace();
        int n5 = rectangle.height - qDRect.getHeight();
        int n6 = rectangle.width - qDRect.getWidth();
        if (n6 > n5) {
            n4 = rectangle.height;
            n3 = qDRect.getWidth() * rectangle.height / qDRect.getHeight();
            n2 = (rectangle.width - n3) / 2;
            n = 0;
        } else {
            n3 = rectangle.width;
            n4 = qDRect.getHeight() * rectangle.width / qDRect.getWidth();
            n2 = 0;
            n = (rectangle.height - n4) / 2;
        }
        this.fullScreenBounds = new Rectangle();
        this.fullScreenBounds.setLocation(n2, n);
        this.fullScreenBounds.setSize(n3, n4);
    }

    private QDRect getVideoRect() {
        try {
            return this.getMoviePlayer().getDisplayBounds();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            return null;
        }
    }

    private void setVideoRect(QDRect qDRect) {
        try {
            this.getMoviePlayer().setDisplayBounds(qDRect);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
        }
    }

    public void setWidth(int n) {
        if (!this.fullScreen) {
            this.movieBounds.setSize(n, this.movieBounds.height);
        }
    }

    public void setHeight(int n) {
        if (!this.fullScreen) {
            this.movieBounds.setSize(this.movieBounds.width, n);
        }
    }

    public void setXLocation(int n) {
        if (!this.fullScreen) {
            this.movieBounds.setLocation(n, this.movieBounds.y);
        }
    }

    public void setYLocation(int n) {
        if (!this.fullScreen) {
            this.movieBounds.setLocation(this.movieBounds.x, n);
        }
    }
}

