/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.mma;

import com.sun.mmedia.MediaException;
import com.sun.mmedia.Player;
import org.apache.log4j.Logger;
import quicktime.QTException;
import quicktime.QTSession;
import quicktime.app.time.TaskAllMovies;
import quicktime.app.view.MoviePlayer;
import quicktime.std.clocks.TimeRecord;
import quicktime.std.movies.Movie;
import quicktime.std.movies.media.DataRef;
import quicktime.util.QTHandle;
import quicktime.util.QTHandleRef;

public class QTPlayer
implements Player {
    private static final Logger LOGGER = Logger.getLogger(QTPlayer.class);
    private Movie movie;
    private MoviePlayer pl;
    private boolean isStopped = true;
    private long mediaTime = 0L;
    private long qtRate = 100000L;
    private long volume;
    private int timeScale;

    public void init(byte[] byArray, String string) throws MediaException {
        DataRef dataRef;
        this.initQT();
        try {
            dataRef = new DataRef((QTHandleRef)new QTHandle(byArray), 1835625829, string);
        }
        catch (QTException qTException) {
            QTSession.close();
            throw new MediaException((Throwable)qTException);
        }
        this.init(dataRef);
    }

    public void init(String string, String string2) throws MediaException {
        DataRef dataRef;
        LOGGER.debug((Object)("QTPlayer.init() URL " + string));
        this.initQT();
        try {
            dataRef = new DataRef(string);
        }
        catch (QTException qTException) {
            QTSession.close();
            throw new MediaException((Throwable)qTException);
        }
        this.init(dataRef);
    }

    private void init(DataRef dataRef) throws MediaException {
        try {
            LOGGER.debug((Object)"QTPlayer.init() DataRef");
            this.movie = Movie.fromDataRef((DataRef)dataRef, (int)257);
            this.movie.prePreroll(0, 1.0f);
            this.movie.preroll(0, 1.0f);
            TaskAllMovies.addMovieAndStart();
            this.pl = new MoviePlayer(this.movie);
            this.volume = (long)(this.pl.getVolume() * 100.0f);
            this.timeScale = this.movie.getTimeScale();
            LOGGER.debug((Object)"QTPlayer.init() done.");
        }
        catch (QTException qTException) {
            QTSession.close();
            throw new MediaException((Throwable)qTException);
        }
    }

    private void initQT() throws MediaException {
        if (!QTSession.isInitialized()) {
            try {
                QTSession.open();
            }
            catch (QTException qTException) {
                QTSession.close();
                throw new MediaException((Throwable)qTException);
            }
        }
    }

    public void start() throws MediaException {
        try {
            this.movie.start();
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            throw new MediaException((Throwable)qTException);
        }
        this.isStopped = false;
    }

    public void resume() throws MediaException {
        this.setMediaTime(this.mediaTime);
        try {
            this.movie.setRate(1.0f);
        }
        catch (QTException qTException) {
            qTException.printStackTrace();
            throw new MediaException((Throwable)qTException);
        }
        this.isStopped = false;
    }

    public void stop() throws MediaException {
        if (!this.isStopped) {
            this.mediaTime = this.getMediaTime();
            try {
                this.movie.setRate(0.0f);
            }
            catch (QTException qTException) {
                throw new MediaException((Throwable)qTException);
            }
            this.isStopped = true;
        }
    }

    public void close() throws MediaException {
        this.stop();
        TaskAllMovies.removeMovie();
        try {
            this.movie.setActive(false);
        }
        catch (QTException qTException) {
            // empty catch block
        }
        this.movie = null;
        this.pl = null;
    }

    public void setMediaTime(long l) throws MediaException {
        if (this.isStopped && this.mediaTime == l) {
            return;
        }
        this.mediaTime = l;
        try {
            int n = (int)((float)this.mediaTime / 1000000.0f * (float)this.timeScale * this.getMovieRate());
            this.movie.setTime(new TimeRecord(this.timeScale, (long)n));
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public long getMediaTime() throws MediaException {
        long l;
        if (this.isStopped) {
            l = this.mediaTime;
        } else {
            try {
                l = (long)((float)this.movie.getTime() / (float)this.timeScale / this.getMovieRate() * 1000000.0f);
            }
            catch (QTException qTException) {
                throw new MediaException((Throwable)qTException);
            }
        }
        return l;
    }

    public long getDuration() throws MediaException {
        long l = -1L;
        try {
            l = this.movie.getDuration();
            LOGGER.debug((Object)("QTPlayer: media duration = " + l));
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
        l = l == 0L ? -1L : (long)((float)(l * 1000L / (long)this.timeScale) / this.getMovieRate());
        return l;
    }

    private float getMovieRate() throws MediaException {
        try {
            return this.movie.getRate() == 0.0f ? 1.0f : this.movie.getRate();
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public void setRate(long l) throws MediaException {
        try {
            this.qtRate = l;
            this.pl.setRate((float)this.qtRate / 100000.0f);
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public long getRate() throws MediaException {
        return this.qtRate;
    }

    public void setVolume(long l) throws MediaException {
        try {
            this.volume = l;
            this.pl.setVolume((float)this.volume / 100.0f);
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public long getVolume() throws MediaException {
        return this.volume;
    }

    public boolean isMuted() throws MediaException {
        try {
            return this.pl.isMuted();
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public void setMuted(boolean bl) throws MediaException {
        try {
            this.pl.setMuted(bl);
        }
        catch (QTException qTException) {
            throw new MediaException((Throwable)qTException);
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    protected MoviePlayer getMoviePlayer() {
        return this.pl;
    }

    protected Movie getMovie() {
        return this.movie;
    }
}

