/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.deviceRegistry.client;

import com.sun.jme.toolkit.deviceRegistry.api.DeviceManager;
import com.sun.jme.toolkit.deviceRegistry.api.RegistrationData;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

public class DeviceRegistryClientService2
extends AtomicInteger {
    private static final Logger LOGGER = Logger.getLogger(DeviceRegistryClientService2.class);
    private ObjectServerConnection deviceManagerConnection;
    private String deviceName;
    private transient DeviceManager deviceManager;

    public void setDeviceManagerConnection(ObjectServerConnection objectServerConnection) {
        this.deviceManagerConnection = objectServerConnection;
    }

    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    public void start() throws Exception {
        if (this.deviceManagerConnection == null) {
            throw new IllegalStateException("deviceManagerConnection is not configured, cannot start");
        }
        this.deviceManager = (DeviceManager)this.deviceManagerConnection.findObject(DeviceManager.class, "DeviceManager");
        this.set(this.deviceManager.allocateDeviceId(new RegistrationData(this.deviceName, null)));
        LOGGER.debug((Object)("Obtained device ID " + this.get()));
    }

    public void stop() throws Exception {
        if (this.deviceManager == null) {
            return;
        }
        this.deviceManager.releaseDeviceId(this.get());
        LOGGER.debug((Object)("Released device ID " + this.get()));
        this.deviceManager = null;
    }
}

