/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kdp.KVMDebugProxy;
import org.apache.log4j.Logger;

public class KDP
implements Runnable {
    private static final Logger logger = Logger.getLogger(KDP.class);
    private Thread kdpThread;
    KVMDebugProxy proxy;
    private int jdwpPort;
    private String kvmHost;
    private int kdwpPort;
    private String cp;
    private File tmpDir;
    private Map<Integer, String> apps;
    private int currId;

    public void setJdwpPort(int n) {
        this.jdwpPort = n;
    }

    public void setKdwpPort(int n) {
        this.kdwpPort = n;
    }

    public void setKvmHost(String string) {
        this.kvmHost = string;
    }

    public void setKVMClasspath(String string) {
        this.cp = string;
    }

    public void setWorkdir(String string) {
        this.tmpDir = new File(string, "kdp");
    }

    private void clearTmpDir() {
        if (this.tmpDir != null && this.tmpDir.exists()) {
            FilenameFilter filenameFilter = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith(".jar");
                }
            };
            for (File file : this.tmpDir.listFiles(filenameFilter)) {
                file.delete();
            }
        }
    }

    private int getDefaultVerbosity() {
        if (logger.isTraceEnabled()) {
            return 9;
        }
        if (logger.isDebugEnabled()) {
            return 6;
        }
        if (logger.isInfoEnabled()) {
            return 3;
        }
        return 0;
    }

    public void start() {
        this.apps = new HashMap<Integer, String>();
        if (this.tmpDir.exists()) {
            this.clearTmpDir();
        } else {
            this.tmpDir.mkdir();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("-l");
        arrayList.add(String.valueOf(this.jdwpPort));
        arrayList.add("-m");
        arrayList.add("-p");
        arrayList.add("-r");
        arrayList.add(this.kvmHost);
        arrayList.add(String.valueOf(this.kdwpPort));
        arrayList.add("-cp");
        arrayList.add(this.cp);
        arrayList.add("-v");
        arrayList.add(System.getProperty("debug.kdp", Integer.toString(this.getDefaultVerbosity())));
        this.proxy = new KVMDebugProxy();
        if (!this.proxy.parseArgs(arrayList.toArray(new String[0]))) {
            logger.debug((Object)"KDP couldn't parse arguments");
            System.err.println("Couldn't run the debugging proxy");
            return;
        }
        if (this.kdpThread != null) {
            logger.warn((Object)"KDP already running.");
        }
        this.kdpThread = new Thread((Runnable)this, "KDP thread");
        this.kdpThread.start();
    }

    public void stop() {
        this.proxy.stop();
        this.clearTmpDir();
        this.tmpDir.delete();
    }

    public int addApplication(String string) {
        Object object;
        Closeable closeable;
        Object object2;
        Object object3;
        Object object4;
        String string2 = string;
        if (string.endsWith(".jad")) {
            logger.debug((Object)("Reading " + string));
            try {
                object4 = new URL(string);
                object3 = ((URL)object4).openStream();
                object2 = new InputStreamReader((InputStream)object3);
                closeable = new BufferedReader((Reader)object2);
                while ((object = ((BufferedReader)closeable).readLine()) != null) {
                    if (!((String)object).startsWith("MIDlet-Jar-URL: ")) continue;
                    string2 = ((String)object).substring("MIDlet-Jar-URL: ".length());
                    break;
                }
                ((BufferedReader)closeable).close();
                ((InputStreamReader)object2).close();
                ((InputStream)object3).close();
                if (!string2.contains("://")) {
                    string2 = string.substring(0, string.lastIndexOf("/") + 1) + string2;
                }
            }
            catch (IOException iOException) {
                logger.error((Object)("Exception when reading jad file: " + iOException.getMessage()));
                return -1;
            }
        }
        if (((File)(object3 = new File(this.tmpDir, (String)(object4 = string2.substring(string2.lastIndexOf("/") + 1))))).exists()) {
            object2 = ((String)object4).substring(0, ((String)object4).length() - ".jar".length());
            int n = 1;
            while (((File)object3).exists()) {
                object3 = new File(this.tmpDir, (String)object2 + "_" + n++ + ".jar");
            }
        }
        object2 = ((File)object3).getAbsolutePath();
        try {
            logger.debug((Object)("Saving " + string2 + " to " + (String)object2));
            closeable = new FileOutputStream((File)object3);
            object = new URL(string2);
            InputStream inputStream = ((URL)object).openStream();
            byte[] byArray = new byte[1024];
            int n = inputStream.read(byArray, 0, 1024);
            while (n > -1) {
                ((FileOutputStream)closeable).write(byArray, 0, n);
                n = inputStream.read(byArray, 0, 1024);
            }
            inputStream.close();
            ((FileOutputStream)closeable).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.error((Object)("Cannot create file " + (String)object2 + ": " + fileNotFoundException.getMessage()));
            return -1;
        }
        catch (IOException iOException) {
            logger.error((Object)("Cannot fill file " + (String)object2 + ": " + iOException.getMessage()));
            return -1;
        }
        logger.debug((Object)("Adding to KDP classpath: " + (String)object2));
        this.addPath((String)object2);
        int n = ++this.currId;
        this.apps.put(n, (String)object2);
        return n;
    }

    public void removeApplication(int n) {
        String string = this.apps.get(n);
        if (string == null) {
            logger.debug((Object)("Removing not existing application " + n));
            return;
        }
        this.apps.remove(n);
        this.removePath(string);
        File file = new File(string);
        if (file.exists() && !file.delete()) {
            logger.warn((Object)("Could not delete " + string));
        }
    }

    @Override
    public void run() {
        this.proxy.go();
    }

    public void addPath(String string) {
        this.proxy.addPath(string);
    }

    public void removePath(String string) {
        this.proxy.removePath(string);
    }
}

