/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import kdp.DebuggerListener;
import kdp.KVMListener;
import kdp.Log;
import kdp.Options;
import kdp.ProxyListener;
import kdp.classparser.ClassManager;
import kdp.classparser.SearchPath;

public class KVMDebugProxy {
    Options options = null;
    SearchPath path = null;
    DebuggerListener dlisten = null;
    KVMListener klisten = null;
    private ServerSocket serverSocket = null;
    private boolean kvmListenerExited = false;
    private boolean debuggerListenerExited = false;
    private Thread myThread;

    public boolean parseArgs(String[] stringArray) {
        int n = 0;
        this.options = new Options();
        this.options.setLocalPort(2801);
        this.options.setRemotePort(2800);
        this.options.setRemoteHost("localhost");
        this.options.setVerbosity(0);
        this.options.setClassPath("./");
        this.options.setProxyMode(false);
        if (stringArray.length == 0) {
            this.options = null;
        }
        try {
            while (n < stringArray.length) {
                if ("-l".equals(stringArray[n])) {
                    this.options.setLocalPort(Integer.parseInt(stringArray[++n]));
                } else if ("-r".equals(stringArray[n])) {
                    this.options.setRemoteHost(stringArray[++n]);
                    this.options.setRemotePort(Integer.parseInt(stringArray[++n]));
                } else if ("-v".equals(stringArray[n])) {
                    this.options.setVerbosity(Integer.parseInt(stringArray[++n]));
                } else if ("-cp".equals(stringArray[n]) || "-classpath".equals(stringArray[n])) {
                    this.options.setClassPath(stringArray[++n]);
                } else if ("-p".equals(stringArray[n])) {
                    this.options.setProxyMode(true);
                } else if ("-m".equals(stringArray[n])) {
                    this.options.setUseMVM(true);
                } else if ("-nb4".equals(stringArray[n])) {
                    this.options.setNetbeans40compat(true);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            this.options = null;
        }
        this.path = new SearchPath(this.options == null ? "" : this.options.getClassPath());
        return this.options != null;
    }

    public void help() {
        System.out.println("Java ME Debug Agent.");
        System.out.println();
        System.out.println("Usage: KVMDebugProxy -l <localport> -r <remotehost> <remoteport> [-p]");
        System.out.println("        [-v <level>] [-cp | - classpath <classpath" + File.pathSeparator + "classpath...>]");
        System.out.println("Where:");
        System.out.println("  -l <localport> specifies the local port number that the debug agent will");
        System.out.println("     listen on for a connection from a debugger.");
        System.out.println("  -r <remotehost> <remoteport> is the hostname and port number that the debug");
        System.out.println("     agent will use to connect to the Java VM running the application");
        System.out.println("     being debugged");
        System.out.println("  -p enables proxy mode, the debug agent processes classfiles on behalf of the Java VM ");
        System.out.println("     running the application being debugged.  If not present, all commands");
        System.out.println("     from the debugger are passed down to the Java VM running the application");
        System.out.println("  -v <level> turns on verbose mode.  'level' specifies the amount of output,");
        System.out.println("     the larger the number the more output that is generated.");
        System.out.println("     'level' can be from 1-9.");
        System.out.println("  -m Enable support for Multitasking VM.");
        System.out.println("  -nb4 Enable use of Netbeans 4.x with older VMs (version < CLDC_VM 1.1.3)");
        System.out.println("  -cp or -classpath specifies a list of paths separated by " + File.pathSeparator + " where the");
        System.out.println("     debug agent can find copies of the class files.  Only needed if -p is set.");
        System.out.println();
    }

    public void addPath(String string) {
        this.path.addPath(string);
    }

    public void removePath(String string) {
        this.path.removePath(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        this.serverSocket = null;
        this.myThread = Thread.currentThread();
        if (this.options == null) {
            return;
        }
        Log.LOGN(1, "Starting KVM Debug proxy:");
        Log.LOGN(1, "  Local port listening for debugger: " + this.options.getLocalPort());
        Log.LOGN(1, "  VM host: " + this.options.getRemoteHost());
        Log.LOGN(1, "  VM debugging port: " + this.options.getRemotePort());
        Log.LOGN(4, "  Multi-VM support: " + this.options.getUseMVM());
        Log.LOGN(4, "  Netbeans 4 compatible: " + this.options.getNetbeans40compat());
        do {
            this.kvmListenerExited = false;
            this.debuggerListenerExited = false;
            ClassManager classManager = new ClassManager(this.path);
            try {
                this.serverSocket = new ServerSocket(this.options.getLocalPort());
                Log.LOGN(3, "KVMDebugProxy: opened server socket " + this.serverSocket);
            }
            catch (IOException iOException) {
                System.out.println("Caught exception " + iOException + " while creating listener socket");
                return;
            }
            try {
                this.dlisten = new DebuggerListener(this.serverSocket, this.options);
                this.klisten = new KVMListener(this.options);
                this.dlisten.set(this.klisten, classManager, this);
                this.klisten.set(this.dlisten, classManager, this);
                new Thread((Runnable)this.klisten, "KDP VM Listener Thread").start();
                boolean bl = true;
                try {
                    this.dlisten.connectToDebugger();
                }
                catch (IOException iOException) {
                    bl = false;
                }
                if (bl) {
                    new Thread(this.dlisten).start();
                }
                Thread thread = this.myThread;
                synchronized (thread) {
                    while (!this.kvmListenerExited || !this.debuggerListenerExited) {
                        try {
                            this.myThread.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            catch (SecurityException securityException) {
                System.out.println("KVMDebugProxy: " + securityException.getMessage());
            }
        } while (this.options.getUseMVM());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyProxyListenerStopped(ProxyListener proxyListener) {
        Thread thread = this.myThread;
        synchronized (thread) {
            if (proxyListener == this.klisten) {
                this.kvmListenerExited = true;
            }
            if (proxyListener == this.dlisten) {
                this.debuggerListenerExited = true;
            }
            if (this.kvmListenerExited && this.debuggerListenerExited) {
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.myThread.notifyAll();
            }
        }
    }

    public void stop() {
        this.options.setUseMVM(false);
        if (this.dlisten != null) {
            this.dlisten.setStop();
        }
        if (this.klisten != null) {
            this.klisten.setStop();
        }
    }

    public static void main(String[] stringArray) {
        KVMDebugProxy kVMDebugProxy = new KVMDebugProxy();
        if (!kVMDebugProxy.parseArgs(stringArray)) {
            kVMDebugProxy.help();
            System.exit(1);
        }
        kVMDebugProxy.go();
    }
}

