/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import kdp.VMConstants;

public class Packet
implements VMConstants {
    public static final byte NoFlags = 0;
    public static final byte Reply = -128;
    public static final byte ReplyNoError = 0;
    static int uID = -2147483647;
    static final byte[] nullData = new byte[0];
    int id = Packet.uniqID();
    byte flags = 0;
    byte cmdSet;
    byte cmd;
    short errorCode;
    byte[] data = null;
    volatile boolean replied = false;
    int curReadIndex = 0;
    int curWriteIndex = 0;

    Packet() {
    }

    private static synchronized int uniqID() {
        return uID++;
    }

    public int getLength() {
        return this.curWriteIndex;
    }

    public String toString(int n) {
        String[][] stringArray;
        int n2 = this.cmdSet;
        int n3 = this.cmd;
        if (this.cmdSet < 64) {
            stringArray = VMcmds;
        } else if (this.cmdSet < 128) {
            stringArray = DBGcmds;
            n2 -= 64;
            n3 -= 99;
        } else {
            stringArray = VENcmds;
            n3 = 0;
            n2 = 0;
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (this.isReply()) {
                stringBuffer.append("Sending through: errCode ");
                stringBuffer.append(this.errorCode);
            } else {
                stringBuffer.append("Sending through: ");
                stringBuffer.append(stringArray[n2][0]);
                stringBuffer.append("(");
                stringBuffer.append(this.cmdSet);
                stringBuffer.append(")/");
                stringBuffer.append(stringArray[n2][n3]);
                stringBuffer.append("(");
                stringBuffer.append(this.cmd);
                stringBuffer.append(")");
            }
            stringBuffer.append("\n");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("UNKNOWN COMMAND: " + this.cmdSet + "/" + this.cmd);
        }
        if (n >= 5 && !this.isReply()) {
            stringBuffer.append(this.cmdSet);
            stringBuffer.append("/");
            stringBuffer.append(this.cmd);
            stringBuffer.append("/");
            stringBuffer.append(this.errorCode);
            stringBuffer.append("/");
            stringBuffer.append(this.id);
        }
        if (n >= 8) {
            stringBuffer.append("\n--->\n");
            for (int i = 0; i < this.data.length; ++i) {
                stringBuffer.append(Integer.toHexString((int)((long)this.data[i] & 0xFFL))).append(".");
            }
            stringBuffer.append("\n<----");
        }
        if (this.cmdSet == 15 && this.cmd == 1) {
            stringBuffer.append("\nEventKind == ").append(this.data[0]).append("\n");
        } else if (this.cmdSet == 64 && this.cmd == 100) {
            stringBuffer.append("\nEventKind == ").append(this.data[5]).append("\n");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString(0);
    }

    public boolean isReply() {
        return (this.flags & 0xFFFFFF80) != 0;
    }
}

