/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import kdp.Packet;
import kdp.PacketStreamException;
import kdp.ProxyConnectionException;
import kdp.ProxyListener;

class PacketStream {
    final ProxyListener proxy;
    private int outCursor = 0;
    final Packet pkt;
    private ByteArrayOutputStream dataStream = new ByteArrayOutputStream();
    private boolean isCommitted = false;
    private int id;
    byte[] data;

    PacketStream(ProxyListener proxyListener, byte by, byte by2) {
        this.proxy = proxyListener;
        this.pkt = new Packet();
        this.id = this.pkt.id;
        this.pkt.cmdSet = by;
        this.pkt.cmd = by2;
    }

    PacketStream(ProxyListener proxyListener, int n, byte by, short s) {
        this.pkt = new Packet();
        this.proxy = proxyListener;
        this.pkt.id = n;
        this.id = n;
        this.pkt.errorCode = s;
        this.pkt.flags = by;
    }

    PacketStream(ProxyListener proxyListener, Packet packet) {
        this.pkt = packet;
        this.proxy = proxyListener;
        this.id = packet.id;
        this.data = packet.data;
    }

    int id() {
        return this.id;
    }

    void send() throws ProxyConnectionException {
        if (!this.isCommitted) {
            this.pkt.data = this.dataStream.toByteArray();
            this.proxy.send(this.pkt);
            this.isCommitted = true;
        }
    }

    void waitForReply() throws PacketStreamException {
        if (!this.isCommitted) {
            throw new ProxyConnectionException("waitForReply without send");
        }
        this.proxy.waitForReply(this.pkt);
        if (this.pkt.errorCode != 0) {
            throw new PacketStreamException(String.valueOf(this.pkt.errorCode));
        }
        this.data = this.pkt.data;
    }

    void writeBoolean(boolean bl) {
        if (bl) {
            this.dataStream.write(1);
        } else {
            this.dataStream.write(0);
        }
    }

    void writeByte(byte by) {
        this.dataStream.write(by);
    }

    void writeChar(char c) {
        this.dataStream.write((byte)(c >>> 8 & 0xFF));
        this.dataStream.write((byte)(c >>> 0 & 0xFF));
    }

    void writeShort(short s) {
        this.dataStream.write((byte)(s >>> 8 & 0xFF));
        this.dataStream.write((byte)(s >>> 0 & 0xFF));
    }

    void writeInt(int n) {
        this.dataStream.write((byte)(n >>> 24 & 0xFF));
        this.dataStream.write((byte)(n >>> 16 & 0xFF));
        this.dataStream.write((byte)(n >>> 8 & 0xFF));
        this.dataStream.write((byte)(n >>> 0 & 0xFF));
    }

    void writeLong(long l) {
        this.dataStream.write((byte)(l >>> 56 & 0xFFL));
        this.dataStream.write((byte)(l >>> 48 & 0xFFL));
        this.dataStream.write((byte)(l >>> 40 & 0xFFL));
        this.dataStream.write((byte)(l >>> 32 & 0xFFL));
        this.dataStream.write((byte)(l >>> 24 & 0xFFL));
        this.dataStream.write((byte)(l >>> 16 & 0xFFL));
        this.dataStream.write((byte)(l >>> 8 & 0xFFL));
        this.dataStream.write((byte)(l >>> 0 & 0xFFL));
    }

    void writeFloat(float f) {
        this.writeInt(Float.floatToIntBits(f));
    }

    void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    void writeID(int n, long l) {
        if (n == 8) {
            this.writeLong(l);
        } else {
            this.writeInt((int)l);
        }
    }

    void writeByteArray(byte[] byArray) {
        this.dataStream.write(byArray, 0, byArray.length);
    }

    void writeString(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.writeInt(byArray.length);
            this.writeByteArray(byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Cannot convert string to UTF8 bytes");
        }
    }

    byte readByte() throws PacketStreamException {
        this.checkCursor(1);
        return this.data[this.outCursor++];
    }

    boolean readBoolean() throws PacketStreamException {
        byte by = this.readByte();
        return by != 0;
    }

    char readChar() throws PacketStreamException {
        this.checkCursor(2);
        int n = this.data[this.outCursor++] & 0xFF;
        int n2 = this.data[this.outCursor++] & 0xFF;
        return (char)((n << 8) + n2);
    }

    short readShort() throws PacketStreamException {
        return (short)this.readChar();
    }

    int readInt() throws PacketStreamException {
        this.checkCursor(4);
        return ((this.data[this.outCursor++] & 0xFF) << 24) + ((this.data[this.outCursor++] & 0xFF) << 16) + ((this.data[this.outCursor++] & 0xFF) << 8) + (this.data[this.outCursor++] & 0xFF);
    }

    long readLong() throws PacketStreamException {
        return ((long)this.readInt() << 32) + (long)this.readInt();
    }

    double readDouble() throws PacketStreamException {
        return Double.longBitsToDouble(this.readLong());
    }

    String readString() throws PacketStreamException {
        String string;
        int n = this.readInt();
        this.checkCursor(n);
        try {
            string = new String(this.data, this.outCursor, n, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new PacketStreamException();
        }
        this.outCursor += n;
        return string;
    }

    private long readID(int n) throws PacketStreamException {
        if (n == 8) {
            return this.readLong();
        }
        return this.readInt();
    }

    int skipBytes(int n) throws PacketStreamException {
        this.checkCursor(n);
        this.outCursor += n;
        return n;
    }

    byte cmd() {
        return this.pkt.cmd;
    }

    void checkCursor(int n) throws PacketStreamException {
        if (this.outCursor + n > this.data.length) {
            throw new PacketStreamException("Reading past buffer");
        }
    }
}

