/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kdp.Log;
import kdp.Options;
import kdp.Packet;
import kdp.PacketStream;
import kdp.PacketStreamException;
import kdp.ProxyConnectionException;

abstract class ProxyListener
extends Thread {
    protected Options options;
    final int METHOD_BASE_SHIFT = 15;
    final int METHOD_BASE_BITS = 98304;
    final int METHOD_BASE_ONE_FLAG = 2;
    final int KVM_VERSION_3_SHIFT = 17;
    final int KVM_VERSION_3_BITS = 393216;
    final int KVM_VERSION_3_FLAG = 2;
    final int MAJOR_VERSION = 1;
    final int MINOR_VERSION = 4;
    Map waitingQueue = new HashMap(8, 0.75f);
    protected List packetQueue = Collections.synchronizedList(new LinkedList());

    public ProxyListener(Options options) {
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newPacket(Packet packet) {
        if (packet == null) {
            List list = this.packetQueue;
            synchronized (list) {
                this.packetQueue.notify();
            }
            return;
        }
        List list = this.packetQueue;
        synchronized (list) {
            this.packetQueue.add(packet);
            this.packetQueue.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Packet waitForPacket() {
        List list = this.packetQueue;
        synchronized (list) {
            while (this.packetQueue.size() == 0) {
                try {
                    this.packetQueue.wait();
                }
                catch (InterruptedException interruptedException) {
                    Log.LOGN(3, this + " waitForPacket Interrupted");
                    throw new ProxyConnectionException();
                }
            }
        }
        return (Packet)this.packetQueue.remove(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replyReceived(Packet packet) {
        Packet packet2;
        if (packet == null) {
            Map map = this.waitingQueue;
            synchronized (map) {
                Iterator iterator = this.waitingQueue.values().iterator();
                while (iterator.hasNext()) {
                    Packet packet3;
                    Packet packet4 = packet3 = (Packet)iterator.next();
                    synchronized (packet4) {
                        packet3.notify();
                    }
                }
            }
            return;
        }
        String string = String.valueOf(packet.id);
        Object object = this.waitingQueue;
        synchronized (object) {
            packet2 = (Packet)this.waitingQueue.get(string);
            if (packet2 != null) {
                this.waitingQueue.remove(string);
            }
        }
        if (packet2 == null) {
            System.err.println("Received reply with no sender!");
            return;
        }
        packet2.errorCode = packet.errorCode;
        packet2.data = packet.data;
        packet2.replied = true;
        object = packet2;
        synchronized (object) {
            packet2.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForReply(Packet packet) {
        Packet packet2 = packet;
        synchronized (packet2) {
            while (!packet.replied) {
                try {
                    packet.wait();
                }
                catch (InterruptedException interruptedException) {
                    System.out.println(this + " waitForReply Interrupted");
                    throw new ProxyConnectionException();
                }
            }
            if (!packet.replied) {
                throw new RuntimeException();
            }
        }
    }

    public abstract void send(Packet var1) throws ProxyConnectionException;

    public abstract void setStop();

    class MethodID {
        long _method_id_long;
        int _method_id_int;
        boolean VM_Version_3;

        public MethodID() {
            this.VM_Version_3 = ProxyListener.this.options.isVM_Version_3();
        }

        public MethodID(int n, int n2) {
            this.VM_Version_3 = ProxyListener.this.options.isVM_Version_3();
            if (this.VM_Version_3) {
                this._method_id_long = ((long)n << 32) + (long)n2;
            } else {
                this._method_id_int = n2;
            }
        }

        protected int readMethodPart(PacketStream packetStream) throws PacketStreamException {
            if (this.VM_Version_3) {
                this._method_id_long = packetStream.readLong();
                return this.methodPart(this._method_id_long);
            }
            this._method_id_int = packetStream.readInt();
            return this._method_id_int;
        }

        protected int methodPart(long l) {
            return (int)(l & 0xFFFFFFFFFFFFFFFFL);
        }

        protected void setMethodPart(int n) {
            this._method_id_int = n;
            if (this.VM_Version_3) {
                this._method_id_long = this._method_id_long & 0xFFFFFFFF00000000L | (long)n;
            }
        }

        protected void writeMethodID(PacketStream packetStream) throws PacketStreamException {
            if (this.VM_Version_3) {
                packetStream.writeLong(this._method_id_long);
            } else {
                packetStream.writeInt(this._method_id_int);
            }
        }

        public String toString() {
            if (this.VM_Version_3) {
                return Long.toHexString(this._method_id_long);
            }
            return Integer.toHexString(this._method_id_int);
        }
    }
}

