/*
 * Decompiled with CFR 0.152.
 */
package kdp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import kdp.Log;
import kdp.Packet;
import kdp.ProxyListener;

class SocketConnection
implements Runnable {
    Socket socket;
    DataOutputStream out;
    DataInputStream in;
    ProxyListener proxy;

    SocketConnection(ProxyListener proxyListener, Socket socket) throws IOException {
        this.proxy = proxyListener;
        this.socket = socket;
        socket.setTcpNoDelay(true);
        this.in = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(socket.getOutputStream()));
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
            this.in.close();
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte receiveByte() throws IOException {
        int n = this.in.read();
        return (byte)n;
    }

    public void sendByte(byte by) throws IOException {
        this.out.write(by);
        this.out.flush();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Packet packet = this.receivePacket();
                if ((packet.flags & 0xFFFFFF80) == 0 || packet.id >= 0) {
                    this.proxy.newPacket(packet);
                    continue;
                }
                this.proxy.replyReceived(packet);
            }
        }
        catch (Exception exception) {
            Log.LOGN(4, "Socket exception in " + this.proxy + exception + " ...exiting");
            this.proxy.setStop();
            return;
        }
    }

    public Packet receivePacket() throws IOException {
        int n;
        Packet packet = new Packet();
        int n2 = this.in.readInt();
        packet.id = this.in.readInt();
        packet.flags = this.in.readByte();
        if ((packet.flags & 0xFFFFFF80) == 0) {
            packet.cmdSet = this.in.readByte();
            packet.cmd = this.in.readByte();
        } else {
            packet.errorCode = this.in.readShort();
        }
        if ((n2 -= 11) < 0) {
            throw new IOException("packet length < 0");
        }
        packet.data = new byte[n2];
        for (int i = 0; i < packet.data.length; i += n) {
            n = this.in.read(packet.data, i, packet.data.length - i);
            if (n >= 0) continue;
            throw new EOFException();
        }
        return packet;
    }

    public void send(Packet packet) throws IOException {
        int n = packet.data.length + 11;
        this.out.writeInt(n);
        this.out.writeInt(packet.id);
        this.out.write(packet.flags);
        if ((packet.flags & 0xFFFFFF80) == 0) {
            this.out.write(packet.cmdSet);
            this.out.write(packet.cmd);
        } else {
            this.out.writeShort(packet.errorCode);
        }
        this.out.write(packet.data);
        this.out.flush();
    }
}

