/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kdp.Log;
import kdp.classparser.ClassFile;
import kdp.classparser.FileReference;
import kdp.classparser.SearchPath;

public class ClassManager {
    SearchPath path = null;
    public Map classMap = new HashMap(128, 0.75f);

    public ClassManager() {
    }

    public ClassManager(SearchPath searchPath) {
        this();
        this.path = searchPath;
    }

    private ClassFile loadClass(String string, FileReference fileReference, byte by) {
        Log.LOGN(3, "loadclass: " + fileReference);
        ClassFile classFile = new ClassFile(fileReference, string, by);
        try {
            classFile.readClassFile();
        }
        catch (Exception exception) {
            Log.LOGN(2, "Error loading: " + fileReference);
            classFile = null;
        }
        return classFile;
    }

    public ClassFile findClass(byte by, String string) {
        ClassFile classFile2 = null;
        Collection collection = this.classMap.values();
        for (ClassFile classFile2 : collection) {
            if (!classFile2.equals(string)) continue;
            return classFile2;
        }
        return null;
    }

    public ClassFile findClass(int n, String string, byte by, int n2) {
        ClassFile classFile = null;
        classFile = (ClassFile)this.classMap.get(new Integer(n));
        if (classFile != null) {
            classFile.setClassStatus(n2);
            return classFile;
        }
        if (by == 3) {
            Log.LOGN(4, "findclass: Array class " + string);
            classFile = new ClassFile(null, string, by);
            this.classMap.put(new Integer(n), classFile);
            classFile.setClassID(n);
            classFile.setClassStatus(n2);
            return classFile;
        }
        if (this.path != null) {
            Log.LOGN(4, "findclass: finding " + string);
            FileReference fileReference = this.path.resolve(string);
            if (fileReference != null && (classFile = this.loadClass(string, fileReference, by)) != null) {
                this.classMap.put(new Integer(n), classFile);
                classFile.setClassID(n);
                classFile.setClassStatus(n2);
                return classFile;
            }
        }
        return null;
    }
}

