/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import kdp.Log;
import kdp.classparser.FileReference;

public class SearchPath {
    private String pathString = "";
    private List<String> pathList = new ArrayList<String>();

    private synchronized void extendSearchPath(String string) {
        if (string == null) {
            return;
        }
        if (this.pathString.length() > 0) {
            this.pathString = File.pathSeparator + this.pathString;
        }
        this.pathString = string + this.pathString;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            this.pathList.add(n++, string2);
            Log.LOGN(3, "Adding to searchPath: " + string2);
        }
    }

    public SearchPath(String string) {
        this.extendSearchPath(string);
    }

    public boolean isEmpty() {
        return this.pathList.isEmpty();
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return this.pathList.toArray(new String[0]);
    }

    public int path_array_length() {
        return this.pathList.size();
    }

    public void addPath(String string) {
        this.extendSearchPath(string);
    }

    public void removePath(String string) {
        CharSequence charSequence;
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            while (this.pathList.remove(charSequence)) {
            }
            Log.LOGN(3, "Removing from searchPath: " + (String)charSequence);
        }
        charSequence = new StringBuilder();
        for (String string2 : this.pathList) {
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(File.pathSeparator);
        }
        int n = ((StringBuilder)charSequence).length();
        ((StringBuilder)charSequence).delete(n - 1, n);
        this.pathString = ((StringBuilder)charSequence).toString();
    }

    public synchronized FileReference resolve(String string) {
        Log.LOGN(4, "relative filename = " + string);
        Log.LOGN(4, "path list length in resolve is " + this.pathList.size());
        if (!string.endsWith(".class")) {
            string = string + ".class";
        }
        Log.LOGN(4, "relative filename now = " + string);
        for (int i = 0; i < this.pathList.size(); ++i) {
            Log.LOGN(5, "pa=" + this.pathList.get(i) + " " + "rfa=" + string);
            FileReference fileReference = FileReference.create(this.pathList.get(i), string);
            if (!fileReference.exists()) continue;
            Log.LOGN(4, "  exists");
            return fileReference;
        }
        return null;
    }

    public synchronized String[] children(String string, FilenameFilter filenameFilter) {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (int i = 0; i < this.pathList.size(); ++i) {
            String[] stringArray;
            FileReference fileReference = FileReference.create(this.pathList.get(i), string);
            if (!fileReference.exists() || (stringArray = fileReference.list(filenameFilter)) == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                if (treeSet.contains(stringArray[j])) continue;
                treeSet.add(stringArray[j]);
            }
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }
}

