/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.Log;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.ConstantValueAttribute;
import kdp.classparser.attributes.DeprecatedAttribute;
import kdp.classparser.attributes.ExceptionsAttribute;
import kdp.classparser.attributes.InnerClassesAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;
import kdp.classparser.attributes.LocalVariableTableAttribute;
import kdp.classparser.attributes.SourceFileAttribute;
import kdp.classparser.attributes.SyntheticAttribute;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class AttributeInfo {
    public static final int ATTR_CODE = 0;
    public static final int ATTR_CONST = 1;
    public static final int ATTR_DEPRECATED = 2;
    public static final int ATTR_EXCEPTIONS = 3;
    public static final int ATTR_INNERCLASS = 4;
    public static final int ATTR_LINENUMBER = 5;
    public static final int ATTR_LOCALVAR = 6;
    public static final int ATTR_SOURCEFILE = 7;
    public static final int ATTR_SYNTHETIC = 8;
    private int attributeNameIndex;
    private int attributeLength;
    private Attribute info;
    private int attrType;
    private ConstantPoolInfo[] constantPool;

    public AttributeInfo(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.attributeNameIndex = dataInputStream.readUnsignedShort();
        this.attributeLength = dataInputStream.readInt();
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        String string = constantUtf8Info.toString();
        if (string.equals("ConstantValue")) {
            this.info = new ConstantValueAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 1;
        } else if (string.equals("Synthetic")) {
            this.info = new SyntheticAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 8;
        } else if (string.equals("Deprecated")) {
            this.info = new DeprecatedAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 2;
        } else if (string.equals("Code")) {
            this.info = new CodeAttribute(dataInputStream, constantPoolInfoArray, this.attributeNameIndex, this.attributeLength);
            this.attrType = 0;
        } else if (string.equals("Exceptions")) {
            this.info = new ExceptionsAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 3;
        } else if (string.equals("InnerClasses")) {
            this.info = new InnerClassesAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 4;
        } else if (string.equals("LineNumberTable")) {
            this.info = new LineNumberTableAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 5;
        } else if (string.equals("SourceFile")) {
            this.info = new SourceFileAttribute(dataInputStream, constantPoolInfoArray, this.attributeNameIndex, this.attributeLength);
            this.attrType = 7;
        } else if (string.equals("LocalVariableTable")) {
            this.info = new LocalVariableTableAttribute(dataInputStream, this.attributeNameIndex, this.attributeLength);
            this.attrType = 6;
        } else {
            Log.LOGN(8, "Unknown attribute: " + string);
            for (int i = 0; i < this.attributeLength; ++i) {
                dataInputStream.readByte();
            }
        }
        this.constantPool = constantPoolInfoArray;
    }

    public Attribute getInfo() {
        return this.info;
    }

    public int getType() {
        return this.attrType;
    }

    public String toString() {
        if (this.info == null) {
            return "AttributeInfo:\n\t\tUnrecognized attribute";
        }
        return "AttributeInfo:\n\t\t" + this.info.toString(this.constantPool);
    }
}

