/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.ExceptionTable;
import kdp.classparser.attributes.LineNumberTableAttribute;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class CodeAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int maxStack;
    private int maxLocals;
    private int codeLength;
    private byte[] code;
    private int exceptionTableLength;
    private ExceptionTable[] exceptionTable;
    private int attributesCount;
    private AttributeInfo[] attributes;

    public CodeAttribute(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray, int n, int n2) throws IOException {
        int n3;
        this.attributeNameIndex = n;
        this.attributeLength = n2;
        this.maxStack = dataInputStream.readUnsignedShort();
        this.maxLocals = dataInputStream.readUnsignedShort();
        this.codeLength = dataInputStream.readInt();
        this.code = new byte[this.codeLength];
        for (n3 = 0; n3 < this.codeLength; ++n3) {
            this.code[n3] = dataInputStream.readByte();
        }
        this.exceptionTableLength = dataInputStream.readUnsignedShort();
        this.exceptionTable = new ExceptionTable[this.exceptionTableLength];
        for (n3 = 0; n3 < this.exceptionTableLength; ++n3) {
            this.exceptionTable[n3] = new ExceptionTable(dataInputStream);
        }
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (n3 = 0; n3 < this.attributesCount; ++n3) {
            this.attributes[n3] = new AttributeInfo(dataInputStream, constantPoolInfoArray);
        }
    }

    public LineNumberTableAttribute getLineNumberTable() {
        int n = 0;
        boolean bl = false;
        while (!bl && n < this.attributesCount) {
            if (this.attributes[n].getType() == 5) {
                bl = true;
                continue;
            }
            ++n;
        }
        if (bl) {
            AttributeInfo attributeInfo = this.attributes[n];
            LineNumberTableAttribute lineNumberTableAttribute = (LineNumberTableAttribute)attributeInfo.getInfo();
            return lineNumberTableAttribute;
        }
        return null;
    }

    public boolean containsLine(int n) {
        LineNumberTableAttribute lineNumberTableAttribute = this.getLineNumberTable();
        if (lineNumberTableAttribute != null) {
            return lineNumberTableAttribute.containsLine(n);
        }
        return false;
    }

    public byte[] getByteCodes() {
        byte[] byArray = new byte[this.code.length];
        System.arraycopy(this.code, 0, byArray, 0, this.code.length);
        return byArray;
    }

    @Override
    public String toString(ConstantPoolInfo[] constantPoolInfoArray) {
        String string = new String("");
        ConstantUtf8Info constantUtf8Info = (ConstantUtf8Info)constantPoolInfoArray[this.attributeNameIndex];
        string = string + constantUtf8Info.toString();
        for (int i = 0; i < this.attributesCount; ++i) {
            string = string + "\n\t\t" + this.attributes[i].toString();
        }
        return string;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }
}

