/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.socket.portforwarder;

import com.sun.jme.toolkit.socket.portforwarder.StopListener;
import com.sun.jme.toolkit.socket.portforwarder.StreamCopier;
import com.sun.jme.toolkit.socket.portforwarder.StreamFilterFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.log4j.Logger;

final class SocketCopier
implements StopListener {
    private static final Logger logger = Logger.getLogger(StreamCopier.class);
    private final Socket socket1;
    private final Socket socket2;
    private final StreamFilterFactory os1To2FilterFactory;
    private final StreamFilterFactory os2To1FilterFactory;
    private final StopListener listener;
    private StreamCopier socket1To2Copier;
    private StreamCopier socket2To1Copier;
    private boolean closed;

    public SocketCopier(Socket socket, Socket socket2, StreamFilterFactory streamFilterFactory, StreamFilterFactory streamFilterFactory2, StopListener stopListener) {
        this.socket1 = socket;
        this.socket2 = socket2;
        this.os1To2FilterFactory = streamFilterFactory;
        this.os2To1FilterFactory = streamFilterFactory2;
        this.listener = stopListener;
    }

    public void start() throws IOException {
        OutputStream outputStream;
        OutputStream outputStream2;
        InputStream inputStream;
        InputStream inputStream2;
        try {
            inputStream2 = this.socket1.getInputStream();
            inputStream = this.socket2.getInputStream();
            outputStream2 = this.os2To1FilterFactory.createFilter(this.socket1.getOutputStream());
            outputStream = this.os1To2FilterFactory.createFilter(this.socket2.getOutputStream());
        }
        catch (IOException iOException) {
            this.closeSocketsAux();
            throw iOException;
        }
        this.socket1To2Copier = new StreamCopier(inputStream2, outputStream, this);
        this.socket2To1Copier = new StreamCopier(inputStream, outputStream2, this);
        this.socket1To2Copier.start();
        this.socket2To1Copier.start();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started copying " + this.socket1 + " <-> " + this.socket2 + "."));
        }
    }

    public void stop() {
        this.socket2To1Copier.stop();
        this.socket1To2Copier.stop();
    }

    public synchronized boolean isStopped() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSockets() {
        boolean bl = false;
        SocketCopier socketCopier = this;
        synchronized (socketCopier) {
            if (!this.closed) {
                this.closeSocketsAux();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Stopped copying " + this.socket1 + " <-> " + this.socket2 + "."));
                }
                this.closed = true;
                bl = true;
            }
        }
        if (bl && this.listener != null) {
            this.listener.stopped(this);
        }
    }

    private void closeSocketsAux() {
        try {
            this.socket1.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.socket2.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void stopped(Object object) {
        if (this.socket1To2Copier.isStopped() && this.socket2To1Copier.isStopped()) {
            this.closeSockets();
        }
    }
}

