/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.appmanager.api.AppManager;
import com.sun.jme.toolkit.ueiproxy.AppManagerHelper;
import com.sun.jme.toolkit.ueiproxy.CommandHandler;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerManager;
import com.sun.jme.toolkit.ueiproxy.RunOptions;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import org.apache.log4j.Logger;

public class DescriptorHandler
implements CommandHandler {
    private static final String COMMAND = "-Xdescriptor";
    private static final Logger logger = Logger.getLogger(DescriptorHandler.class);
    private DeviceControllerManager deviceControllerManager;
    private AppManagerHelper appManagerHelper;
    private String command;

    public void setDeviceControllerManager(DeviceControllerManager deviceControllerManager) {
        this.deviceControllerManager = deviceControllerManager;
    }

    public void setAppManagerHelper(AppManagerHelper appManagerHelper) {
        this.appManagerHelper = appManagerHelper;
    }

    public void processCommand(String string, String[] stringArray, String string2, RunOptions runOptions) throws UeiProxyException {
        if (this.command == null) {
            logger.error((Object)"No UEI command given.");
            throw new IllegalArgumentException("No UEI command given.");
        }
        int n = this.command.indexOf(58);
        if (n == -1 || n + 1 >= this.command.length()) {
            logger.error((Object)("Wrong format of -Xdescriptor argument: " + this.command));
            throw new IllegalArgumentException("Wrong format of -Xdescriptor argument");
        }
        DeviceController deviceController = this.deviceControllerManager.getOrCreateDeviceController(string, stringArray);
        AppManager appManager = (AppManager)deviceController.getObjectFromDevice(AppManager.class, "AppManager");
        String string3 = this.command.substring(n + 1);
        this.appManagerHelper.executeMIDletSuite(deviceController, appManager, string3, true, string2, runOptions);
    }

    public String getCommand() {
        logger.trace((Object)"getCommand() -->");
        logger.trace((Object)"<-- getCommand() = -Xdescriptor");
        return COMMAND;
    }

    public String getCommandDescription() {
        logger.trace((Object)"getCommandDescription() -->");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("-Xdescriptor:<JAD file name>\n");
        stringBuffer.append("                   The JAD file to be executed\n");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("<-- getCommandDescription() = " + stringBuffer.toString()));
        }
        return stringBuffer.toString();
    }

    public boolean requiresDeviceName() {
        return true;
    }

    public boolean addSupportedCommand(String string) {
        if (string.startsWith(COMMAND)) {
            this.command = string;
            return true;
        }
        return false;
    }
}

