/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding;

import com.sun.kvem.beansbinding.Converter;
import com.sun.kvem.beansbinding.Property;
import com.sun.kvem.beansbinding.PropertyWrapper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class Binding<SV, TV> {
    private final Property<SV> sourceBeanProperty;
    private final Property<TV> targetBeanProperty;
    private TV sourceNullValue;
    private SV targetNullValue;
    private boolean isBound;
    private boolean ignoreChange;
    private PropertyChangeListener pcl;
    private Converter<SV, TV> converter;
    private final UpdateStrategy updateStrategy;

    public Binding(UpdateStrategy updateStrategy, Property<SV> property, Property<TV> property2) {
        this.updateStrategy = updateStrategy;
        this.sourceBeanProperty = property;
        this.targetBeanProperty = property2;
    }

    public void bind() {
        if (this.isBound) {
            throw new IllegalStateException("Binding already bound");
        }
        this.pcl = new PCL();
        this.sourceBeanProperty.addValueChangeListener(this.pcl);
        this.targetBeanProperty.addValueChangeListener(this.pcl);
        this.isBound = true;
        UpdateStrategy updateStrategy = this.getUpdateStrategy();
        if (updateStrategy == UpdateStrategy.READ) {
            this.refreshAndNotify();
        } else {
            this.tryRefreshThenSave();
        }
    }

    private UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    public void unbind() {
        if (!this.isBound) {
            throw new IllegalStateException("Binding already unbound");
        }
        this.sourceBeanProperty.removeValueChangeListener(this.pcl);
        this.targetBeanProperty.removeValueChangeListener(this.pcl);
        this.pcl = null;
        this.isBound = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        TV TV = this.getSourceValueForTarget();
        try {
            this.ignoreChange = true;
            this.targetBeanProperty.setValue(TV);
        }
        finally {
            this.ignoreChange = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        SV SV = this.getTargetValueForSource();
        try {
            this.ignoreChange = true;
            this.sourceBeanProperty.setValue(SV);
        }
        finally {
            this.ignoreChange = false;
        }
    }

    private final TV convertForward(SV SV) {
        if (this.converter == null) {
            Class<?> clazz = this.noPrimitiveType(this.targetBeanProperty.getWriteType());
            return (TV)clazz.cast(Converter.defaultConvert(SV, clazz));
        }
        return this.converter.convertForward(SV);
    }

    private final SV convertReverse(TV TV) {
        if (this.converter == null) {
            Class<?> clazz = this.noPrimitiveType(this.sourceBeanProperty.getWriteType());
            return (SV)clazz.cast(Converter.defaultConvert(TV, clazz));
        }
        return this.converter.convertReverse(TV);
    }

    private final Class<?> noPrimitiveType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        throw new AssertionError();
    }

    private final TV getSourceValueForTarget() {
        SV SV = this.sourceBeanProperty.getValue();
        TV TV = SV == null ? this.sourceNullValue : this.convertForward(SV);
        return TV;
    }

    private final SV getTargetValueForSource() {
        TV TV = this.targetBeanProperty.getValue();
        SV SV = TV == null ? this.targetNullValue : this.convertReverse(TV);
        return SV;
    }

    private final void sourceChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.updateStrategy == UpdateStrategy.READ) {
            this.refreshAndNotify();
        } else if (this.updateStrategy == UpdateStrategy.READ_WRITE) {
            this.tryRefreshThenSave();
        }
    }

    private final void targetChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.updateStrategy == UpdateStrategy.READ_WRITE) {
            this.trySaveThenRefresh();
        }
    }

    private void trySaveThenRefresh() {
        this.save();
    }

    private void tryRefreshThenSave() {
        this.refresh();
    }

    private void refreshAndNotify() {
        this.refresh();
    }

    public final void setConverter(Converter<SV, TV> converter) {
        if (this.isBound) {
            throw new IllegalStateException("Binding already bound");
        }
        this.converter = converter;
    }

    private class PCL
    implements PropertyChangeListener {
        private PCL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (Binding.this.ignoreChange) {
                return;
            }
            if (Binding.this.sourceBeanProperty instanceof PropertyWrapper && propertyChangeEvent.getSource() == ((PropertyWrapper)((Binding)Binding.this).sourceBeanProperty).bean || propertyChangeEvent.getSource() == Binding.this.sourceBeanProperty) {
                Binding.this.sourceChanged(propertyChangeEvent);
            } else {
                Binding.this.targetChanged(propertyChangeEvent);
            }
        }
    }

    public static enum UpdateStrategy {
        READ,
        READ_WRITE;

    }
}

