/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding;

import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class Converter<S, T> {
    static final Converter BYTE_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return Byte.toString((Byte)object);
        }

        public Object convertReverse(Object object) {
            return Byte.parseByte((String)object);
        }
    };
    static final Converter SHORT_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return Short.toString((Short)object);
        }

        public Object convertReverse(Object object) {
            return Short.parseShort((String)object);
        }
    };
    static final Converter INT_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return Integer.toString((Integer)object);
        }

        public Object convertReverse(Object object) {
            return Integer.parseInt((String)object);
        }
    };
    static final Converter LONG_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return Long.toString((Long)object);
        }

        public Object convertReverse(Object object) {
            return Long.parseLong((String)object);
        }
    };
    static final Converter FLOAT_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return Float.toString(((Float)object).floatValue());
        }

        public Object convertReverse(Object object) {
            return Float.valueOf(Float.parseFloat((String)object));
        }
    };
    static final Converter DOUBLE_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return Double.toString((Double)object);
        }

        public Object convertReverse(Object object) {
            return Double.parseDouble((String)object);
        }
    };
    static final Converter CHAR_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return ((Character)object).toString();
        }

        public Object convertReverse(Object object) {
            String string = (String)object;
            if (string.length() != 1) {
                throw new IllegalArgumentException("String doesn't represent a char");
            }
            return Character.valueOf(string.charAt(0));
        }
    };
    static final Converter BOOLEAN_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return ((Boolean)object).toString();
        }

        public Object convertReverse(Object object) {
            return Boolean.valueOf((String)object);
        }
    };
    static final Converter INT_TO_BOOLEAN_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            if ((Integer)object == 0) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public Object convertReverse(Object object) {
            if (((Boolean)object).booleanValue()) {
                return 1;
            }
            return 0;
        }
    };
    static final Converter BIGINTEGER_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return ((BigInteger)object).toString();
        }

        public Object convertReverse(Object object) {
            return new BigInteger((String)object);
        }
    };
    static final Converter BIGDECIMAL_TO_STRING_CONVERTER = new Converter(){

        public Object convertForward(Object object) {
            return ((BigDecimal)object).toString();
        }

        public Object convertReverse(Object object) {
            return new BigDecimal((String)object);
        }
    };
    static final Converter BIGDECIMAL_TO_INTEGER = new Converter(){

        public Object convertForward(Object object) {
            return ((BigDecimal)object).intValue();
        }

        public Object convertReverse(Object object) {
            return new BigDecimal((Integer)object);
        }
    };

    public abstract T convertForward(S var1);

    public abstract S convertReverse(T var1);

    public static final Object defaultConvert(Object object, Class<?> clazz) {
        Class<?> clazz2 = object.getClass();
        if (clazz2 == clazz) {
            return object;
        }
        if (clazz == String.class) {
            if (clazz2 == Byte.class) {
                return BYTE_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Short.class) {
                return SHORT_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Integer.class) {
                return INT_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Long.class) {
                return LONG_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Float.class) {
                return FLOAT_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Double.class) {
                return DOUBLE_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Boolean.class) {
                return BOOLEAN_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == Character.class) {
                return CHAR_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == BigInteger.class) {
                return BIGINTEGER_TO_STRING_CONVERTER.convertForward(object);
            }
            if (clazz2 == BigDecimal.class) {
                return BIGDECIMAL_TO_STRING_CONVERTER.convertForward(object);
            }
        } else if (clazz2 == String.class) {
            if (clazz == Byte.class) {
                return BYTE_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Short.class) {
                return SHORT_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Integer.class) {
                return INT_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Long.class) {
                return LONG_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Float.class) {
                return FLOAT_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Double.class) {
                return DOUBLE_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Boolean.class) {
                return BOOLEAN_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == Character.class) {
                return CHAR_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == BigInteger.class) {
                return BIGINTEGER_TO_STRING_CONVERTER.convertReverse(object);
            }
            if (clazz == BigDecimal.class) {
                return BIGDECIMAL_TO_STRING_CONVERTER.convertReverse(object);
            }
        } else if (clazz2 == Integer.class) {
            if (clazz == Boolean.class) {
                return INT_TO_BOOLEAN_CONVERTER.convertForward(object);
            }
            if (clazz == BigDecimal.class) {
                return BIGDECIMAL_TO_INTEGER.convertReverse(object);
            }
        } else {
            if (clazz2 == Boolean.class && clazz == Integer.class) {
                return INT_TO_BOOLEAN_CONVERTER.convertReverse(object);
            }
            if (clazz2 == BigDecimal.class && clazz == Integer.class) {
                return BIGDECIMAL_TO_INTEGER.convertForward(object);
            }
        }
        return object;
    }
}

