/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.beansbinding;

import com.sun.kvem.beansbinding.Property;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PropertyAdapter<T>
implements Property<T> {
    private final Object bean;
    private final String propertyName;
    private final PropertyDescriptor propertyDescriptor;
    private final PropertyChangeSupport pcs;

    public PropertyAdapter(Object object, String string) {
        this(object, string, null);
    }

    PropertyAdapter(Object object, String string, PropertyChangeSupport propertyChangeSupport) {
        if (object == null) {
            throw new NullPointerException("Bean is null");
        }
        if (string == null) {
            throw new NullPointerException("PropertyName is null");
        }
        try {
            this.propertyDescriptor = this.getPropertyDescriptor(object.getClass(), string);
        }
        catch (IntrospectionException introspectionException) {
            throw new IllegalArgumentException("Property " + string + " not found in class " + object.getClass());
        }
        this.bean = object;
        this.propertyName = string;
        this.pcs = propertyChangeSupport == null ? new PropertyChangeSupport(object) : propertyChangeSupport;
    }

    @Override
    public T getValue() {
        Method method = this.propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new UnsupportedOperationException("Unreadable");
        }
        try {
            return (T)method.invoke(this.bean, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unreadable", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Unreadable", invocationTargetException);
        }
    }

    @Override
    public void setValue(T t) {
        Method method = this.propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new UnsupportedOperationException("Unwriteble");
        }
        T t2 = this.getValue();
        try {
            method.invoke(this.bean, t);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException("Unwriteble", invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException("Unwriteble", illegalAccessException);
        }
        if (t2 == null || t == null || !t2.equals(t)) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, this.propertyName, t2, t);
            this.pcs.firePropertyChange(propertyChangeEvent);
        }
    }

    @Override
    public Class<?> getWriteType() {
        if (this.propertyDescriptor.getWriteMethod() == null) {
            throw new UnsupportedOperationException("Unwriteble");
        }
        return this.propertyDescriptor.getPropertyType();
    }

    @Override
    public void addValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(this.propertyName, propertyChangeListener);
    }

    @Override
    public void removeValueChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(this.propertyName, propertyChangeListener);
    }

    private final PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String string) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!string.equals(propertyDescriptor.getName())) continue;
            return propertyDescriptor;
        }
        throw new IntrospectionException("Property \"" + string + "\" not found in bean " + clazz);
    }
}

